/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.JsonQueryFunction;

public class Scope {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    @JsonProperty(value="parent")
    private Scope parentScope;
    @JsonIgnore
    private Map<String, Function> functions = new HashMap<String, Function>();
    @JsonProperty(value="variables")
    private Map<String, JsonNode> values = new HashMap<String, JsonNode>();
    @JsonIgnore
    private ObjectMapper mapper = DEFAULT_MAPPER;

    @JsonProperty(value="functions")
    private Map<String, String> debugFunctions() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, Function> f : this.functions.entrySet()) {
            result.put(f.getKey(), f.getValue().toString());
        }
        return result;
    }

    public Scope() {
        this(RootScopeHolder.scope);
    }

    public Scope(Scope parentScope) {
        this.parentScope = parentScope;
    }

    public void addFunction(String name, int n, Function q) {
        this.functions.put(name + "/" + n, q);
    }

    public void addFunction(String name, Function q) {
        this.functions.put(name, q);
    }

    public Function getFunction(String name, int nargs) {
        Function f = this.getFunctionRecursive(name, nargs);
        if (f != null) {
            return f;
        }
        return this.getFunctionRecursive(name);
    }

    private Function getFunctionRecursive(String name, int nargs) {
        Function q = this.functions.get(name + "/" + nargs);
        if (q == null && this.parentScope != null) {
            return this.parentScope.getFunctionRecursive(name, nargs);
        }
        return q;
    }

    private Function getFunctionRecursive(String name) {
        Function q = this.functions.get(name);
        if (q == null && this.parentScope != null) {
            return this.parentScope.getFunctionRecursive(name);
        }
        return q;
    }

    public void setValue(String name, JsonNode value) {
        this.values.put(name, value);
    }

    public JsonNode getValue(String name) {
        JsonNode value = this.values.get(name);
        if (value == null && this.parentScope != null) {
            return this.parentScope.getValue(name);
        }
        return value;
    }

    @JsonIgnore
    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public static Scope rootScope() {
        return RootScopeHolder.scope;
    }

    private static Collection<Class<?>> classes(List<JqJson> configs) throws IOException {
        HashSet<String> clazzes = new HashSet<String>();
        for (JqJson jqJson : configs) {
            if (jqJson.classes == null) continue;
            for (String className : jqJson.classes) {
                clazzes.add(className);
            }
        }
        ArrayList result = new ArrayList();
        for (String className : clazzes) {
            try {
                result.add(Class.forName(className));
            }
            catch (Throwable th) {
                System.err.println("Failed to load class " + className + ": " + th.getClass().getSimpleName() + ": " + th.getMessage());
            }
        }
        return result;
    }

    private static List<JqJson> readConfig() throws IOException {
        ArrayList<JqJson> result = new ArrayList<JqJson>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = Scope.class.getClassLoader();
        }
        Enumeration<URL> iter = loader.getResources("jq.json");
        while (iter.hasMoreElements()) {
            InputStream is = iter.nextElement().openStream();
            Throwable throwable = null;
            try {
                MappingIterator iter2 = DEFAULT_MAPPER.readValues(DEFAULT_MAPPER.getFactory().createParser(is), JqJson.class);
                while (iter2.hasNext()) {
                    result.add((JqJson)iter2.next());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return result;
    }

    private void loadDefault() {
        try {
            List<JqJson> configs = Scope.readConfig();
            for (Class<?> clazz : Scope.classes(configs)) {
                BuiltinFunction annotation;
                if (!Function.class.isAssignableFrom(clazz) || (annotation = clazz.getAnnotation(BuiltinFunction.class)) == null) continue;
                for (String name : annotation.value()) {
                    this.addFunction(name, (Function)clazz.newInstance());
                }
            }
            for (JqJson jqJson : configs) {
                for (JqJson.JqFuncDef def : jqJson.functions) {
                    this.addFunction(def.name, def.args.size(), new JsonQueryFunction(def.name, def.args, JsonQuery.compile(def.body)));
                }
            }
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to instanciate default Scope object", e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class JqJson {
        @JsonProperty(value="functions")
        public List<JqFuncDef> functions = new ArrayList<JqFuncDef>();
        @JsonProperty(value="classes")
        public List<String> classes = new ArrayList<String>();

        private JqJson() {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class JqFuncDef {
            @JsonProperty(value="name")
            public String name;
            @JsonProperty(value="args")
            public List<String> args = new ArrayList<String>();
            @JsonProperty(value="body")
            public String body;
        }
    }

    @BuiltinFunction(value={"debug_scope/0"})
    public static class DebugScopeFunction
    implements Function {
        @Override
        public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
            HashMap<String, Scope> info = new HashMap<String, Scope>();
            info.put("scope", scope);
            info.put("input", (Scope)in);
            return Collections.singletonList(DEFAULT_MAPPER.valueToTree(info));
        }
    }

    private static final class RootScopeHolder {
        public static final Scope scope = new Scope(null);

        private RootScopeHolder() {
        }

        static {
            try {
                RootScopeHolder.scope.loadDefault();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    }
}

