/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.module.loaders;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.javacc.ExpressionParser;
import net.thisptr.jackson.jq.internal.misc.Pair;
import net.thisptr.jackson.jq.module.Module;
import net.thisptr.jackson.jq.module.ModuleLoader;
import net.thisptr.jackson.jq.module.SimpleModule;

public class FileSystemModuleLoader
implements ModuleLoader {
    private final List<Path> searchPaths;
    private final Version version;
    private final Scope parentScope;
    private final ConcurrentHashMap<Pair<Path, String>, TryOnce<Module>> loadedModules = new ConcurrentHashMap();
    private final ConcurrentHashMap<Pair<Path, String>, TryOnce<JsonNode>> loadedData = new ConcurrentHashMap();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public FileSystemModuleLoader(Scope parentScope, Version version, Path ... searchPaths) {
        ArrayList<Path> absoluteSearchPaths = new ArrayList<Path>();
        for (Path searchPath : searchPaths) {
            if (!searchPath.isAbsolute()) {
                throw new RuntimeException("Search path must be absolute");
            }
            absoluteSearchPaths.add(searchPath);
        }
        this.searchPaths = absoluteSearchPaths;
        this.parentScope = parentScope;
        this.version = version;
    }

    private static final Path resolveModulePath(Path searchPath, String path) {
        Path modulePath = searchPath.getFileSystem().getPath(path, new String[0]);
        if (modulePath.isAbsolute()) {
            throw new RuntimeException("Import path must be relative");
        }
        if (modulePath.getParent() != null && modulePath.getFileName().equals(modulePath.getParent().getFileName())) {
            throw new RuntimeException("module names must not have equal consecutive components: " + path);
        }
        Path resolvedPath = searchPath.resolve(modulePath).normalize();
        if (!resolvedPath.startsWith(searchPath)) {
            throw new RuntimeException("Import path must be within the search path");
        }
        return resolvedPath;
    }

    private static ModuleFile loadModuleFile(Path searchPath, String path, String ext) throws IOException {
        Path resolvedPath = FileSystemModuleLoader.resolveModulePath(searchPath, path);
        Path moduleFilePath = resolvedPath.resolveSibling(resolvedPath.getFileName() + "." + ext);
        try {
            byte[] moduleBytes = Files.readAllBytes(moduleFilePath);
            return new ModuleFile(searchPath, moduleFilePath, moduleBytes);
        }
        catch (FileNotFoundException | NoSuchFileException moduleBytes) {
            Path moduleFilePath2 = resolvedPath.resolve(resolvedPath.getFileName() + "." + ext);
            try {
                byte[] moduleBytes2 = Files.readAllBytes(moduleFilePath2);
                return new ModuleFile(searchPath, moduleFilePath2, moduleBytes2);
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
                return null;
            }
        }
    }

    private Module loadModuleActual(Path searchPath, String path) throws IOException {
        ModuleFile moduleFile = FileSystemModuleLoader.loadModuleFile(searchPath, path, "jq");
        if (moduleFile == null) {
            return null;
        }
        String moduleString = new String(moduleFile.bytes, StandardCharsets.UTF_8);
        FileSystemModule module = new FileSystemModule(this, moduleFile.searchPath, moduleFile.modulePath);
        Scope childScope = Scope.newChildScope(this.parentScope);
        childScope.setCurrentModule(module);
        Expression expr = ExpressionParser.compile(moduleString + " null", this.version);
        expr.apply(childScope, NullNode.getInstance(), null, (o, p) -> {}, false);
        module.addAllFunctions(childScope.getLocalFunctions());
        return module;
    }

    private Pair<List<Path>, String> resolvePathsFromImportDirective(Module caller, String path, JsonNode metadata) throws JsonQueryException {
        JsonNode search;
        List<Path> searchPaths = this.searchPaths;
        String relativePath = path;
        FileSystemModule callerModule = null;
        if (caller instanceof FileSystemModule && (callerModule = (FileSystemModule)caller).loader != this) {
            return null;
        }
        if (metadata != null && (search = metadata.get("search")) != null) {
            if (callerModule == null) {
                throw new JsonQueryException("search path can only be overriden from imported modules, but not from a top-level unnamed module");
            }
            if (!search.isTextual()) {
                throw new JsonQueryException("search path overrides must be a string");
            }
            Path searchPathOverride = callerModule.modulePath.getFileSystem().getPath(search.asText(), new String[0]);
            searchPathOverride = callerModule.modulePath.getParent().resolve(searchPathOverride).normalize();
            if (!searchPathOverride.startsWith(callerModule.searchPath)) {
                throw new JsonQueryException("search path overrides from import metadata must stay within the original search path of the caller module");
            }
            Path resolvedModulePath = FileSystemModuleLoader.resolveModulePath(searchPathOverride, path);
            relativePath = callerModule.searchPath.relativize(resolvedModulePath).toString();
            searchPaths = Collections.singletonList(callerModule.searchPath);
        }
        return Pair.of(searchPaths, relativePath);
    }

    @Override
    public Module loadModule(Module caller, String path, JsonNode metadata) throws JsonQueryException {
        Pair<List<Path>, String> paths = this.resolvePathsFromImportDirective(caller, path, metadata);
        if (paths == null) {
            return null;
        }
        List searchPaths = (List)paths._1;
        String relativePath = (String)paths._2;
        for (Path searchPath : searchPaths) {
            TryOnce tryOnce = this.loadedModules.computeIfAbsent(Pair.of(searchPath, relativePath), p -> new TryOnce());
            try {
                Module module = tryOnce.tryOnce(() -> this.loadModuleActual(searchPath, relativePath));
                if (module == null) continue;
                return module;
            }
            catch (TryOnce.RecursiveInvocationException e) {
                throw new JsonQueryException("module %s is imported recursively", path);
            }
            catch (CompletionException e) {
                throw new JsonQueryException(String.format("failed to load module %s: %s", path, e.getCause().getMessage()), e);
            }
        }
        return null;
    }

    @Override
    public JsonNode loadData(Module caller, String path, JsonNode metadata) throws JsonQueryException {
        Pair<List<Path>, String> paths = this.resolvePathsFromImportDirective(caller, path, metadata);
        if (paths == null) {
            return null;
        }
        List searchPaths = (List)paths._1;
        String relativePath = (String)paths._2;
        for (Path searchPath : searchPaths) {
            TryOnce tryOnce = this.loadedData.computeIfAbsent(Pair.of(searchPath, relativePath), p -> new TryOnce());
            try {
                JsonNode data = tryOnce.tryOnce(() -> this.loadDataActual(searchPath, relativePath));
                if (data == null) continue;
                return data;
            }
            catch (CompletionException e) {
                throw new JsonQueryException(String.format("failed to load data %s: %s", path, e.getCause().getMessage()), e);
            }
        }
        return null;
    }

    private JsonNode loadDataActual(Path searchPath, String path) throws IOException {
        ModuleFile moduleFile = FileSystemModuleLoader.loadModuleFile(searchPath, path, "json");
        if (moduleFile == null) {
            return null;
        }
        ArrayNode data = MAPPER.createArrayNode();
        Iterator iter = MAPPER.readValues(MAPPER.getFactory().createParser(moduleFile.bytes), JsonNode.class);
        while (((MappingIterator)iter).hasNext()) {
            data.add((JsonNode)((MappingIterator)iter).next());
        }
        return data;
    }

    private static final class TryOnce<T> {
        private final CompletableFuture<T> f = new CompletableFuture();
        private final Thread taskThread = Thread.currentThread();
        private boolean taskStarted;

        public T tryOnce(Callable<T> task) throws CompletionException, RecursiveInvocationException {
            if (this.f.isDone()) {
                return this.f.join();
            }
            if (Thread.currentThread() == this.taskThread) {
                if (this.taskStarted) {
                    throw new RecursiveInvocationException();
                }
                this.taskStarted = true;
                try {
                    this.f.complete(task.call());
                }
                catch (Throwable th) {
                    this.f.completeExceptionally(th);
                }
                return this.f.join();
            }
            return this.f.join();
        }

        private static final class RecursiveInvocationException
        extends IllegalStateException {
            private static final long serialVersionUID = 1L;

            private RecursiveInvocationException() {
            }
        }
    }

    private static final class FileSystemModule
    extends SimpleModule {
        private final Path modulePath;
        private final Path searchPath;
        private final FileSystemModuleLoader loader;

        public FileSystemModule(FileSystemModuleLoader loader, Path searchPath, Path modulePath) {
            this.loader = loader;
            this.modulePath = modulePath;
            this.searchPath = searchPath;
        }
    }

    private static final class ModuleFile {
        public final Path searchPath;
        public final Path modulePath;
        public final byte[] bytes;

        public ModuleFile(Path searchPath, Path modulePath, byte[] bytes) {
            this.searchPath = searchPath;
            this.modulePath = modulePath;
            this.bytes = bytes;
        }
    }
}

