/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.misc;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Syntax;

public class OnigUtils {
    public static boolean isGlobal(String flags) {
        if (flags == null) {
            return false;
        }
        return flags.contains("g");
    }

    public static int parseModifiers(String flags) throws JsonQueryException {
        if (flags == null) {
            return 0;
        }
        int result = 0;
        block10: for (byte ch : flags.getBytes(StandardCharsets.UTF_8)) {
            switch (ch) {
                case 103: {
                    continue block10;
                }
                case 105: {
                    result |= 1;
                    continue block10;
                }
                case 109: {
                    result |= 4;
                    continue block10;
                }
                case 110: {
                    result |= 0x20;
                    continue block10;
                }
                case 112: {
                    result |= 0xC;
                    continue block10;
                }
                case 115: {
                    result |= 8;
                    continue block10;
                }
                case 108: {
                    result |= 0x10;
                    continue block10;
                }
                case 120: {
                    result |= 2;
                    continue block10;
                }
                default: {
                    throw new JsonQueryException("%s is not a valid modifier string", flags);
                }
            }
        }
        return result;
    }

    public static class Pattern {
        public final Regex regex;
        public final boolean global;
        public final String[] names;

        public Pattern(String regexText, String flags) throws JsonQueryException {
            int modifiers = OnigUtils.parseModifiers(flags) | 0x100;
            byte[] regexBytes = regexText.getBytes(StandardCharsets.UTF_8);
            this.regex = new Regex(regexBytes, 0, regexBytes.length, modifiers, (Encoding)UTF8Encoding.INSTANCE, Syntax.PerlNG);
            this.global = OnigUtils.isGlobal(flags);
            this.names = Pattern.names(this.regex);
        }

        private static String[] names(Regex regex) {
            String[] names = new String[regex.numberOfCaptures() + 1];
            if (regex.numberOfNames() == 0) {
                return names;
            }
            Iterator<NameEntry> iter = regex.namedBackrefIterator();
            while (iter.hasNext()) {
                NameEntry backref = iter.next();
                String name = new String(backref.name, backref.nameP, backref.nameEnd - backref.nameP, StandardCharsets.UTF_8);
                for (int index : backref.getBackRefs()) {
                    names[index] = name;
                }
            }
            return names;
        }
    }
}

