/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.auto.service.AutoService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.OnigUtils;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.jackson.jq.path.Path;
import org.joni.Matcher;
import org.joni.Region;

@BuiltinFunction(value={"_sub_impl/3"})
@AutoService(value={Function.class})
public class _SubImplFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        Preconditions.checkInputType("_sub_impl/3", in, JsonNodeType.STRING);
        args.get(0).apply(scope, in, regexText -> {
            Preconditions.checkArgumentType("_sub_impl/3", 1, regexText, JsonNodeType.STRING);
            ((Expression)args.get(2)).apply(scope, in, flagsText -> {
                Preconditions.checkArgumentType("_sub_impl/3", 3, flagsText, JsonNodeType.STRING);
                OnigUtils.Pattern p = new OnigUtils.Pattern(regexText.asText(), flagsText.asText());
                List<JsonNode> match = _SubImplFunction.match(scope.getObjectMapper(), p, in.asText());
                ((Expression)args.get(2)).apply(scope, in, dummy -> this.replaceAndConcat(scope, new Stack<String>(), output, match, (Expression)args.get(1), in, (Expression)args.get(2)));
            });
        });
    }

    private void replaceAndConcat(Scope scope, Stack<String> stack, PathOutput output, List<JsonNode> match, Expression replaceExpr, JsonNode in, Expression flags) throws JsonQueryException {
        if (match.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = stack.size() - 1; i >= 0; --i) {
                sb.append((String)stack.get(i));
            }
            output.emit(new TextNode(sb.toString()), null);
            return;
        }
        JsonNode rhead = match.get(match.size() - 1);
        List<JsonNode> rtail = match.subList(0, match.size() - 1);
        if (rhead.isTextual()) {
            stack.push(rhead.textValue());
            this.replaceAndConcat(scope, stack, output, rtail, replaceExpr, in, flags);
            stack.pop();
        } else {
            replaceExpr.apply(scope, rhead, replacement -> {
                stack.push(replacement.asText());
                this.replaceAndConcat(scope, stack, output, rtail, replaceExpr, in, flags);
                stack.pop();
            });
        }
    }

    private static List<JsonNode> match(ObjectMapper mapper, OnigUtils.Pattern pattern, String inputText) {
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        byte[] inputBytes = inputText.getBytes(StandardCharsets.UTF_8);
        Matcher m = pattern.regex.matcher(inputBytes);
        int offset = 0;
        while (m.search(offset, inputBytes.length, 0) >= 0) {
            result.add(TextNode.valueOf(new String(inputBytes, offset, m.getBegin() - offset, StandardCharsets.UTF_8)));
            ObjectNode captures = mapper.createObjectNode();
            Region regions = m.getRegion();
            if (regions != null) {
                for (int i = 1; i < regions.numRegs; ++i) {
                    String name = pattern.names[i];
                    if (name == null) continue;
                    if (regions.beg[i] >= 0) {
                        String value = new String(inputBytes, regions.beg[i], regions.end[i] - regions.beg[i], StandardCharsets.UTF_8);
                        captures.set(name, TextNode.valueOf(value));
                        continue;
                    }
                    captures.set(name, NullNode.getInstance());
                }
            }
            result.add(captures);
            offset = m.getEnd();
            if (pattern.global && offset != inputBytes.length) continue;
        }
        result.add(TextNode.valueOf(new String(inputBytes, offset, inputBytes.length - offset, StandardCharsets.UTF_8)));
        return result;
    }
}

