/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.auto.service.AutoService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.OnigUtils;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.jackson.jq.internal.misc.UnicodeUtils;
import net.thisptr.jackson.jq.path.Path;
import org.joni.Matcher;
import org.joni.Region;

@BuiltinFunction(value={"_match_impl/3"})
@AutoService(value={Function.class})
public class _MatchImplFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        Preconditions.checkInputType("_match_impl/3", in, JsonNodeType.STRING);
        byte[] ibytes = in.asText().getBytes(StandardCharsets.UTF_8);
        int[] cindex = UnicodeUtils.UTF8CharIndex(ibytes);
        args.get(2).apply(scope, in, test -> {
            Preconditions.checkArgumentType("_match_impl/3", 3, test, JsonNodeType.BOOLEAN);
            ((Expression)args.get(1)).apply(scope, in, flags -> {
                Preconditions.checkArgumentType("_match_impl/3", 2, flags, JsonNodeType.STRING, JsonNodeType.NULL);
                ((Expression)args.get(0)).apply(scope, in, regex -> {
                    Preconditions.checkArgumentType("_match_impl/3", 1, regex, JsonNodeType.STRING);
                    OnigUtils.Pattern p = new OnigUtils.Pattern(regex.asText(), flags.isNull() ? null : flags.asText());
                    output.emit(_MatchImplFunction.match(scope.getObjectMapper(), p, ibytes, cindex, test.asBoolean()), null);
                });
            });
        });
    }

    private static JsonNode match(ObjectMapper mapper, OnigUtils.Pattern pattern, byte[] ibytes, int[] cindex, boolean test) {
        Matcher m = pattern.regex.matcher(ibytes);
        if (test) {
            boolean match = m.search(0, ibytes.length, 0) >= 0;
            return BooleanNode.valueOf(match);
        }
        ArrayNode matches = mapper.createArrayNode();
        int offset = 0;
        while (m.search(offset, ibytes.length, 0) >= 0) {
            MatchObject obj = new MatchObject();
            obj.offset = cindex[m.getBegin()];
            obj.length = cindex[m.getEnd()] - cindex[m.getBegin()];
            obj.string = new String(ibytes, m.getBegin(), m.getEnd() - m.getBegin());
            Region regions = m.getRegion();
            if (regions != null && m.getEnd() != m.getBegin()) {
                for (int i = 1; i < regions.numRegs; ++i) {
                    CaptureObject capture = new CaptureObject();
                    if (regions.beg[i] >= 0) {
                        capture.offset = cindex[regions.beg[i]];
                        capture.length = cindex[regions.end[i]] - cindex[regions.beg[i]];
                        capture.string = new String(ibytes, regions.beg[i], regions.end[i] - regions.beg[i], StandardCharsets.UTF_8);
                    } else {
                        capture.offset = -1;
                        capture.length = 0;
                        capture.string = null;
                    }
                    capture.name = pattern.names[i];
                    obj.captures.add(capture);
                }
            }
            matches.add((JsonNode)mapper.valueToTree(obj));
            offset = m.getEnd() == offset ? ++offset : m.getEnd();
            if (pattern.global && offset != ibytes.length) continue;
        }
        return matches;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class MatchObject {
        @JsonProperty(value="offset")
        public int offset;
        @JsonProperty(value="length")
        public int length;
        @JsonProperty(value="string")
        public String string;
        @JsonProperty(value="captures")
        public List<CaptureObject> captures = new ArrayList<CaptureObject>();

        MatchObject() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class CaptureObject {
        @JsonProperty(value="offset")
        public int offset;
        @JsonProperty(value="length")
        public int length;
        @JsonProperty(value="string")
        public String string;
        @JsonProperty(value="name")
        public String name;

        private CaptureObject() {
        }
    }
}

