/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.auto.service.AutoService;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.path.Path;
import net.thisptr.jackson.jq.path.RootPath;

@BuiltinFunction(value={"path/1"})
@AutoService(value={Function.class})
public class PathFunction
implements Function {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        args.get(0).apply(scope, in, RootPath.getInstance(), (obj, path) -> {
            if (path == null && in.isValueNode() && JsonNodeComparator.getInstance().compare(in, obj) == 0) {
                path = RootPath.getInstance();
            }
            if (path == null) {
                throw new JsonQueryException("Invalid path expression with result %s", JsonNodeUtils.toString(obj));
            }
            ArrayNode out = MAPPER.createArrayNode();
            path.toJsonNode(out);
            output.emit(out, null);
        }, true);
    }
}

