/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.filters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.path.Path;

public abstract class AbstractSvFilter
implements Function {
    protected abstract String name();

    protected abstract void appendSeparator(StringBuilder var1);

    protected abstract void appendEscaped(StringBuilder var1, String var2);

    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        if (!in.isArray()) {
            throw new JsonQueryTypeException("%s cannot be %s-formatted, only array", in, this.name());
        }
        boolean heading = true;
        StringBuilder row = new StringBuilder();
        for (JsonNode col : in) {
            if (!heading) {
                this.appendSeparator(row);
            }
            if (col.isTextual()) {
                this.appendEscaped(row, col.asText());
            } else if (!col.isNull()) {
                if (col.isBoolean() || col.isNumber()) {
                    try {
                        row.append(scope.getObjectMapper().writeValueAsString(col));
                    }
                    catch (JsonProcessingException e) {
                        throw new JsonQueryException(e);
                    }
                } else {
                    throw new JsonQueryTypeException("%s is not valid in a csv row", col);
                }
            }
            heading = false;
        }
        output.emit(TextNode.valueOf(row.toString()), null);
    }
}

