/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.exception;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.misc.Strings;

public class JsonQueryException
extends JsonProcessingException {
    private static final long serialVersionUID = -7241258446595502920L;
    private static final int MAX_JSON_STRING_LENGTH = 14;

    public JsonQueryException(String msg) {
        super(msg);
    }

    public JsonQueryException(Throwable e) {
        super(e);
    }

    public JsonQueryException(String msg, Throwable rootCause) {
        super(msg, rootCause);
    }

    public JsonNode getMessageAsJsonNode() {
        return new TextNode(this.getMessage());
    }

    public JsonQueryException(String format, Object ... args) {
        this(JsonQueryException.format(format, args));
    }

    private static String format(String format, Object ... args) {
        Object[] formattedArguments = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof JsonNode) {
                String json;
                JsonNode node = (JsonNode)args[i];
                try {
                    json = Strings.truncate(JsonNodeUtils.toString(node), 14);
                }
                catch (Exception e) {
                    json = "<failed to format json>";
                }
                formattedArguments[i] = String.format("%s (%s)", node.getNodeType().toString().toLowerCase(), json);
                continue;
            }
            if (args[i] instanceof JsonNodeType) {
                JsonNodeType type = (JsonNodeType)((Object)args[i]);
                formattedArguments[i] = type.toString().toLowerCase();
                continue;
            }
            formattedArguments[i] = args[i];
        }
        return String.format(format, formattedArguments);
    }
}

