/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.internal.misc.JsonQueryJacksonModule;
import net.thisptr.jackson.jq.path.Path;

public class Scope {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper().registerModule(JsonQueryJacksonModule.getInstance());
    @JsonProperty(value="parent")
    private Scope parentScope;
    @JsonIgnore
    private Map<String, Function> functions;
    @JsonProperty(value="variables")
    private Map<String, ValueWithPath> values;
    @JsonIgnore
    private ObjectMapper mapper = DEFAULT_MAPPER;

    @JsonProperty(value="functions")
    private Map<String, String> debugFunctions() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, Function> f : this.functions.entrySet()) {
            result.put(f.getKey(), f.getValue().toString());
        }
        return result;
    }

    private Scope(Scope parentScope) {
        this.parentScope = parentScope;
    }

    public static Scope newEmptyScope() {
        return new Scope(null);
    }

    public static Scope newChildScope(Scope scope) {
        return new Scope(scope);
    }

    public void addFunction(String name, int n, Function q) {
        this.addFunction(name + "/" + n, q);
    }

    public void addFunction(String name, Function q) {
        if (this.functions == null) {
            this.functions = new HashMap<String, Function>();
        }
        this.functions.put(name, q);
    }

    public Function getFunction(String name, int nargs) {
        Function f = this.getFunctionRecursive(name + "/" + nargs);
        if (f != null) {
            return f;
        }
        return this.getFunctionRecursive(name);
    }

    private Function getFunctionRecursive(String name) {
        Function q;
        if (this.functions != null && (q = this.functions.get(name)) != null) {
            return q;
        }
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.getFunctionRecursive(name);
    }

    public void setValue(String name, JsonNode value) {
        this.setValueWithPath(name, value, null);
    }

    public void setValueWithPath(String name, JsonNode value, Path path) {
        if (this.values == null) {
            this.values = new HashMap<String, ValueWithPath>();
        }
        this.values.put(name, new ValueWithPathImpl(value, path));
    }

    public ValueWithPath getValueWithPath(String name) {
        ValueWithPath value;
        if (this.values != null && (value = this.values.get(name)) != null) {
            return value;
        }
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.getValueWithPath(name);
    }

    public JsonNode getValue(String name) {
        ValueWithPath value = this.getValueWithPath(name);
        if (value == null) {
            return null;
        }
        return value.value();
    }

    @JsonIgnore
    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    private static class ValueWithPathImpl
    implements ValueWithPath {
        @JsonProperty(value="value")
        private final JsonNode value;
        @JsonProperty(value="path")
        private final Path path;

        public ValueWithPathImpl(JsonNode value, Path path) {
            this.value = value;
            this.path = path;
        }

        @Override
        public JsonNode value() {
            return this.value;
        }

        @Override
        public Path path() {
            return this.path;
        }
    }

    public static interface ValueWithPath {
        public JsonNode value();

        public Path path();
    }
}

