/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.VersionRange;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.IsolatedScopeQuery;
import net.thisptr.jackson.jq.internal.JsonQueryFunction;
import net.thisptr.jackson.jq.internal.javacc.ExpressionParser;
import net.thisptr.jackson.jq.internal.misc.VersionRangeDeserializer;

public class BuiltinFunctionLoader {
    private static BuiltinFunctionLoader INSTANCE = new BuiltinFunctionLoader();
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private static final String CONFIG_PATH = BuiltinFunctionLoader.resolvePath(Scope.class, "jq.json");

    public static BuiltinFunctionLoader getInstance() {
        return INSTANCE;
    }

    private BuiltinFunctionLoader() {
    }

    private static String resolvePath(Class<?> clazz, String name) {
        String base = clazz.getName();
        return base.substring(0, base.lastIndexOf(46)).replace('.', '/') + '/' + name;
    }

    public Map<String, Function> listFunctions(ClassLoader classLoader, Version version, Scope closureScope) {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        this.loadMacros(functions, classLoader, version, closureScope);
        this.loadBuiltinFunctions(functions, version, classLoader);
        return functions;
    }

    public Map<String, Function> listFunctions(Version version, Scope closureScope) {
        return this.listFunctions(BuiltinFunctionLoader.class.getClassLoader(), version, closureScope);
    }

    public void loadFunctions(Version version, Scope closureScope) {
        this.listFunctions(version, closureScope).forEach(closureScope::addFunction);
    }

    public void loadFunctions(ClassLoader classLoader, Version version, Scope closureScope) {
        this.listFunctions(classLoader, version, closureScope).forEach(closureScope::addFunction);
    }

    private static List<JqJson> loadConfig(ClassLoader loader, String path) throws IOException {
        ArrayList<JqJson> result = new ArrayList<JqJson>();
        Enumeration<URL> iter = loader.getResources(path);
        while (iter.hasMoreElements()) {
            StringBuilder buffer = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(iter.nextElement().openStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    buffer.append(line);
                    buffer.append('\n');
                }
            }
            Iterator iter2 = DEFAULT_MAPPER.readValues(DEFAULT_MAPPER.getFactory().createParser(buffer.toString()), JqJson.class);
            while (((MappingIterator)iter2).hasNext()) {
                result.add((JqJson)((MappingIterator)iter2).next());
            }
        }
        return result;
    }

    private void loadBuiltinFunctions(Map<String, Function> functions, Version version, ClassLoader classLoader) {
        for (Function fn : ServiceLoader.load(Function.class, classLoader)) {
            VersionRange range;
            BuiltinFunction annotation = fn.getClass().getAnnotation(BuiltinFunction.class);
            if (annotation == null || !annotation.version().isEmpty() && !(range = VersionRange.valueOf(annotation.version())).contains(version)) continue;
            for (String name : annotation.value()) {
                functions.put(name, fn);
            }
        }
    }

    private void loadMacros(Map<String, Function> functions, ClassLoader classLoader, Version version, Scope closureScope) {
        try {
            List<JqJson> configs = BuiltinFunctionLoader.loadConfig(classLoader, CONFIG_PATH);
            for (JqJson jqJson : configs) {
                for (JqJson.JqFuncDef def : jqJson.functions) {
                    if (def.version != null && !def.version.contains(version)) continue;
                    functions.put(def.name + "/" + def.args.size(), new JsonQueryFunction(def.name, def.args, new IsolatedScopeQuery(ExpressionParser.compile(def.body, version)), closureScope));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load macros", e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class JqJson {
        @JsonProperty(value="functions")
        public List<JqFuncDef> functions = new ArrayList<JqFuncDef>();

        private JqJson() {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        private static class JqFuncDef {
            @JsonProperty(value="name")
            public String name;
            @JsonProperty(value="args")
            public List<String> args = new ArrayList<String>();
            @JsonProperty(value="body")
            public String body;
            @JsonProperty(value="version")
            @JsonDeserialize(using=VersionRangeDeserializer.class)
            public VersionRange version;

            private JqFuncDef() {
            }
        }
    }
}

