/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nwork.filescanner.tags;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsGlob;
import net.thevpc.nuts.NutsSession;

class PathFilterList {
    PatternGroupConf includes;
    PatternGroupConf excludes;
    List<Path> alreadyIgnored = new ArrayList<Path>();
    NutsSession session;

    public PathFilterList(NutsSession session) {
        this.session = session;
        this.includes = new PatternGroupConf(session);
        this.excludes = new PatternGroupConf(session);
    }

    public void loadFrom(Path file) {
        if (Files.isRegularFile(file, new LinkOption[0])) {
            try {
                Files.lines(file).forEach(x -> this.add(file.getParent(), (String)x));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    public boolean markIgnored(Path root) {
        if (!this.isIgnoredOrParent(root)) {
            if (Files.isDirectory(root, new LinkOption[0])) {
                this.alreadyIgnored.add(root);
            }
            return true;
        }
        return false;
    }

    public boolean isIgnoredOrParent(Path root) {
        for (Path path : this.alreadyIgnored) {
            if (!path.equals(root) && !root.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    public void add(Path root, String line) {
        if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
            return;
        }
        if (line.startsWith("!")) {
            line = line.substring(1).trim();
            this.excludes.add(root, line);
        } else {
            this.includes.add(root, line);
        }
    }

    public boolean accept(Path p) {
        boolean e;
        boolean i = this.includes.size() > 0;
        boolean bl = e = this.excludes.size() > 0;
        if (i && e) {
            return this.includes.accept(p) && !this.excludes.accept(p);
        }
        if (i) {
            return this.includes.accept(p);
        }
        if (e) {
            return !this.excludes.accept(p);
        }
        return true;
    }

    private static class PatternGroupConf {
        HashSet<String> prefixes = new HashSet();
        HashSet<String> exact = new HashSet();
        HashSet<Pattern> patterns = new HashSet();
        NutsSession session;

        public PatternGroupConf(NutsSession session) {
            this.session = session;
        }

        public int size() {
            return this.prefixes.size() + this.exact.size() + this.patterns.size();
        }

        public void add(Path root, String line) {
            if (line.isEmpty()) {
                return;
            }
            while (line.startsWith("/")) {
                line = line.substring(1);
            }
            String a = (line.isEmpty() ? root : root.resolve(line)).toString();
            NutsGlob glob = NutsGlob.of((NutsSession)this.session).setSeparator("/\\");
            if (glob.isGlob(a)) {
                this.patterns.add(glob.toPattern(a));
            } else {
                this.exact.add(a);
            }
        }

        public boolean accept(Path path) {
            String s = path.toString();
            if (this.exact.contains(s)) {
                return true;
            }
            for (String prefix : this.exact) {
                if (!s.startsWith(prefix)) continue;
                if (s.length() == prefix.length()) {
                    return true;
                }
                return s.charAt(prefix.length()) == '/';
            }
            for (String prefix : this.prefixes) {
                if (!s.startsWith(prefix)) continue;
                if (s.length() == prefix.length()) {
                    return true;
                }
                return s.charAt(prefix.length()) == '/';
            }
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(s).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

