/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nwork.filescanner.tags;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.toolbox.nwork.filescanner.DefaultTagInfo;
import net.thevpc.nuts.toolbox.nwork.filescanner.TagInfo;
import net.thevpc.nuts.toolbox.nwork.filescanner.TagScanner;
import net.thevpc.nuts.toolbox.nwork.filescanner.tags.PathFilterList;

public class GitIgnoreTagScanner
implements TagScanner {
    @Override
    public String[] supportedTags() {
        return new String[]{"git-ignored", ".gitignore"};
    }

    @Override
    public TagInfo[] scanTags(Path path, Set<String> tags, Map<String, Object> shared) {
        ArrayList<DefaultTagInfo> ti = new ArrayList<DefaultTagInfo>();
        GitIgnoreFile ii = (GitIgnoreFile)shared.get(GitIgnoreFile.class.getName());
        if (path.getFileName().toString().equalsIgnoreCase(".gitignore")) {
            if (ii == null) {
                ii = new GitIgnoreFile(ii.session);
            }
            shared.put(GitIgnoreFile.class.getName(), ii);
            ii.loadFrom(path);
            ti.add(new DefaultTagInfo(".gitignore"));
        } else if (ii != null && ii.accept(path)) {
            if (path.toString().endsWith(".java") && !path.toString().contains("/target/")) {
                ii.accept(path);
            }
            ti.add(new DefaultTagInfo("git-ignored-all"));
            if (ii.markIgnored(path)) {
                ti.add(new DefaultTagInfo("git-ignored"));
            }
        }
        return ti.toArray(new TagInfo[0]);
    }

    public static class GitIgnoreFile
    extends PathFilterList {
        public GitIgnoreFile(NutsSession session) {
            super(session);
        }
    }
}

