/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nwork.filescanner;

import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.thevpc.nuts.toolbox.nwork.filescanner.DefaultRichPath;
import net.thevpc.nuts.toolbox.nwork.filescanner.FileScanner;
import net.thevpc.nuts.toolbox.nwork.filescanner.RichPath;
import net.thevpc.nuts.toolbox.nwork.filescanner.TagInfo;
import net.thevpc.nuts.toolbox.nwork.filescanner.TagScanner;

class PathRichPathFunction
implements Function<Path, RichPath> {
    private final Set<String> effSupportedTags = new LinkedHashSet<String>();
    private final Set<TagScanner> effSupportedTagScanners = new LinkedHashSet<TagScanner>();
    private FileScanner fs;
    private Map<String, Object> shared;

    public PathRichPathFunction(FileScanner fs, Map<String, Object> shared) {
        this.fs = fs;
        this.shared = shared;
        if (fs.getTagScanners() != null) {
            for (TagScanner tagScanner : fs.getTagScanners()) {
                for (String st : tagScanner.supportedTags()) {
                    if (fs.getSupportedTags() != null && !fs.getSupportedTags().test(st)) continue;
                    this.effSupportedTags.add(st);
                    this.effSupportedTagScanners.add(tagScanner);
                }
            }
        }
    }

    @Override
    public RichPath apply(Path path) {
        LinkedHashSet<TagInfo> tagInfo = new LinkedHashSet<TagInfo>();
        for (TagScanner s : this.effSupportedTagScanners) {
            TagInfo[] r = s.scanTags(path, this.effSupportedTags, this.shared);
            if (r == null || r.length == 0) continue;
            for (TagInfo i : r) {
                if (i == null) continue;
                tagInfo.add(i);
            }
        }
        return new DefaultRichPath(path, tagInfo, this.shared);
    }
}

