/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nwork.filescanner;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.thevpc.nuts.NutsExpr;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.toolbox.nwork.filescanner.PathRichPathFunction;
import net.thevpc.nuts.toolbox.nwork.filescanner.RichPath;
import net.thevpc.nuts.toolbox.nwork.filescanner.TagScanner;
import net.thevpc.nuts.toolbox.nwork.filescanner.tags.BackupIgnoreTagScanner;
import net.thevpc.nuts.toolbox.nwork.filescanner.tags.GitIgnoreTagScanner;
import net.thevpc.nuts.toolbox.nwork.filescanner.tags.GradleProjectTagScanner;
import net.thevpc.nuts.toolbox.nwork.filescanner.tags.MavenProjectTagScanner;
import net.thevpc.nuts.toolbox.nwork.filescanner.tags.NodeJsProjectTagScanner;

public class FileScanner {
    public static final String NODEJS_PROJECT = "nodejs-project";
    public static final String GRADLE_PROJECT = "gradle-project";
    public static final String MAVEN_PROJECT = "maven-project";
    public static final String PROJECT_ROOT = "project-root";
    private final List<TagScanner> tagScanners = new ArrayList<TagScanner>();
    private final List<Path> source = new ArrayList<Path>();
    private Predicate<RichPath> pathFilter;
    private Predicate<String> supportedTags;

    public FileScanner() {
        this.getTagScanners().add(new MavenProjectTagScanner());
        this.getTagScanners().add(new GradleProjectTagScanner());
        this.getTagScanners().add(new NodeJsProjectTagScanner());
        this.getTagScanners().add(new GitIgnoreTagScanner());
        this.getTagScanners().add(new BackupIgnoreTagScanner());
    }

    public static Predicate<RichPath> parseExpr(String anyStr, NutsSession session) {
        NutsExpr evaluator = NutsExpr.of((NutsSession)session);
        evaluator.setFunction("tag", new NutsExpr.Fct(){

            public Object eval(String name, NutsExpr.Node[] args, NutsExpr context) {
                Object v;
                RichPath rc = (RichPath)context.getVar("this");
                for (NutsExpr.Node arg : args) {
                    v = arg.eval(context);
                    if (v == null || rc.getTags((String)context.evalFunction("string", new Object[]{v})).size() != 0) continue;
                    return false;
                }
                if (rc.getPath().toString().endsWith(".java")) {
                    for (NutsExpr.Node arg : args) {
                        v = arg.eval(context);
                        if (v == null || rc.getTags((String)context.evalFunction("string", new Object[]{v})).size() != 0) continue;
                        return false;
                    }
                }
                return true;
            }
        });
        evaluator.setVar("path", (NutsExpr.Var)new RichVar("path"));
        evaluator.setVar("name", (NutsExpr.Var)new RichVar("name"));
        evaluator.setVar("length", (NutsExpr.Var)new RichVar("length"));
        evaluator.setVar("size", (NutsExpr.Var)new RichVar("size"));
        evaluator.setVar("dir", (NutsExpr.Var)new RichVar("dir"));
        evaluator.setVar("file", (NutsExpr.Var)new RichVar("file"));
        evaluator.setVar("readable", (NutsExpr.Var)new RichVar("readable"));
        evaluator.setVar("executable", (NutsExpr.Var)new RichVar("executable"));
        evaluator.setVar("exists", (NutsExpr.Var)new RichVar("exists"));
        evaluator.setVar("hidden", (NutsExpr.Var)new RichVar("hidden"));
        evaluator.setVar("symbolic", (NutsExpr.Var)new RichVar("symbolic"));
        evaluator.setVar("writable", (NutsExpr.Var)new RichVar("writable"));
        evaluator.setVar("owner", (NutsExpr.Var)new RichVar("owner"));
        evaluator.setVar("lastModified", (NutsExpr.Var)new RichVar("lastModified"));
        NutsExpr.Node node = evaluator.parse(anyStr);
        return richPath -> {
            evaluator.setVar("this", (NutsExpr.Var)new RichVarThis((RichPath)richPath));
            return (Boolean)evaluator.evalFunction("boolean", new Object[]{evaluator.evalNode(node)});
        };
    }

    public List<TagScanner> getTagScanners() {
        return this.tagScanners;
    }

    public List<Path> getSource() {
        return this.source;
    }

    public Predicate<RichPath> getPathFilter() {
        return this.pathFilter;
    }

    public FileScanner setPathFilter(Predicate<RichPath> pathFilter) {
        this.pathFilter = pathFilter;
        return this;
    }

    public Predicate<String> getSupportedTags() {
        return this.supportedTags;
    }

    public FileScanner setSupportedTags(Predicate<String> supportedTags) {
        this.supportedTags = supportedTags;
        return this;
    }

    public Stream<RichPath> scan() {
        LinkedHashMap<String, Object> shared = new LinkedHashMap<String, Object>();
        PathRichPathFunction m = new PathRichPathFunction(this, shared);
        Stream<RichPath> a = null;
        for (Path s : this.source) {
            try {
                if (Files.isRegularFile(s, new LinkOption[0])) {
                    if (a == null) {
                        a = Stream.of(m.apply(s));
                        continue;
                    }
                    a = Stream.concat(a, Stream.of(m.apply(s)));
                    continue;
                }
                if (!Files.isDirectory(s, new LinkOption[0])) continue;
                Stream<RichPath> z = Files.walk(s, new FileVisitOption[0]).map(m);
                if (a == null) {
                    a = z;
                    continue;
                }
                a = Stream.concat(a, z);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (a == null) {
            return Stream.empty();
        }
        Predicate<RichPath> p = this.getPathFilter();
        if (p != null) {
            a = a.filter(p);
        }
        return a;
    }

    private static class RichVar
    implements NutsExpr.Var {
        private final String name;

        public RichVar(String name) {
            this.name = name;
        }

        RichPath getThis(NutsExpr context) {
            NutsExpr.Var r = context.getVar("this");
            return (RichPath)r.get("this", context);
        }

        public Object get(String name, NutsExpr context) {
            RichPath richPath = this.getThis(context);
            switch (name) {
                case "path": {
                    return richPath.getPath().toString();
                }
                case "name": {
                    return richPath.getPath().getFileName().toString();
                }
                case "length": 
                case "size": {
                    long size = 0L;
                    try {
                        size = Files.size(richPath.getPath());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return size;
                }
                case "dir": {
                    return Files.isDirectory(richPath.getPath(), new LinkOption[0]);
                }
                case "file": {
                    return Files.isRegularFile(richPath.getPath(), new LinkOption[0]);
                }
                case "readable": {
                    return Files.isReadable(richPath.getPath());
                }
                case "executable": {
                    return Files.isExecutable(richPath.getPath());
                }
                case "exists": {
                    return Files.exists(richPath.getPath(), new LinkOption[0]);
                }
                case "hidden": {
                    try {
                        return Files.isHidden(richPath.getPath());
                    }
                    catch (Exception size) {
                        return false;
                    }
                }
                case "symbolic": {
                    try {
                        return Files.isSymbolicLink(richPath.getPath());
                    }
                    catch (Exception size) {
                        return false;
                    }
                }
                case "writable": {
                    try {
                        return Files.isWritable(richPath.getPath());
                    }
                    catch (Exception size) {
                        return false;
                    }
                }
                case "owner": {
                    try {
                        UserPrincipal o = Files.getOwner(richPath.getPath(), new LinkOption[0]);
                        if (o != null) {
                            return o.getName();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
                case "lastModified": {
                    try {
                        return Files.getLastModifiedTime(richPath.getPath(), new LinkOption[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }
            return null;
        }

        public void set(String name, Object value, NutsExpr context) {
        }
    }

    private static class RichVarThis
    implements NutsExpr.Var {
        private final RichPath richPath;

        public RichVarThis(RichPath richPath) {
            this.richPath = richPath;
        }

        public Object get(String name, NutsExpr context) {
            return this.richPath;
        }

        public void set(String name, Object value, NutsExpr context) {
        }
    }
}

