/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nwork;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Stack;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorProperty;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectFormat;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsVersionParser;
import net.thevpc.nuts.toolbox.ndiff.jar.Diff;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffItem;
import net.thevpc.nuts.toolbox.ndiff.jar.DiffResult;
import net.thevpc.nuts.toolbox.nwork.ProjectService;
import net.thevpc.nuts.toolbox.nwork._StringUtils;
import net.thevpc.nuts.toolbox.nwork.config.ProjectConfig;
import net.thevpc.nuts.toolbox.nwork.config.RepositoryAddress;
import net.thevpc.nuts.toolbox.nwork.config.WorkspaceConfig;
import net.thevpc.nuts.toolbox.nwork.filescanner.FileScanner;

public class WorkspaceService {
    public static final String SCAN = "net.thevpc.nuts.toolbox.nwork.scan";
    private WorkspaceConfig config;
    private final NutsApplicationContext appContext;
    private final NutsPath sharedConfigFolder;

    public WorkspaceService(NutsApplicationContext appContext) {
        this.appContext = appContext;
        this.sharedConfigFolder = appContext.getVersionFolder(NutsStoreLocation.CONFIG, "0.8.0.0");
        NutsPath c = this.getConfigFile();
        if (c.isRegularFile()) {
            try {
                NutsSession session = appContext.getSession();
                this.config = (WorkspaceConfig)NutsElements.of((NutsSession)session).json().parse(c, WorkspaceConfig.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.config == null) {
            this.config = new WorkspaceConfig();
        }
    }

    public static String wildcardToRegex(String pattern) {
        if (pattern == null) {
            pattern = "*";
        }
        char[] cc = pattern.toCharArray();
        StringBuilder sb = new StringBuilder("^");
        block5: for (int i = 0; i < cc.length; ++i) {
            char c = cc[i];
            switch (c) {
                case '$': 
                case '+': 
                case '.': 
                case '{': 
                case '}': {
                    sb.append('\\').append(c);
                    continue block5;
                }
                case '?': {
                    sb.append(".");
                    continue block5;
                }
                case '*': {
                    sb.append(".*");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('$');
        return sb.toString();
    }

    public WorkspaceConfig getWorkspaceConfig() {
        RepositoryAddress v = this.config.getDefaultRepositoryAddress();
        if (v == null) {
            v = new RepositoryAddress();
            this.config.setDefaultRepositoryAddress(v);
        }
        return this.config;
    }

    public void setWorkspaceConfig(WorkspaceConfig c) {
        if (c == null) {
            c = new WorkspaceConfig();
        }
        this.config = c;
        NutsPath configFile = this.getConfigFile();
        configFile.mkParentDirs();
        NutsSession session = this.appContext.getSession();
        NutsElements.of((NutsSession)session).json().setValue((Object)c).print(configFile);
    }

    private void updateBools(Boolean[] all, boolean ok) {
        boolean positive = false;
        boolean negative = false;
        for (Boolean anAll : all) {
            if (anAll == null) continue;
            if (anAll.booleanValue()) {
                positive = true;
                continue;
            }
            negative = true;
        }
        boolean fill = false;
        if (!positive && !negative) {
            fill = true;
        } else if (negative) {
            fill = true;
        } else if (positive) {
            fill = false;
        }
        for (int i = 0; i < all.length; ++i) {
            if (all[i] != null) continue;
            all[i] = fill;
        }
    }

    public void enableScan(NutsCommandLine commandLine, NutsApplicationContext context, boolean enable) {
        int count = 0;
        while (commandLine.hasNext()) {
            if (commandLine.peek().isNonOption()) {
                String expression = commandLine.next().getString();
                if (!commandLine.isExecMode()) continue;
                this.setScanEnabled(Paths.get(expression, new String[0]), enable);
                ++count;
                continue;
            }
            context.configureLast(commandLine);
        }
        if (count == 0) {
            throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"missing projects", (Object[])new Object[0]), 1);
        }
    }

    public void list(NutsCommandLine cmd, NutsApplicationContext appContext) {
        ArrayList<String> filters = new ArrayList<String>();
        cmd.setCommandName("nwork list");
        while (cmd.hasNext()) {
            NutsArgument a = cmd.requireNonOption().next();
            if (a != null) {
                filters.add(a.getString());
                continue;
            }
            appContext.configureLast(cmd);
        }
        if (cmd.isExecMode()) {
            ArrayList<ProjectConfig> result = new ArrayList<ProjectConfig>();
            for (ProjectService projectService : this.findProjectServices()) {
                if (!this.matches(projectService.getConfig().getId(), filters)) continue;
                ProjectConfig config = projectService.getConfig();
                result.add(config);
            }
            result.sort(Comparator.comparing(ProjectConfig::getId));
            if (appContext.getSession().isPlainOut()) {
                for (ProjectConfig p2 : result) {
                    appContext.getSession().out().println((NutsString)this.formatProjectConfig(appContext, p2));
                }
            } else {
                NutsObjectFormat.of((NutsSession)appContext.getSession()).setValue(result).println();
            }
        }
    }

    private NutsTextBuilder formatProjectConfig(NutsApplicationContext appContext, ProjectConfig p2) {
        NutsTexts text = NutsTexts.of((NutsSession)appContext.getSession());
        return text.builder().append((Object)p2.getId(), NutsTextStyle.primary4()).append((Object)" ").appendJoined((Object)text.ofPlain(", "), (Collection)p2.getTechnologies().stream().map(x -> text.ofStyled(x, NutsTextStyle.primary5())).collect(Collectors.toList())).append((Object)" : ").append((Object)p2.getPath(), NutsTextStyle.path());
    }

    public void scan(NutsCommandLine cmdLine, NutsApplicationContext context) {
        NutsSession session = context.getSession();
        boolean interactive = false;
        boolean run = false;
        boolean reset = false;
        ArrayList<File> toScan = new ArrayList<File>();
        while (cmdLine.hasNext()) {
            NutsArgument a = cmdLine.nextBoolean(new String[]{"-i", "--interactive"});
            if (a != null) {
                interactive = a.getBooleanValue();
                continue;
            }
            a = cmdLine.nextBoolean(new String[]{"-r", "--reset"});
            if (a != null) {
                reset = a.getBooleanValue();
                continue;
            }
            if (cmdLine.peek().isNonOption()) {
                String folder = cmdLine.nextNonOption(NutsArgumentName.of((String)"Folder", (NutsSession)session)).getString();
                run = true;
                toScan.add(new File(folder));
                continue;
            }
            context.configureLast(cmdLine);
        }
        if (cmdLine.isExecMode()) {
            if (reset) {
                this.resetAllProjectServices();
            }
            if (!reset && toScan.isEmpty()) {
                toScan.add(new File("."));
            }
            int scanned = this.scan(toScan, interactive);
            if (this.appContext.getSession().isPlainOut()) {
                this.appContext.getSession().out().printf("##SUMMARY## : %s projects scanned%n", new Object[]{scanned});
            }
        }
    }

    public void find(NutsCommandLine cmdLine, NutsApplicationContext context) {
        NutsSession session = context.getSession();
        ArrayList<File> toScan = new ArrayList<File>();
        String where = null;
        while (cmdLine.hasNext()) {
            NutsArgument a = cmdLine.nextString(new String[]{"-w", "--where"});
            if (a != null) {
                where = a.getValue().getString();
                continue;
            }
            if (cmdLine.peek().isNonOption()) {
                String folder = cmdLine.nextNonOption(NutsArgumentName.of((String)"Folder", (NutsSession)session)).getString();
                toScan.add(new File(folder));
                continue;
            }
            context.configureLast(cmdLine);
        }
        if (cmdLine.isExecMode()) {
            int scanned = this.find(toScan, where);
            if (this.appContext.getSession().isPlainOut()) {
                this.appContext.getSession().out().printf("##SUMMARY## : %s projects scanned%n", new Object[]{scanned});
            }
        }
    }

    public void status(NutsCommandLine cmd, NutsApplicationContext appContext) {
        boolean progress = true;
        boolean verbose = false;
        Boolean commitable = null;
        Boolean dirty = null;
        Boolean newP = null;
        Boolean uptodate = null;
        Boolean old = null;
        Boolean invalid = null;
        ArrayList<String> filters = new ArrayList<String>();
        while (cmd.hasNext()) {
            if (appContext.configureFirst(cmd)) continue;
            NutsArgument a = cmd.nextBoolean(new String[]{"-c", "--commitable", "--changed"});
            if (a != null) {
                commitable = a.getBooleanValue();
                continue;
            }
            a = cmd.nextBoolean(new String[]{"-d", "--dirty"});
            if (a != null) {
                dirty = a.getBooleanValue();
                continue;
            }
            a = cmd.nextBoolean(new String[]{"-w", "--new"});
            if (a != null) {
                newP = a.getBooleanValue();
                continue;
            }
            a = cmd.nextBoolean(new String[]{"-o", "--old"});
            if (a != null) {
                old = a.getBooleanValue();
                continue;
            }
            a = cmd.nextBoolean(new String[]{"-0", "--ok", "--uptodate"});
            if (a != null) {
                uptodate = a.getBooleanValue();
                continue;
            }
            a = cmd.nextBoolean(new String[]{"-e", "--invalid", "--error"});
            if (a != null) {
                invalid = a.getBooleanValue();
                continue;
            }
            a = cmd.nextBoolean(new String[]{"-p", "--progress"});
            if (a != null) {
                progress = a.getBooleanValue();
                continue;
            }
            a = cmd.nextBoolean(new String[]{"-v", "--verbose"});
            if (a != null) {
                verbose = a.getBooleanValue();
                continue;
            }
            if (cmd.peek().isOption()) {
                cmd.setCommandName("nwork check").unexpectedArgument();
                continue;
            }
            filters.add(cmd.next().getString());
        }
        Boolean[] b = new Boolean[]{commitable, newP, uptodate, old, invalid, dirty};
        this.updateBools(b, true);
        commitable = b[0];
        newP = b[1];
        uptodate = b[2];
        old = b[3];
        invalid = b[4];
        dirty = b[5];
        HashMap<String, NutsDescriptor> dependencies = new HashMap<String, NutsDescriptor>();
        ArrayList<DataRow> ddd = new ArrayList<DataRow>();
        List<ProjectService> all = this.findProjectServices();
        all.sort((x, y) -> x.getConfig().getId().compareTo(y.getConfig().getId()));
        NutsSession session = appContext.getSession();
        for (ProjectService projectService : all) {
            String id = projectService.getConfig().getId();
            NutsDescriptor pom = projectService.getPom();
            if (pom == null) continue;
            dependencies.put(NutsId.of((String)id, (NutsSession)session).getShortName(), pom);
        }
        Iterator<ProjectService> iterator = all.iterator();
        while (iterator.hasNext()) {
            ProjectService projectService;
            projectService = iterator.next();
            if (this.matches(projectService.getConfig().getId(), filters)) continue;
            iterator.remove();
        }
        int maxSize = 1;
        NutsVersionParser parser = NutsVersionParser.of((NutsSession)session);
        for (int i = 0; i < all.size(); ++i) {
            ProjectService projectService = all.get(i);
            DataRow dataRow = new DataRow();
            dataRow.id = projectService.getConfig().getId();
            NutsDescriptor pom = (NutsDescriptor)dependencies.get(NutsId.of((String)dataRow.id, (NutsSession)session).getShortName());
            if (pom != null) {
                for (NutsDependency dependency : pom.getDependencies()) {
                    String did = dependency.getGroupId() + ":" + dependency.getArtifactId();
                    NutsDescriptor expectedPom = (NutsDescriptor)dependencies.get(NutsId.of((String)did, (NutsSession)session).getShortName());
                    if (expectedPom == null) continue;
                    String expectedVersion = expectedPom.getId().getVersion().toString();
                    String currentVersion = dependency.getVersion().toString();
                    if ((currentVersion = currentVersion.trim()).contains("$")) {
                        for (NutsDescriptorProperty entry : pom.getProperties()) {
                            String k = "${" + entry.getName() + "}";
                            if (!currentVersion.equals(k)) continue;
                            currentVersion = entry.getValue();
                            break;
                        }
                    }
                    if (Objects.equals(expectedVersion, currentVersion)) continue;
                    dataRow.dependencies.add(new DiffVersion(did, currentVersion, expectedVersion));
                }
            }
            if (progress && session.isPlainOut()) {
                maxSize = Math.max(maxSize, projectService.getConfig().getId().length());
                session.out().resetLine().printf("(%s / %s) %s", new Object[]{i + 1, all.size(), _StringUtils.alignLeft(projectService.getConfig().getId(), maxSize)});
            }
            dataRow.local = projectService.detectLocalVersion();
            String string = dataRow.remote = dataRow.local == null ? null : projectService.detectRemoteVersion();
            if (dataRow.local == null) {
                dataRow.status = "invalid";
                dataRow.local = "";
                dataRow.remote = "";
            } else if (dataRow.remote == null) {
                dataRow.remote = "";
                dataRow.status = "new";
            } else {
                int t = parser.parse(dataRow.local).compareTo(dataRow.remote);
                if (t > 0) {
                    dataRow.status = "commitable";
                } else if (t < 0) {
                    dataRow.status = "old";
                } else {
                    File l = projectService.detectLocalVersionFile(dataRow.id + "#" + dataRow.local);
                    File r = projectService.detectRemoteVersionFile(dataRow.id + "#" + dataRow.remote);
                    if (l != null && r != null) {
                        DiffResult result = Diff.of((File)l, (File)r).verbose(verbose).eval();
                        if (result.hasChanges()) {
                            dataRow.status = "dirty";
                            if (verbose) {
                                dataRow.details = result.all();
                            }
                        } else {
                            dataRow.status = "uptodate";
                        }
                    } else {
                        dataRow.status = "uptodate";
                    }
                }
            }
            ddd.add(dataRow);
        }
        if (all.size() > 0) {
            session.out().println("");
        }
        Collections.sort(ddd);
        Iterator iterator2 = ddd.iterator();
        while (iterator2.hasNext()) {
            DataRow d = (DataRow)iterator2.next();
            switch (d.status) {
                case "invalid": {
                    if (invalid.booleanValue()) break;
                    iterator2.remove();
                    break;
                }
                case "new": {
                    if (newP.booleanValue()) break;
                    iterator2.remove();
                    break;
                }
                case "commitable": {
                    if (commitable.booleanValue()) break;
                    iterator2.remove();
                    break;
                }
                case "dirty": {
                    if (dirty.booleanValue()) break;
                    iterator2.remove();
                    break;
                }
                case "old": {
                    if (old.booleanValue()) break;
                    iterator2.remove();
                    break;
                }
                case "uptodate": {
                    if (uptodate.booleanValue()) break;
                    iterator2.remove();
                }
            }
        }
        if (!ddd.isEmpty() || !session.isPlainOut()) {
            NutsTexts tfactory = NutsTexts.of((NutsSession)session);
            if (session.isPlainOut()) {
                for (DataRow dataRow : ddd) {
                    String status = dataRow.status;
                    NutsTexts tf = NutsTexts.of((NutsSession)session);
                    for (int len = tf.parse(status).textLength(); len < 10; ++len) {
                        status = status + " ";
                    }
                    switch (tf.ofPlain(dataRow.status).filteredText()) {
                        case "new": {
                            session.out().printf("[%s] %s : %s", new Object[]{tfactory.ofStyled("new", NutsTextStyle.primary3()), dataRow.id, tfactory.ofStyled(dataRow.local, NutsTextStyle.primary2())});
                            break;
                        }
                        case "commitable": {
                            session.out().printf("[%s] %s : %s - %s", new Object[]{tfactory.ofStyled("commitable", NutsTextStyle.primary4()), dataRow.id, tfactory.ofStyled(dataRow.local, NutsTextStyle.primary2()), dataRow.remote});
                            break;
                        }
                        case "dirty": {
                            session.out().printf("[```error dirty```] %s : ```error %s``` - %s", new Object[]{dataRow.id, dataRow.local, dataRow.remote});
                            this.printDiffResults("  ", session.out(), dataRow.details);
                            break;
                        }
                        case "old": {
                            session.out().printf("[%s] %s : ```error %s``` - %s", new Object[]{tfactory.ofStyled("old", NutsTextStyle.primary2()), dataRow.id, dataRow.local, dataRow.remote});
                            break;
                        }
                        case "invalid": {
                            session.out().printf("[```error invalid```invalid ] %s : ```error %s``` - %s", new Object[]{dataRow.id, dataRow.local, dataRow.remote});
                            break;
                        }
                        case "uptodate": {
                            session.out().printf("[uptodate] %s : %s", new Object[]{dataRow.id, dataRow.local});
                            break;
                        }
                        default: {
                            session.out().printf("[%s] %s : %s - %s", new Object[]{status, dataRow.id, dataRow.local, dataRow.remote});
                        }
                    }
                    if (dataRow.dependencies.size() > 0) {
                        session.out().printf((Object)" ; bad-deps:");
                        for (DiffVersion dependency : dataRow.dependencies) {
                            session.out().printf(" %s : %s <> expected %s", new Object[]{dependency.id, parser.parse(dependency.current), parser.parse(dependency.expected)});
                        }
                    }
                    session.out().println();
                }
            } else {
                NutsObjectFormat.of((NutsSession)session).setValue(ddd).println();
            }
        }
    }

    private void printDiffResults(String prefix, NutsPrintStream out, List<DiffItem> result) {
        if (result != null) {
            for (DiffItem diffItem : result) {
                out.printf("%s%s%n", new Object[]{prefix, diffItem});
                this.printDiffResults(prefix + "  ", out, diffItem.children());
            }
        }
    }

    private boolean matches(String id, List<String> filters) {
        boolean accept = filters.isEmpty();
        if (!accept) {
            NutsSession session = this.appContext.getSession();
            NutsId nid = NutsId.of((String)id, (NutsSession)session);
            for (String filter : filters) {
                if (!id.equals(filter) && !id.matches(WorkspaceService.wildcardToRegex(filter)) && !nid.getArtifactId().equals(filter)) continue;
                accept = true;
                break;
            }
        }
        return accept;
    }

    public NutsPath getConfigFile() {
        return this.sharedConfigFolder.resolve("workspace.projects");
    }

    public void resetAllProjectServices() {
        NutsPath storeLocation = this.sharedConfigFolder.resolve("projects");
        if (storeLocation.isDirectory()) {
            for (NutsPath file : storeLocation.list().toList()) {
                if (!file.isRegularFile() || !file.getName().endsWith(".config")) continue;
                file.delete();
            }
        }
    }

    public List<ProjectService> findProjectServices() {
        ArrayList<ProjectService> all = new ArrayList<ProjectService>();
        NutsPath storeLocation = this.sharedConfigFolder.resolve("projects");
        if (storeLocation.isDirectory()) {
            for (NutsPath file : storeLocation.list().toList()) {
                if (!file.isRegularFile() || !file.getName().endsWith(".config")) continue;
                try {
                    all.add(new ProjectService(this.appContext, this.config.getDefaultRepositoryAddress(), file));
                }
                catch (IOException iOException) {}
            }
        }
        return all;
    }

    public int find(List<File> folders, String where) {
        FileScanner fs = new FileScanner();
        if (where != null && where.trim().length() > 0) {
            fs.setPathFilter(FileScanner.parseExpr(where, this.appContext.getSession()));
        }
        fs.getSource().addAll(folders.stream().map(File::toPath).collect(Collectors.toSet()));
        fs.scan().forEach(x -> this.appContext.getSession().out().printf("%s%n", new Object[]{x}));
        return 0;
    }

    public int scan(List<File> folders, boolean interactive) {
        boolean structuredOutContentType;
        Stack<File> stack = new Stack<File>();
        ArrayList<ScanResult> result = new ArrayList<ScanResult>();
        for (File folder : folders) {
            stack.push(folder);
        }
        int scanned = 0;
        NutsSession session = this.appContext.getSession();
        boolean bl = structuredOutContentType = session.isTrace() && session.getOutputFormat() != NutsContentType.PLAIN;
        while (!stack.isEmpty()) {
            File[] aa;
            File folder = (File)stack.pop();
            if (!folder.isDirectory() || !this.isScanEnabled(folder)) continue;
            NutsTexts text = NutsTexts.of((NutsSession)session);
            ProjectConfig p2 = new ProjectService(this.appContext, this.config.getDefaultRepositoryAddress(), new ProjectConfig().setPath(folder.getPath())).rebuildProjectMetadata();
            if (p2.getTechnologies().size() > 0) {
                ProjectService projectService = new ProjectService(this.appContext, this.config.getDefaultRepositoryAddress(), p2);
                boolean loaded = false;
                try {
                    loaded = projectService.load();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (loaded) {
                    ProjectConfig p3 = projectService.getConfig();
                    if (p3.equals(p2)) {
                        if (session.isPlainOut()) {
                            session.out().printf("already registered project folder %s%n", new Object[]{this.formatProjectConfig(this.appContext, p2)});
                        }
                        if (structuredOutContentType) {
                            result.add(new ScanResult(folder.getPath(), "already-registered", NutsMessage.cstyle((String)"already registered project folder %s", (Object[])new Object[]{this.formatProjectConfig(this.appContext, p2)}).toString()));
                        }
                    } else if (!p2.getPath().equals(p3.getPath())) {
                        if (session.isPlainOut()) {
                            session.out().printf("```error [CONFLICT]``` multiple paths for the same id %s. please consider adding .nuts-info file with net.thevpc.nuts.toolbox.nwork.scan=false  :  %s -- %s%n", new Object[]{text.ofStyled(p2.getId(), NutsTextStyle.primary2()), text.ofStyled(p2.getPath(), NutsTextStyle.path()), text.ofStyled(p3.getPath(), NutsTextStyle.path())});
                        }
                        if (structuredOutContentType) {
                            result.add(new ScanResult(folder.getPath(), "conflict", NutsMessage.cstyle((String)"[CONFLICT] multiple paths for the same id %s. please consider adding .nuts-info file with net.thevpc.nuts.toolbox.nwork.scan=false  :  %s -- %s", (Object[])new Object[]{p2.getId(), p2.getPath(), p3.getPath()}).toString()));
                        }
                    } else {
                        if (session.isPlainOut()) {
                            session.out().printf("reloaded project folder %s%n", new Object[]{this.formatProjectConfig(this.appContext, p2)});
                        }
                        if (structuredOutContentType) {
                            result.add(new ScanResult(folder.getPath(), "reloaded", NutsMessage.cstyle((String)"reloaded project folder %s", (Object[])new Object[]{this.formatProjectConfig(this.appContext, p2).toString()}).toString()));
                        }
                        ProjectService ps = new ProjectService(this.appContext, null, p2);
                        try {
                            ps.save();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        ++scanned;
                    }
                } else {
                    String id;
                    if (session.isPlainOut()) {
                        session.out().printf("detected Project Folder %s%n", new Object[]{this.formatProjectConfig(this.appContext, p2)});
                    }
                    if (interactive && !NutsBlankable.isBlank((String)(id = session.getTerminal().readLine("enter Id %s: ", new Object[]{p2.getId() == null ? "" : "(" + text.ofPlain(p2.getId()) + ")"})))) {
                        p2.setId(id);
                    }
                    if (structuredOutContentType) {
                        result.add(new ScanResult(folder.getPath(), "detected", NutsMessage.cstyle((String)"detected Project Folder", (Object[])new Object[0]).toString()));
                    }
                    ProjectService ps = new ProjectService(this.appContext, null, p2);
                    try {
                        ps.save();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++scanned;
                }
            }
            for (File file : aa = folder.listFiles()) {
                if (!file.isDirectory()) continue;
                stack.push(file);
            }
        }
        if (structuredOutContentType) {
            session.out().printlnf(result);
        }
        return scanned;
    }

    public void setScanEnabled(Path folder, boolean enable) {
        Path ni = folder.resolve(".nuts-info");
        Map p = null;
        boolean scan = true;
        NutsSession session = this.appContext.getSession();
        if (Files.isRegularFile(ni, new LinkOption[0])) {
            try {
                String v;
                p = (Map)NutsElements.of((NutsSession)session).json().parse(ni, Map.class);
                String string = v = p.get(SCAN) == null ? null : String.valueOf(p.get(SCAN));
                if (v == null || "false".equals(v.trim())) {
                    scan = false;
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        if (scan != enable) {
            if (p == null) {
                p = new Properties();
            }
            p.put(SCAN, enable);
            NutsElements.of((NutsSession)session).json().setValue((Object)p).print(ni);
        }
    }

    public boolean isScanEnabled(File folder) {
        boolean scan = true;
        File ni = new File(folder, ".nuts-info");
        Map p = null;
        if (ni.isFile()) {
            try {
                String v;
                NutsSession session = this.appContext.getSession();
                p = (Map)NutsElements.of((NutsSession)session).json().parse(ni, Map.class);
                String string = v = p.get(SCAN) == null ? null : String.valueOf(p.get(SCAN));
                if (v == null || "false".equals(v.trim())) {
                    scan = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return scan;
    }

    public int setWorkspaceConfigParam(NutsCommandLine cmd, NutsApplicationContext appContext) {
        while (cmd.hasNext()) {
            WorkspaceConfig conf;
            NutsArgument a = cmd.nextString(new String[]{"-r", "--repo"});
            if (a != null) {
                conf = this.getWorkspaceConfig();
                conf.getDefaultRepositoryAddress().setNutsRepository(a.getValue().getString());
                this.setWorkspaceConfig(conf);
                continue;
            }
            a = cmd.nextString(new String[]{"-w", "--workspace"});
            if (a != null) {
                conf = this.getWorkspaceConfig();
                conf.getDefaultRepositoryAddress().setNutsWorkspace(a.getValue().getString());
                this.setWorkspaceConfig(conf);
                continue;
            }
            cmd.setCommandName("nwork set").unexpectedArgument();
        }
        return 0;
    }

    static class DataRow
    implements Comparable<DataRow> {
        String id;
        String local;
        String remote;
        String status;
        List<DiffItem> details;
        List<DiffVersion> dependencies = new ArrayList<DiffVersion>();

        DataRow() {
        }

        @Override
        public int compareTo(DataRow o) {
            int v = this.status.compareTo(o.status);
            if (v != 0) {
                return v;
            }
            v = this.id.compareTo(o.id);
            return v;
        }
    }

    static class DiffVersion {
        String id;
        String current;
        String expected;

        public DiffVersion(String id, String current, String expected) {
            this.id = id;
            this.current = current;
            this.expected = expected;
        }
    }

    public static class ScanResult {
        String path;
        String status;
        String message;

        public ScanResult(String path, String status, String message) {
            this.path = path;
            this.message = message;
            this.status = status;
            System.out.println(this.path + " " + status);
        }
    }
}

