/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nwork;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsBootOptions;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsDescriptorStyle;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepositoryFilters;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.toolbox.nwork.config.ProjectConfig;
import net.thevpc.nuts.toolbox.nwork.config.RepositoryAddress;

public class ProjectService {
    private ProjectConfig config;
    private final NutsApplicationContext appContext;
    private final RepositoryAddress defaultRepositoryAddress;
    private final NutsPath sharedConfigFolder;

    public ProjectService(NutsApplicationContext context, RepositoryAddress defaultRepositoryAddress, NutsPath file) throws IOException {
        this.appContext = context;
        this.defaultRepositoryAddress = defaultRepositoryAddress == null ? new RepositoryAddress() : defaultRepositoryAddress;
        NutsSession session = context.getSession();
        this.config = (ProjectConfig)NutsElements.of((NutsSession)session).json().parse(file, ProjectConfig.class);
        this.sharedConfigFolder = context.getVersionFolder(NutsStoreLocation.CONFIG, "0.8.0.0");
    }

    public ProjectService(NutsApplicationContext context, RepositoryAddress defaultRepositoryAddress, ProjectConfig config) {
        this.config = config;
        this.appContext = context;
        this.defaultRepositoryAddress = defaultRepositoryAddress;
        this.sharedConfigFolder = context.getVersionFolder(NutsStoreLocation.CONFIG, "0.8.0.0");
    }

    public ProjectConfig getConfig() {
        return this.config;
    }

    public boolean updateProjectMetadata() throws IOException {
        ProjectConfig p2 = this.rebuildProjectMetadata();
        if (!p2.equals(this.config)) {
            this.save();
            return true;
        }
        return false;
    }

    public NutsPath getConfigFile() {
        NutsPath storeLocation = this.sharedConfigFolder.resolve("projects");
        return storeLocation.resolve(this.config.getId().replace(":", "-") + ".config");
    }

    public void save() throws IOException {
        NutsPath configFile = this.getConfigFile();
        configFile.mkParentDirs();
        NutsSession session = this.appContext.getSession();
        NutsElements.of((NutsSession)session).json().setValue((Object)this.config).print(configFile);
    }

    public boolean load() {
        NutsSession session;
        ProjectConfig u;
        NutsPath configFile = this.getConfigFile();
        if (configFile.isRegularFile() && (u = (ProjectConfig)NutsElements.of((NutsSession)(session = this.appContext.getSession())).json().parse(configFile, ProjectConfig.class)) != null) {
            this.config = u;
            return true;
        }
        return false;
    }

    public NutsDescriptor getPom() {
        File f = new File(this.config.getPath());
        if (f.isDirectory() && new File(f, "pom.xml").isFile()) {
            try {
                NutsSession session = this.appContext.getSession();
                return NutsDescriptorParser.of((NutsSession)session).setDescriptorStyle(NutsDescriptorStyle.MAVEN).parse(new File(f, "pom.xml"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public ProjectConfig rebuildProjectMetadata() {
        ProjectConfig p2 = new ProjectConfig();
        p2.setId(this.config.getId());
        p2.setAddress(this.config.getAddress());
        p2.setPath(this.config.getPath());
        File f = new File(this.config.getPath());
        if (f.isDirectory()) {
            if (new File(f, "pom.xml").isFile()) {
                try {
                    NutsSession session = this.appContext.getSession();
                    NutsDescriptor g = NutsDescriptorParser.of((NutsSession)session).setDescriptorStyle(NutsDescriptorStyle.MAVEN).parse(new File(f, "pom.xml"));
                    if (!(g.getId().getGroupId() == null || g.getId().getArtifactId() == null || g.getId().getVersion() == null || g.getId().getGroupId().contains("$") || g.getId().getArtifactId().contains("$") || g.getId().getVersion().toString().contains("$"))) {
                        String s = new String(Files.readAllBytes(new File(f, "pom.xml").toPath()));
                        int ok = 0;
                        if (s.contains("<artifactId>site-maven-plugin</artifactId>")) {
                            p2.getTechnologies().add("github-deploy");
                            ++ok;
                        }
                        if (s.contains("<artifactId>nexus-staging-maven-plugin</artifactId>")) {
                            p2.getTechnologies().add("nexus-deploy");
                            ++ok;
                        }
                        if (s.contains("<phase>deploy</phase>")) {
                            ++ok;
                        }
                        if (ok > 0) {
                            if (p2.getId() == null) {
                                p2.setId(g.getId().getGroupId() + ":" + g.getId().getArtifactId());
                            }
                            if (new File(f, "src/main").isDirectory()) {
                                p2.getTechnologies().add("maven");
                            }
                            if (new File(f, "src/main/java").isDirectory()) {
                                p2.getTechnologies().add("java");
                            }
                            if (new File(f, "src/main/webapp").isDirectory()) {
                                p2.getTechnologies().add("web");
                            }
                        }
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            p2.setZombie(true);
        }
        return p2;
    }

    public File detectLocalVersionFile(String sid) {
        File f;
        NutsSession session = this.appContext.getSession();
        NutsId id = NutsId.of((String)sid, (NutsSession)session);
        if (this.config.getTechnologies().contains("maven") && (f = new File(System.getProperty("user.home"), ".m2/repository/" + id.getGroupId().replace('.', File.separatorChar) + File.separatorChar + id.getArtifactId() + File.separatorChar + id.getVersion() + File.separatorChar + id.getArtifactId() + "-" + id.getVersion() + ".jar")).exists()) {
            return f;
        }
        return null;
    }

    public String detectLocalVersion() {
        File f;
        if (this.config.getTechnologies().contains("maven") && (f = new File(this.config.getPath())).isDirectory() && new File(f, "pom.xml").isFile()) {
            try {
                NutsSession session = this.appContext.getSession();
                return NutsDescriptorParser.of((NutsSession)session).setDescriptorStyle(NutsDescriptorStyle.MAVEN).parse(new File(f, "pom.xml")).getId().getVersion().toString();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public File detectRemoteVersionFile(String sid) {
        NutsSession session = this.appContext.getSession();
        NutsId id = NutsId.of((String)sid, (NutsSession)session);
        if (this.config.getTechnologies().contains("maven")) {
            String nutsRepository;
            RepositoryAddress a = this.config.getAddress();
            if (a == null) {
                a = this.defaultRepositoryAddress;
            }
            if (a == null) {
                a = new RepositoryAddress();
            }
            if (NutsBlankable.isBlank((String)(nutsRepository = a.getNutsRepository()))) {
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"missing repository. try 'nwork set -r vpc-public-maven' or something like that", (Object[])new Object[0]), 2);
            }
            try {
                NutsSession s = null;
                if (a.getNutsWorkspace() != null && a.getNutsWorkspace().trim().length() > 0 && !a.getNutsWorkspace().equals(session.locations().getWorkspaceLocation().toString())) {
                    s = Nuts.openWorkspace((NutsBootOptions)new NutsBootOptions().setOpenMode(NutsOpenMode.OPEN_OR_ERROR).setReadOnly(Boolean.valueOf(true)).setWorkspace(a.getNutsWorkspace()));
                    s.copyFrom(session);
                } else {
                    s = session;
                }
                List found = s.search().addId(sid).addRepositoryFilter(NutsRepositoryFilters.of((NutsSession)s).byName(new String[]{nutsRepository})).setLatest(true).setSession(s).setContent(true).getResultDefinitions().toList();
                if (found.size() > 0) {
                    Path p = ((NutsDefinition)found.get(0)).getContent().getFile();
                    if (p == null) {
                        return null;
                    }
                    return p.toFile();
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public String detectRemoteVersion() {
        File f;
        if (this.config.getTechnologies().contains("maven") && (f = new File(this.config.getPath())).isDirectory() && new File(f, "pom.xml").isFile()) {
            RepositoryAddress a = this.config.getAddress();
            if (a == null) {
                a = this.defaultRepositoryAddress;
            }
            if (a == null) {
                a = new RepositoryAddress();
            }
            String nutsRepository = a.getNutsRepository();
            NutsSession session = this.appContext.getSession();
            if (NutsBlankable.isBlank((String)nutsRepository)) {
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"missing repository. try 'nwork set -r vpc-public-maven' or something like that", (Object[])new Object[0]), 2);
            }
            try {
                NutsDescriptor g = NutsDescriptorParser.of((NutsSession)session).setDescriptorStyle(NutsDescriptorStyle.MAVEN).parse(new File(f, "pom.xml"));
                NutsSession s = null;
                if (a.getNutsWorkspace() != null && a.getNutsWorkspace().trim().length() > 0 && !a.getNutsWorkspace().equals(session.locations().getWorkspaceLocation().toString())) {
                    s = Nuts.openWorkspace((NutsBootOptions)new NutsBootOptions().setOpenMode(NutsOpenMode.OPEN_OR_ERROR).setReadOnly(Boolean.valueOf(true)).setWorkspace(a.getNutsWorkspace()));
                    s.copyFrom(session);
                } else {
                    s = session;
                }
                List found = s.search().addId(g.getId().getGroupId() + ":" + g.getId().getArtifactId()).addRepositoryFilter(NutsRepositoryFilters.of((NutsSession)s).byName(new String[]{nutsRepository})).setLatest(true).setSession(s).getResultIds().toList();
                if (found.size() > 0) {
                    return ((NutsId)found.get(0)).getVersion().toString();
                }
            }
            catch (Exception e) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to process %s", (Object[])new Object[]{f}), (Throwable)e);
            }
        }
        return null;
    }
}

