/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nversion;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import net.thevpc.nuts.NutsApplication;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsPropertiesFormat;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.toolbox.nversion.ExePathVersionResolver;
import net.thevpc.nuts.toolbox.nversion.JarPathVersionResolver;
import net.thevpc.nuts.toolbox.nversion.MavenFolderPathVersionResolver;
import net.thevpc.nuts.toolbox.nversion.PathVersionResolver;
import net.thevpc.nuts.toolbox.nversion.VersionDescriptor;

public class NVersionMain
implements NutsApplication {
    private final List<PathVersionResolver> resolvers = new ArrayList<PathVersionResolver>();

    public NVersionMain() {
        this.resolvers.add(new JarPathVersionResolver());
        this.resolvers.add(new MavenFolderPathVersionResolver());
        this.resolvers.add(new ExePathVersionResolver());
    }

    public static void main(String[] args) {
        new NVersionMain().runAndExit(args);
    }

    private Set<VersionDescriptor> detectVersions(String filePath, NutsApplicationContext context) throws IOException {
        for (PathVersionResolver r : this.resolvers) {
            Set<VersionDescriptor> x = r.resolve(filePath, context);
            if (x == null) continue;
            return x;
        }
        try {
            Path p = Paths.get(filePath, new String[0]);
            if (!Files.exists(p, new LinkOption[0])) {
                throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)("nversion: file does not exist: %s" + p), (Object[])new Object[0]), 2);
            }
            if (Files.isDirectory(p, new LinkOption[0])) {
                throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"nversion: unsupported directory: %s", (Object[])new Object[]{p}), 2);
            }
            if (Files.isRegularFile(p, new LinkOption[0])) {
                throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"nversion: unsupported file: %s", (Object[])new Object[]{filePath}), 2);
            }
        }
        catch (NutsExecutionException ex) {
            throw ex;
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"nversion: unsupported path: %s", (Object[])new Object[]{filePath}), 2);
    }

    public void run(NutsApplicationContext context) {
        NutsSession session = context.getSession();
        HashSet unsupportedFileTypes = new HashSet();
        HashSet<String> jarFiles = new HashSet<String>();
        HashSet exeFiles = new HashSet();
        HashMap<String, Set<VersionDescriptor>> results = new HashMap<String, Set<VersionDescriptor>>();
        boolean maven = false;
        boolean winPE = false;
        boolean all = false;
        boolean longFormat = false;
        boolean nameFormat = false;
        boolean idFormat = false;
        boolean sort = false;
        boolean table = false;
        boolean error = false;
        NutsCommandLine commandLine = context.getCommandLine();
        int processed = 0;
        while (commandLine.hasNext()) {
            NutsArgument a = commandLine.nextBoolean(new String[]{"--maven"});
            if (a != null) {
                maven = a.getBooleanValue();
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--win-pe"});
            if (a != null) {
                winPE = a.getBooleanValue();
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--exe"});
            if (a != null) {
                winPE = a.getBooleanValue();
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--dll"});
            if (a != null) {
                winPE = a.getBooleanValue();
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--long"});
            if (a != null) {
                longFormat = a.getBooleanValue();
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--name"});
            if (a != null) {
                nameFormat = a.getBooleanValue();
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--sort"});
            if (a != null) {
                sort = a.getBooleanValue();
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--id"});
            if (a != null) {
                idFormat = a.getBooleanValue();
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--all"});
            if (a != null) {
                all = a.getBooleanValue();
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--table"});
            if (a != null) {
                table = a.getBooleanValue();
                continue;
            }
            a = commandLine.nextBoolean(new String[]{"--error"});
            if (a != null) {
                error = a.getBooleanValue();
                continue;
            }
            if (commandLine.peek().isNonOption()) {
                a = commandLine.next();
                jarFiles.add(a.getString());
                continue;
            }
            context.configureLast(commandLine);
        }
        if (commandLine.isExecMode()) {
            for (String arg : jarFiles) {
                Set<VersionDescriptor> value = null;
                try {
                    ++processed;
                    value = this.detectVersions(NutsPath.of((String)arg, (NutsSession)session).toAbsolute().toString(), context);
                }
                catch (IOException e) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"nversion: unable to detect version for %s", (Object[])new Object[]{arg}), (Throwable)e, 2);
                }
                if (value.isEmpty()) continue;
                results.put(arg, value);
            }
            if (processed == 0) {
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"nversion: missing file", (Object[])new Object[0]), 2);
            }
            if (table && all) {
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"nversion: options conflict --table --all", (Object[])new Object[0]), 1);
            }
            if (table && longFormat) {
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"nversion: options conflict --table --long", (Object[])new Object[0]), 1);
            }
            NutsPrintStream out = session.out();
            NutsPrintStream err = session.out();
            NutsTexts text = NutsTexts.of((NutsSession)session);
            if (table) {
                NutsPropertiesFormat tt = NutsPropertiesFormat.of((NutsSession)session).setSorted(sort);
                Properties pp = new Properties();
                for (Map.Entry entry : results.entrySet()) {
                    VersionDescriptor o = ((Set)entry.getValue()).toArray(new VersionDescriptor[0])[0];
                    if (nameFormat) {
                        pp.setProperty((String)entry.getKey(), o.getId().getShortName());
                        continue;
                    }
                    if (idFormat) {
                        pp.setProperty((String)entry.getKey(), o.getId().toString());
                        continue;
                    }
                    if (longFormat) continue;
                    pp.setProperty((String)entry.getKey(), o.getId().toString());
                }
                if (error) {
                    for (String t : unsupportedFileTypes) {
                        File f = new File(NutsPath.of((String)t, (NutsSession)session).toAbsolute().toString());
                        if (f.isFile()) {
                            pp.setProperty(t, text.builder().append((Object)"<<ERROR>>", NutsTextStyle.error()).append((Object)" unsupported file type").toString());
                            continue;
                        }
                        if (f.isDirectory()) {
                            pp.setProperty(t, text.builder().append((Object)"<<ERROR>>", NutsTextStyle.error()).append((Object)" ignored folder").toString());
                            continue;
                        }
                        pp.setProperty(t, text.builder().append((Object)"<<ERROR>>", NutsTextStyle.error()).append((Object)" file not found").toString());
                    }
                }
                tt.setValue((Object)pp).print(out);
            } else {
                AbstractSet keys = sort ? new TreeSet(results.keySet()) : new LinkedHashSet(results.keySet());
                block6: for (String k : keys) {
                    if (results.size() > 1) {
                        if (longFormat || all) {
                            out.printf("%s:%n", new Object[]{text.ofStyled(k, NutsTextStyle.primary3())});
                        } else {
                            out.printf("%s: ", new Object[]{text.ofStyled(k, NutsTextStyle.primary3())});
                        }
                    }
                    Set v = (Set)results.get(k);
                    for (VersionDescriptor descriptor : v) {
                        if (nameFormat) {
                            out.printf("%s%n", new Object[]{text.ofStyled(descriptor.getId().getShortName(), NutsTextStyle.primary4())});
                        } else if (idFormat) {
                            out.printf("%s%n", new Object[]{text.toText((Object)descriptor.getId())});
                        } else if (longFormat) {
                            out.printf("%s%n", new Object[]{text.toText((Object)descriptor.getId())});
                            NutsPropertiesFormat f = NutsPropertiesFormat.of((NutsSession)session).setSorted(true);
                            f.setValue((Object)descriptor.getProperties()).print(out);
                        } else {
                            out.printf("%s%n", new Object[]{text.toText((Object)descriptor.getId().getVersion())});
                        }
                        if (all) continue;
                        continue block6;
                    }
                }
                if (error && !unsupportedFileTypes.isEmpty()) {
                    for (String t : unsupportedFileTypes) {
                        File f = NutsPath.of((String)t, (NutsSession)session).toAbsolute().toFile().toFile();
                        if (f.isFile()) {
                            err.printf("%s : unsupported file type%n", new Object[]{t});
                            continue;
                        }
                        if (f.isDirectory()) {
                            err.printf("%s : ignored folder%n", new Object[]{t});
                            continue;
                        }
                        err.printf("%s : file not found%n", new Object[]{t});
                    }
                }
            }
            if (!unsupportedFileTypes.isEmpty()) {
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"nversion: unsupported file types %s", (Object[])new Object[]{unsupportedFileTypes}), 3);
            }
        }
    }
}

