/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nversion;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsDescriptorProperty;
import net.thevpc.nuts.NutsDescriptorStyle;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.toolbox.nversion.PathVersionResolver;
import net.thevpc.nuts.toolbox.nversion.VersionDescriptor;

public class MavenFolderPathVersionResolver
implements PathVersionResolver {
    @Override
    public Set<VersionDescriptor> resolve(String filePath, NutsApplicationContext context) {
        if (Files.isRegularFile(Paths.get(filePath, new String[0]).resolve("pom.xml"), new LinkOption[0])) {
            Properties properties = new Properties();
            HashSet<VersionDescriptor> all = new HashSet<VersionDescriptor>();
            try (InputStream inputStream = Files.newInputStream(Paths.get(filePath, new String[0]).resolve("pom.xml"), new OpenOption[0]);){
                NutsSession session = context.getSession();
                NutsDescriptor d = NutsDescriptorParser.of((NutsSession)session).setDescriptorStyle(NutsDescriptorStyle.MAVEN).parse(inputStream);
                properties.put("groupId", d.getId().getGroupId());
                properties.put("artifactId", d.getId().getArtifactId());
                properties.put("version", d.getId().getVersion());
                properties.put("name", d.getName());
                properties.setProperty("nuts.version-provider", "maven");
                if (d.getProperties() != null) {
                    for (NutsDescriptorProperty e : d.getProperties()) {
                        properties.put("property." + e.getName(), e.getValue());
                    }
                }
                all.add(new VersionDescriptor(NutsIdBuilder.of((NutsSession)session).setGroupId(d.getId().getGroupId()).setRepository(d.getId().getArtifactId()).setVersion(d.getId().getVersion()).build(), properties));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return all;
        }
        return null;
    }
}

