/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nversion;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.toolbox.nversion.PathVersionResolver;
import net.thevpc.nuts.toolbox.nversion.VersionDescriptor;
import org.boris.pecoff4j.PE;
import org.boris.pecoff4j.ResourceDirectory;
import org.boris.pecoff4j.ResourceEntry;
import org.boris.pecoff4j.io.PEParser;
import org.boris.pecoff4j.io.ResourceParser;
import org.boris.pecoff4j.resources.StringFileInfo;
import org.boris.pecoff4j.resources.StringTable;
import org.boris.pecoff4j.resources.VersionInfo;
import org.boris.pecoff4j.util.ResourceHelper;

public class ExePathVersionResolver
implements PathVersionResolver {
    @Override
    public Set<VersionDescriptor> resolve(String filePath, NutsApplicationContext context) {
        try {
            ResourceEntry[] entries;
            if (!filePath.endsWith(".exe") && !filePath.endsWith(".dll")) {
                return null;
            }
            PE pe = PEParser.parse((String)filePath);
            ResourceDirectory rd = pe.getImageData().getResourceTable();
            HashSet<VersionDescriptor> d = new HashSet<VersionDescriptor>();
            for (ResourceEntry entry : entries = ResourceHelper.findResources((ResourceDirectory)rd, (int)16)) {
                byte[] data = entry.getData();
                VersionInfo version = ResourceParser.readVersionInfo((byte[])data);
                StringFileInfo strings = version.getStringFileInfo();
                StringTable table = strings.getTable(0);
                Properties p = new Properties();
                for (int j = 0; j < table.getCount(); ++j) {
                    String key = table.getString(j).getKey();
                    String value = table.getString(j).getValue();
                    p.setProperty(key, value);
                }
                String artifactId = p.getProperty("AssemblyId");
                if (artifactId == null && (artifactId = p.getProperty("AssemblyName")) == null && (artifactId = p.getProperty("ProductName")) == null && (artifactId = p.getProperty("InternalName")) == null) {
                    artifactId = p.getProperty("OriginalFileName");
                }
                if (artifactId == null) continue;
                if (artifactId.toLowerCase().endsWith(".dll")) {
                    artifactId = artifactId.substring(0, artifactId.length() - ".dll".length());
                } else if (artifactId.toLowerCase().endsWith(".exe")) {
                    artifactId = artifactId.substring(0, artifactId.length() - ".exe".length());
                }
                String artifactVersion = p.getProperty("AssemblyVersion");
                if (artifactVersion == null && (artifactVersion = p.getProperty("Assembly Version")) == null && (artifactVersion = p.getProperty("ProductVersion")) == null) {
                    artifactVersion = p.getProperty("FileVersion");
                }
                p.setProperty("nuts.version-provider", "win-pe");
                if (NutsBlankable.isBlank((String)artifactId) || NutsBlankable.isBlank((String)artifactVersion)) continue;
                NutsSession session = context.getSession();
                d.add(new VersionDescriptor(NutsIdBuilder.of((NutsSession)session).setArtifactId(artifactId).setVersion(artifactVersion).build(), p));
            }
            return d;
        }
        catch (IOException ex) {
            throw new NutsIOException(context.getSession(), (Throwable)ex);
        }
    }
}

