/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.fileversion;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorStyle;
import net.thevpc.nuts.toolbox.fileversion.PathVersionResolver;
import net.thevpc.nuts.toolbox.fileversion.VersionDescriptor;

public class MavenFolderPathVersionResolver
implements PathVersionResolver {
    @Override
    public Set<VersionDescriptor> resolve(String filePath, NutsApplicationContext context) {
        if (Files.isRegularFile(Paths.get(filePath, new String[0]).resolve("pom.xml"), new LinkOption[0])) {
            Properties properties = new Properties();
            HashSet<VersionDescriptor> all = new HashSet<VersionDescriptor>();
            try (InputStream inputStream = Files.newInputStream(Paths.get(filePath, new String[0]).resolve("pom.xml"), new OpenOption[0]);){
                NutsDescriptor d = context.getWorkspace().descriptor().parser().setDescriptorStyle(NutsDescriptorStyle.MAVEN).parse(inputStream);
                properties.put("groupId", d.getId().getGroupId());
                properties.put("artifactId", d.getId().getArtifactId());
                properties.put("version", d.getId().getVersion());
                properties.put("name", d.getName());
                properties.setProperty("nuts.version-provider", "maven");
                if (d.getProperties() != null) {
                    for (Map.Entry e : d.getProperties().entrySet()) {
                        properties.put("property." + (String)e.getKey(), e.getValue());
                    }
                }
                all.add(new VersionDescriptor(context.getWorkspace().id().builder().setGroupId(d.getId().getGroupId()).setRepository(d.getId().getArtifactId()).setVersion(d.getId().getVersion()).build(), properties));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return all;
        }
        return null;
    }
}

