/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.fileversion;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorStyle;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIOUncompressVisitor;
import net.thevpc.nuts.toolbox.fileversion.PathVersionResolver;
import net.thevpc.nuts.toolbox.fileversion.VersionDescriptor;
import net.thevpc.nuts.toolbox.fileversion._StringUtils;

public class JarPathVersionResolver
implements PathVersionResolver {
    @Override
    public Set<VersionDescriptor> resolve(String filePath, final NutsApplicationContext context) {
        if (!(filePath.endsWith(".jar") || filePath.endsWith(".war") || filePath.endsWith(".ear"))) {
            return null;
        }
        final HashSet<VersionDescriptor> all = new HashSet<VersionDescriptor>();
        try (InputStream is = context.getWorkspace().io().path(context.getWorkspace().io().expandPath(filePath)).input().open();){
            context.getWorkspace().io().uncompress().from(is).visit(new NutsIOUncompressVisitor(){

                public boolean visitFolder(String path) {
                    return true;
                }

                public boolean visitFile(String path, InputStream inputStream) {
                    if ("META-INF/MANIFEST.MF".equals(path)) {
                        Manifest manifest = null;
                        try {
                            manifest = new Manifest(inputStream);
                        }
                        catch (IOException e) {
                            throw new NutsIOException(context.getSession(), (Throwable)e);
                        }
                        Attributes attrs = manifest.getMainAttributes();
                        String Bundle_SymbolicName = null;
                        String Bundle_Name = null;
                        String Bundle_Version = null;
                        Properties properties = new Properties();
                        for (Object o : attrs.keySet()) {
                            Attributes.Name attrName = (Attributes.Name)o;
                            String key = attrName.toString();
                            String value = attrs.getValue(attrName);
                            properties.setProperty(key, value);
                            if ("Bundle-Version".equals(key)) {
                                Bundle_Version = value;
                            }
                            if ("Bundle-SymbolicName".equals(key)) {
                                Bundle_SymbolicName = value;
                            }
                            if (!"Bundle-Name".equals(key)) continue;
                            Bundle_Name = value;
                        }
                        properties.setProperty("nuts.version-provider", "OSGI");
                        if (!(_StringUtils.isBlank(Bundle_SymbolicName) || _StringUtils.isBlank(Bundle_Name) || _StringUtils.isBlank(Bundle_Version))) {
                            all.add(new VersionDescriptor(context.getWorkspace().id().builder().setGroupId(Bundle_SymbolicName).setArtifactId(Bundle_Name).setVersion(Bundle_Version).build(), properties));
                        }
                    } else if ("META-INF/nuts.json".equals(path)) {
                        try {
                            NutsDescriptor d = context.getWorkspace().descriptor().parser().parse(inputStream);
                            inputStream.close();
                            Properties properties = new Properties();
                            properties.setProperty("parents", Arrays.stream(d.getParents()).map(Object::toString).collect(Collectors.joining(",")));
                            properties.setProperty("name", d.getId().getArtifactId());
                            properties.setProperty("face", d.getId().getFace());
                            properties.setProperty("group", d.getId().getGroupId());
                            properties.setProperty("version", d.getId().getVersion().toString());
                            if (d.getPackaging() != null) {
                                properties.setProperty("packaging", d.getPackaging());
                            }
                            if (d.getDescription() != null) {
                                properties.setProperty("description", d.getDescription());
                            }
                            properties.setProperty("locations", context.getWorkspace().elem().setContentType(NutsContentType.JSON).setValue((Object)d.getLocations()).setNtf(false).format().filteredText());
                            properties.setProperty("platform", String.join((CharSequence)";", d.getPlatform()));
                            properties.setProperty("os", String.join((CharSequence)";", d.getOs()));
                            properties.setProperty("arch", String.join((CharSequence)";", d.getArch()));
                            properties.setProperty("osdist", String.join((CharSequence)";", d.getOsdist()));
                            properties.setProperty("nuts.version-provider", "nuts.json");
                            if (d.getProperties() != null) {
                                for (Map.Entry e : d.getProperties().entrySet()) {
                                    properties.put("property." + (String)e.getKey(), e.getValue());
                                }
                            }
                            all.add(new VersionDescriptor(d.getId(), properties));
                        }
                        catch (Exception d) {}
                    } else if (path.startsWith("META-INF/maven/") && path.endsWith("/pom.xml")) {
                        Properties properties = new Properties();
                        try {
                            NutsDescriptor d = context.getWorkspace().descriptor().parser().setDescriptorStyle(NutsDescriptorStyle.MAVEN).parse(inputStream);
                            properties.put("groupId", d.getId().getGroupId());
                            properties.put("artifactId", d.getId().getArtifactId());
                            properties.put("version", d.getId().getVersion().toString());
                            properties.put("name", d.getName());
                            properties.setProperty("nuts.version-provider", "maven");
                            if (d.getProperties() != null) {
                                for (Map.Entry e : d.getProperties().entrySet()) {
                                    properties.put("property." + (String)e.getKey(), e.getValue());
                                }
                            }
                            all.add(new VersionDescriptor(context.getWorkspace().id().builder().setGroupId(d.getId().getGroupId()).setRepository(d.getId().getArtifactId()).setVersion(d.getId().getVersion()).build(), properties));
                        }
                        catch (Exception d) {}
                    } else if (path.startsWith("META-INF/maven/") && path.endsWith("/pom.properties")) {
                        try {
                            Properties prop = new Properties();
                            try {
                                prop.load(inputStream);
                            }
                            catch (IOException d) {
                                // empty catch block
                            }
                            String version = prop.getProperty("version");
                            String groupId = prop.getProperty("groupId");
                            String artifactId = prop.getProperty("artifactId");
                            prop.setProperty("nuts.version-provider", "maven");
                            if (version != null && version.trim().length() != 0) {
                                all.add(new VersionDescriptor(context.getWorkspace().id().builder().setGroupId(groupId).setArtifactId(artifactId).setVersion(version).build(), prop));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return true;
                }
            });
        }
        catch (IOException ex) {
            throw new NutsIOException(context.getSession(), (Throwable)ex);
        }
        return all;
    }
}

