/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntomcat.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsProcessInfo;
import net.thevpc.nuts.NutsPs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.toolbox.ntomcat.util.RunningTomcat;

public class TomcatUtils {
    public static String toValidFileName(String name, String defaultName) {
        String r = NutsUtilStrings.trim((String)name);
        if (r.isEmpty()) {
            return NutsUtilStrings.trim((String)defaultName);
        }
        return r.replace('/', '_').replace('*', '_').replace('?', '_').replace('\\', '_');
    }

    public static boolean isPositiveInt(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).length() == 0) {
            return false;
        }
        for (char c : s.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String[] splitInstanceAppPreferInstance(String value) {
        return TomcatUtils.splitInstanceApp(value, true);
    }

    public static String[] splitInstanceAppPreferApp(String value) {
        return TomcatUtils.splitInstanceApp(value, false);
    }

    public static String[] splitInstanceApp(String value, boolean preferInstance) {
        int dot;
        if (value == null) {
            value = "";
        }
        if ((dot = value.indexOf(47)) >= 0) {
            return new String[]{value.substring(0, dot), value.substring(0, dot + 1)};
        }
        if (preferInstance) {
            return new String[]{value, ""};
        }
        return new String[]{"", value};
    }

    public static String toJsonString(Object o) {
        if (o == null) {
            return String.valueOf(o);
        }
        if (o instanceof Boolean || o instanceof Number || o instanceof Map || o instanceof Collection) {
            return String.valueOf(o);
        }
        if (o.getClass().isArray()) {
            return Arrays.toString((Object[])o);
        }
        return "\"" + o.toString().replace("\"", "\\\"") + "\"";
    }

    public static boolean deleteDir(Path src) {
        if (Files.isDirectory(src, new LinkOption[0])) {
            try {
                Files.walk(src, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFolderCatalinaHomeVersion(NutsPath h) {
        NutsPath file = h.resolve("RELEASE-NOTES");
        if (!file.exists()) return null;
        try (BufferedReader r = new BufferedReader(file.getReader());){
            String v;
            String line = null;
            do {
                if ((line = r.readLine()) == null) return null;
            } while (!(line = line.trim()).startsWith("Apache Tomcat Version") || NutsBlankable.isBlank((String)(v = line.substring("Apache Tomcat Version".length()).trim())));
            String string = v;
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static RunningTomcat[] getRunningInstances(NutsApplicationContext context) {
        NutsSession session = context.getSession();
        return (RunningTomcat[])NutsPs.of((NutsSession)session).type("java").getResultList().stream().filter(p -> p.getName().equals("org.apache.catalina.startup.Bootstrap")).map(x -> new RunningTomcat((NutsProcessInfo)x, session)).toArray(RunningTomcat[]::new);
    }
}

