/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntomcat.util;

import java.util.Objects;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsProcessInfo;
import net.thevpc.nuts.NutsSession;

public class RunningTomcat {
    private String pid;
    private NutsPath home;
    private String base;
    private String argsLine;

    public RunningTomcat(NutsProcessInfo r, NutsSession session) {
        this.pid = r.getPid();
        this.argsLine = r.getCommandLine();
        NutsCommandLine cmdline = NutsCommandLine.of((String)r.getCommandLine(), (NutsSession)session).setExpandSimpleOptions(false);
        NutsArgument a = null;
        while (cmdline.hasNext()) {
            a = cmdline.nextString(new String[]{"-Dcatalina.home"});
            if (a != null) {
                this.home = NutsPath.of((String)a.getValue().getString(), (NutsSession)session);
                continue;
            }
            a = cmdline.nextString(new String[]{"-Dcatalina.base"});
            if (a != null) {
                this.base = a.getValue().getString();
                continue;
            }
            cmdline.skip();
        }
    }

    public String getPid() {
        return this.pid;
    }

    public NutsPath getHome() {
        return this.home;
    }

    public String getBase() {
        return this.base;
    }

    public String getArgsLine() {
        return this.argsLine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunningTomcat that = (RunningTomcat)o;
        return Objects.equals(this.pid, that.pid) && Objects.equals(this.home, that.home) && Objects.equals(this.base, that.base) && Objects.equals(this.argsLine, that.argsLine);
    }

    public int hashCode() {
        return Objects.hash(this.pid, this.home, this.base, this.argsLine);
    }

    public String toString() {
        return "RunningTomcat{id='" + this.pid + '\'' + ", home='" + this.home + '\'' + ", base='" + this.base + '\'' + ", argsLine='" + this.argsLine + '\'' + '}';
    }
}

