/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntomcat.util;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import java.util.logging.Logger;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorBuilder;
import net.thevpc.nuts.NutsEnvConditionBuilder;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryModel;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsVersion;

public class ApacheTomcatRepositoryModel
implements NutsRepositoryModel {
    public static final String HTTPS_ARCHIVE_APACHE_ORG_DIST_TOMCAT = "https://archive.apache.org/dist/tomcat/";
    private static final Logger LOG = Logger.getLogger(ApacheTomcatRepositoryModel.class.getName());

    public String getName() {
        return "apache-tomcat";
    }

    public String getUuid() {
        return UUID.nameUUIDFromBytes(this.getName().getBytes()).toString();
    }

    public NutsIterator<NutsId> searchVersions(NutsId id, NutsIdFilter filter, NutsFetchMode fetchMode, NutsRepository repository, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            return null;
        }
        if ("org.apache.catalina:apache-tomcat".equals(id.getShortName())) {
            return this.search(filter, new NutsPath[]{null}, fetchMode, repository, session);
        }
        return null;
    }

    public NutsDescriptor fetchDescriptor(NutsId id, NutsFetchMode fetchMode, NutsRepository repository, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            return null;
        }
        if ("org.apache.catalina:apache-tomcat".equals(id.getShortName())) {
            String r = this.getUrl(id.getVersion(), ".zip");
            URL url = null;
            boolean found = false;
            try {
                url = new URL(r);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (url != null) {
                session.getTerminal().printProgress(NutsMessage.cstyle((String)"peek %s", (Object[])new Object[]{url}));
                try (InputStream inputStream = url.openStream();){
                    found = true;
                }
                catch (Exception ex) {
                    found = false;
                }
            }
            if (found) {
                int i = id.getVersion().getInt(0, -1);
                int j = id.getVersion().getInt(1, -1);
                String javaVersion = "";
                if (i > 0) {
                    javaVersion = i <= 3 ? "#1.1" : (i <= 4 ? "#1.3" : (i <= 5 ? "#1.4" : (i <= 6 ? "#1.5" : (i <= 7 ? "#1.6" : (i <= 8 ? "#1.7" : (i <= 9 ? "#1.8" : (j <= 0 ? "#1.8" : "#11")))))));
                }
                return NutsDescriptorBuilder.of((NutsSession)session).setId(id.getLongId()).setPackaging("zip").setCondition(NutsEnvConditionBuilder.of((NutsSession)session).setPlatform(new String[]{"java" + javaVersion})).setDescription("Apache Tomcat Official Zip Bundle").setProperty("dynamic-descriptor", "true").build();
            }
        }
        return null;
    }

    public NutsContent fetchContent(NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, NutsRepository repository, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            return null;
        }
        if ("org.apache.catalina:apache-tomcat".equals(id.getShortName())) {
            String r = this.getUrl(id.getVersion(), ".zip");
            if (localPath == null) {
                localPath = this.getIdLocalFile(id.builder().setFaceContent().build(), fetchMode, repository, session);
            }
            NutsCp.of((NutsSession)session).from(r).to(localPath).addOptions(new NutsPathOption[]{NutsPathOption.SAFE, NutsPathOption.LOG, NutsPathOption.TRACE}).run();
            return new NutsDefaultContent(NutsPath.of((String)localPath, (NutsSession)session), false, false);
        }
        return null;
    }

    public NutsIterator<NutsId> search(NutsIdFilter filter, NutsPath[] basePaths, NutsFetchMode fetchMode, NutsRepository repository, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            return NutsIterator.ofEmpty((NutsSession)session);
        }
        NutsIdBuilder idBuilder = NutsIdBuilder.of((NutsSession)session).setGroupId("org.apache.catalina").setArtifactId("apache-tomcat");
        return NutsPath.of((String)"htmlfs:https://archive.apache.org/dist/tomcat/", (NutsSession)session).list().filter(x -> x.isDirectory() && x.getName().matches("tomcat-[0-9.]+"), "directory && tomcat").flatMapStream(NutsFunction.of(s -> s.list().filter(x2 -> x2.isDirectory() && x2.getName().startsWith("v"), "isDirectory").flatMapStream(NutsFunction.of(x3 -> {
            boolean checkBin;
            String s2n = x3.getName();
            String prefix = "apache-tomcat-";
            String bin = "bin";
            if (s2n.endsWith("-alpha/") || s2n.endsWith("-beta/") || s2n.endsWith("-copyforpermissions/") || s2n.endsWith("-original/") || s2n.matches(".*-RC[0-9]+/") || s2n.matches(".*-M[0-9]+/")) {
                return NutsStream.ofEmpty((NutsSession)session);
            }
            NutsVersion version = NutsVersion.of((String)s2n.substring(1, s2n.length() - 1), (NutsSession)session);
            if (version.compareTo("4.1.32") < 0) {
                prefix = "jakarta-tomcat-";
            }
            if (version.compareTo("4.1.27") == 0) {
                bin = "binaries";
            }
            if (checkBin = false) {
                String finalPrefix = prefix;
                return x3.resolve(bin).list().filter(x4 -> x4.getName().matches(finalPrefix + "[0-9]+\\.[0-9]+\\.[0-9]+\\.zip"), "name.isZip").map(x5 -> {
                    String s3 = x5.getName();
                    String v0 = s3.substring(finalPrefix.length(), s3.length() - 4);
                    NutsVersion v = NutsVersion.of((String)v0, (NutsSession)session);
                    NutsId id2 = idBuilder.setVersion(v).build();
                    if (filter == null || filter.acceptId(id2, session)) {
                        return id2;
                    }
                    return null;
                }, "toZip").nonNull();
            }
            NutsId id2 = idBuilder.setVersion(version).build();
            if (filter == null || filter.acceptId(id2, session)) {
                return NutsStream.ofSingleton((Object)id2, (NutsSession)session);
            }
            return NutsStream.ofEmpty((NutsSession)session);
        }, (String)"flatMap")), (String)"flatMap")).iterator();
    }

    private String getUrl(NutsVersion version, String extension) {
        String bin = "bin";
        String prefix = "apache-tomcat-";
        if (version.compareTo("4.1.32") < 0) {
            prefix = "jakarta-tomcat-";
        }
        if (version.compareTo("4.1.27") == 0) {
            bin = "binaries";
        }
        return "https://archive.apache.org/dist/tomcat/tomcat-" + version.get(0) + "/v" + version + "/" + bin + "/" + prefix + version + extension;
    }

    public String getIdLocalFile(NutsId id, NutsFetchMode fetchMode, NutsRepository repository, NutsSession session) {
        return repository.config().getStoreLocation().resolve(session.locations().getDefaultIdBasedir(id)).resolve(session.locations().getDefaultIdFilename(id)).toString();
    }
}

