/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntomcat.remote;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.toolbox.ntomcat.remote.RemoteTomcat;
import net.thevpc.nuts.toolbox.ntomcat.remote.RemoteTomcatAppConfigService;
import net.thevpc.nuts.toolbox.ntomcat.remote.RemoteTomcatServiceBase;
import net.thevpc.nuts.toolbox.ntomcat.remote.config.RemoteTomcatAppConfig;
import net.thevpc.nuts.toolbox.ntomcat.remote.config.RemoteTomcatConfig;
import net.thevpc.nuts.toolbox.ntomcat.util.NamedItemNotFoundException;
import net.thevpc.nuts.toolbox.ntomcat.util.TomcatUtils;

public class RemoteTomcatConfigService
extends RemoteTomcatServiceBase {
    public static final String REMOTE_CONFIG_EXT = ".remote-config";
    private static final String NTOMCAT = "net.thevpc.nuts.toolbox:ntomcat";
    RemoteTomcatConfig config;
    NutsApplicationContext context;
    RemoteTomcat client;
    NutsPath sharedConfigFolder;
    private String name;

    public RemoteTomcatConfigService(String name, RemoteTomcat client) {
        this.setName(name);
        this.client = client;
        this.context = client.context;
        this.sharedConfigFolder = client.getContext().getVersionFolder(NutsStoreLocation.CONFIG, "0.8.0.0");
    }

    public RemoteTomcatConfigService(NutsPath file, RemoteTomcat client) {
        this(file.getName().substring(0, file.getName().length() - ".local-config".length()), client);
    }

    @Override
    public RemoteTomcatConfig getConfig() {
        if (this.config == null) {
            this.loadConfig();
        }
        return this.config;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public RemoteTomcatConfigService setName(String name) {
        this.name = TomcatUtils.toValidFileName(name, "default");
        return this;
    }

    @Override
    public RemoteTomcatConfigService print(NutsPrintStream out) {
        NutsSession session = this.context.getSession();
        NutsElements.of((NutsSession)session).json().setValue((Object)this.getConfig()).print(out);
        out.flush();
        return this;
    }

    @Override
    public RemoteTomcatConfigService remove() {
        NutsPath f = this.getConfigPath();
        f.delete();
        return this;
    }

    public RemoteTomcatConfigService setConfig(RemoteTomcatConfig config) {
        this.config = config;
        return this;
    }

    public NutsPath getConfigPath() {
        return this.sharedConfigFolder.resolve(this.name + REMOTE_CONFIG_EXT);
    }

    public RemoteTomcatConfigService save() {
        NutsPath f = this.getConfigPath();
        NutsSession session = this.context.getSession();
        NutsElements.of((NutsSession)session).json().setValue((Object)this.config).print(f);
        return this;
    }

    public boolean existsConfig() {
        NutsPath f = this.getConfigPath();
        return f.exists();
    }

    public void printStatus() {
        this.execRemoteNuts(NTOMCAT, "--status", "--name", this.getRemoteInstanceName());
    }

    public void start(String[] redeploy, boolean deleteOutLog) {
        ArrayList<String> arg = new ArrayList<String>();
        arg.add(NTOMCAT);
        arg.add("--start");
        arg.add("--name");
        arg.add(this.getRemoteInstanceName());
        StringBuilder sb = new StringBuilder();
        for (String s : redeploy) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        if (sb.length() > 0) {
            arg.add("--deploy");
            arg.add(sb.toString());
        }
        if (deleteOutLog) {
            arg.add("--deleteOutLog");
        }
        this.execRemoteNuts(arg.toArray(new String[0]));
    }

    public void shutdown() {
        this.execRemoteNuts(NTOMCAT, "--stop", "--name", this.getRemoteInstanceName());
    }

    public String getRemoteInstanceName() {
        String n = this.getConfig().getRemoteName();
        return NutsBlankable.isBlank((String)n) ? "default" : n;
    }

    public void restart(String[] redeploy, boolean deleteOutLog) {
        ArrayList<String> arg = new ArrayList<String>();
        arg.add(NTOMCAT);
        arg.add("restart");
        arg.add("--name");
        arg.add(this.getRemoteInstanceName());
        StringBuilder sb = new StringBuilder();
        for (String s : redeploy) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        if (sb.length() > 0) {
            arg.add("--deploy");
            arg.add(sb.toString());
        }
        if (deleteOutLog) {
            arg.add("--deleteOutLog");
        }
        this.execRemoteNuts(arg.toArray(new String[0]));
    }

    public RemoteTomcatConfigService loadConfig() {
        NutsSession session = this.context.getSession();
        if (this.name == null) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"missing instance name", (Object[])new Object[0]), 2);
        }
        NutsPath f = this.getConfigPath();
        if (f.exists()) {
            this.config = (RemoteTomcatConfig)NutsElements.of((NutsSession)session).json().parse(f, RemoteTomcatConfig.class);
            return this;
        }
        throw new NamedItemNotFoundException("instance not found : " + this.getName(), this.getName());
    }

    public RemoteTomcatAppConfigService getApp(String appName) {
        return this.getAppOrError(appName);
    }

    public RemoteTomcatAppConfigService getAppOrNull(String appName) {
        RemoteTomcatAppConfig a = this.getConfig().getApps().get(appName);
        if (a == null) {
            return null;
        }
        return new RemoteTomcatAppConfigService(appName, a, this);
    }

    public RemoteTomcatAppConfigService getAppOrError(String appName) {
        RemoteTomcatAppConfig a = this.getConfig().getApps().get(appName);
        if (a == null) {
            throw new NutsExecutionException(this.context.getSession(), NutsMessage.cstyle((String)"app not found :%s", (Object[])new Object[]{appName}), 2);
        }
        return new RemoteTomcatAppConfigService(appName, a, this);
    }

    public RemoteTomcatAppConfigService getAppOrCreate(String appName) {
        RemoteTomcatAppConfig a = this.getConfig().getApps().get(appName);
        if (a == null) {
            a = new RemoteTomcatAppConfig();
            this.getConfig().getApps().put(appName, a);
        }
        return new RemoteTomcatAppConfigService(appName, a, this);
    }

    public void deleteOutLog() {
        this.execRemoteNuts(NTOMCAT, "--deleteOutLog", "--name", this.getRemoteInstanceName());
    }

    public List<RemoteTomcatAppConfigService> getApps() {
        ArrayList<RemoteTomcatAppConfigService> a = new ArrayList<RemoteTomcatAppConfigService>();
        for (String s : this.getConfig().getApps().keySet()) {
            a.add(new RemoteTomcatAppConfigService(s, this.getConfig().getApps().get(s), this));
        }
        return a;
    }

    public void execRemoteNuts(String ... cmd) {
        RemoteTomcatConfig cconfig = this.getConfig();
        ArrayList<String> cmdList = new ArrayList<String>(Arrays.asList("nsh", "-c", "ssh"));
        cmdList.add(this.config.getServer());
        cmdList.add("nuts");
        cmdList.add("--bot");
        cmdList.addAll(Arrays.asList(cmd));
        this.context.getSession().exec().addCommand(cmdList).setFailFast(true).run();
    }
}

