/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntomcat.remote;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectFormat;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.toolbox.ntomcat.remote.RemoteTomcatConfigService;
import net.thevpc.nuts.toolbox.ntomcat.remote.RemoteTomcatServiceBase;
import net.thevpc.nuts.toolbox.ntomcat.remote.config.RemoteTomcatAppConfig;
import net.thevpc.nuts.toolbox.ntomcat.remote.config.RemoteTomcatConfig;
import net.thevpc.nuts.toolbox.ntomcat.util._FileUtils;

public class RemoteTomcatAppConfigService
extends RemoteTomcatServiceBase {
    private RemoteTomcatAppConfig config;
    private NutsApplicationContext context;
    private RemoteTomcatConfigService client;
    private String name;

    public RemoteTomcatAppConfigService(String name, RemoteTomcatAppConfig config, RemoteTomcatConfigService client) {
        this.config = config;
        this.client = client;
        this.context = client.context;
        this.name = name;
    }

    public void install() {
        NutsExecCommand s;
        RemoteTomcatConfig cconfig = this.client.getConfig();
        String localWarPath = this.config.getPath();
        NutsSession session = this.context.getSession();
        if (!new File(localWarPath).exists()) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"missing source war file %s", (Object[])new Object[]{localWarPath}), 2);
        }
        String remoteTempPath = cconfig.getRemoteTempPath();
        if (NutsBlankable.isBlank((String)remoteTempPath)) {
            remoteTempPath = "/tmp";
        }
        String remoteFilePath = "/" + remoteTempPath + "/" + _FileUtils.getFileName(localWarPath);
        String server = cconfig.getServer();
        if (NutsBlankable.isBlank((String)server)) {
            server = "localhost";
        }
        if (!server.startsWith("ssh://")) {
            server = "ssh://" + server;
        }
        session.exec().addCommand(new String[]{"nsh", "--bot", "cp", "--verbose", "--mkdir", localWarPath, server + "/" + remoteFilePath}).setSession(session).run();
        String v = this.config.getVersionCommand();
        if (NutsBlankable.isBlank((String)v)) {
            v = "nsh nversion --color=never %file";
        }
        List<String> cmd = Arrays.asList(NutsCommandLine.of((String)v, (NutsSession)session).toStringArray());
        boolean fileAdded = false;
        for (int i = 0; i < cmd.size(); ++i) {
            if (!"%file".equals(cmd.get(i))) continue;
            cmd.set(i, this.config.getPath());
            fileAdded = true;
        }
        if (!fileAdded) {
            cmd.add(this.config.getPath());
        }
        if ((s = session.exec().setRedirectErrorStream(true).grabOutputString().addCommand(cmd).run()).getResult() != 0) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to detect file version of %s.\n%s", (Object[])new Object[]{localWarPath, s.getOutputString()}), 2);
        }
        this.client.execRemoteNuts("net.thevpc.nuts.toolbox:tomcat", "install", "--name", this.client.getRemoteInstanceName(), "--app", this.name, "--version", s.getOutputString().trim(), "--file", remoteFilePath);
        this.client.execRemoteNuts("nsh", "--bot", "rm", remoteFilePath);
    }

    public void deploy(String version) {
        this.client.execRemoteNuts("net.thevpc.nuts.toolbox:tomcat", "deploy", "--name", this.client.getRemoteInstanceName(), "--app", this.name, "--version", NutsUtilStrings.trim((String)version));
    }

    @Override
    public RemoteTomcatAppConfig getConfig() {
        return this.config;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RemoteTomcatAppConfigService print(NutsPrintStream out) {
        NutsSession session = this.context.getSession();
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("config-name", this.getName());
        m.putAll((Map)NutsElements.of((NutsSession)session).convert((Object)this.getConfig(), Map.class));
        NutsObjectFormat.of((NutsSession)this.context.getSession()).setValue(m).print(out);
        return this;
    }

    @Override
    public RemoteTomcatAppConfigService remove() {
        this.client.getConfig().getApps().remove(this.name);
        this.context.getSession().out().printf("%s app removed.\n", new Object[]{this.getBracketsPrefix(this.name)});
        return this;
    }

    public NutsString getBracketsPrefix(String str) {
        return NutsTexts.of((NutsSession)this.context.getSession()).builder().append((Object)"[").append((Object)str, NutsTextStyle.primary5()).append((Object)"]");
    }

    public RemoteTomcatConfigService getTomcat() {
        return this.client;
    }
}

