/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntomcat.remote;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUnsafeFunction;
import net.thevpc.nuts.NutsUserCancelException;
import net.thevpc.nuts.toolbox.ntomcat.remote.RemoteTomcatAppConfigService;
import net.thevpc.nuts.toolbox.ntomcat.remote.RemoteTomcatConfigService;
import net.thevpc.nuts.toolbox.ntomcat.remote.RemoteTomcatServiceBase;
import net.thevpc.nuts.toolbox.ntomcat.remote.config.RemoteTomcatConfig;
import net.thevpc.nuts.toolbox.ntomcat.util.TomcatUtils;

public class RemoteTomcat {
    public NutsApplicationContext context;
    public NutsCommandLine cmdLine;
    public NutsPath sharedConfigFolder;

    public RemoteTomcat(NutsApplicationContext applicationContext, NutsCommandLine cmdLine) {
        this.setContext(applicationContext);
        this.cmdLine = cmdLine;
        this.sharedConfigFolder = applicationContext.getVersionFolder(NutsStoreLocation.CONFIG, "0.8.0.0");
    }

    public void runArgs() {
        this.cmdLine.setCommandName("tomcat --remote");
        while (this.cmdLine.hasNext()) {
            if (this.cmdLine.peek().isOption()) {
                this.context.configureLast(this.cmdLine);
                continue;
            }
            NutsArgument a = this.cmdLine.next(new String[]{"list"});
            if (a != null) {
                this.list(this.cmdLine);
                return;
            }
            a = this.cmdLine.next(new String[]{"show"});
            if (a != null) {
                this.show(this.cmdLine);
                return;
            }
            a = this.cmdLine.next(new String[]{"add", "set"});
            if (a != null) {
                this.add(this.cmdLine);
                return;
            }
            a = this.cmdLine.next(new String[]{"remove"});
            if (a != null) {
                this.remove(this.cmdLine);
                return;
            }
            a = this.cmdLine.next(new String[]{"start"});
            if (a != null) {
                this.restart(this.cmdLine, false);
                return;
            }
            a = this.cmdLine.next(new String[]{"restart"});
            if (a != null) {
                this.restart(this.cmdLine, true);
                return;
            }
            a = this.cmdLine.next(new String[]{"stop"});
            if (a != null) {
                this.stop(this.cmdLine);
                return;
            }
            a = this.cmdLine.next(new String[]{"install"});
            if (a != null) {
                this.install(this.cmdLine);
                return;
            }
            a = this.cmdLine.next(new String[]{"deploy"});
            if (a != null) {
                this.deploy(this.cmdLine);
                return;
            }
            a = this.cmdLine.next(new String[]{"reset"});
            if (a != null) {
                this.reset(this.cmdLine);
                return;
            }
            this.cmdLine.setCommandName("tomcat --remote").unexpectedArgument();
        }
        throw new NutsExecutionException(this.context.getSession(), NutsMessage.cstyle((String)"missing tomcat action. Type: nuts tomcat --help", (Object[])new Object[0]), 1);
    }

    public void list(NutsCommandLine args) {
        class Helper {
            boolean processed = false;

            Helper() {
            }

            void print(RemoteTomcatConfigService c) {
                this.processed = true;
                List<RemoteTomcatAppConfigService> apps = c.getApps();
                for (RemoteTomcatAppConfigService app : apps) {
                    RemoteTomcat.this.context.getSession().out().printf("%s\n", new Object[]{app.getName()});
                }
            }
        }
        Helper x = new Helper();
        while (args.hasNext()) {
            NutsArgument a = args.nextString(new String[]{"--name"});
            if (a != null) {
                x.print(this.loadOrCreateTomcatConfig(a.getValue().getString()));
                continue;
            }
            if (args.peek().isNonOption()) {
                x.print(this.loadOrCreateTomcatConfig(args.requireNonOption().next().getValue().getString()));
                continue;
            }
            this.context.configureLast(args);
        }
        if (!x.processed) {
            for (RemoteTomcatConfigService tomcatConfig : this.listConfig()) {
                this.getContext().getSession().out().println(tomcatConfig.getName());
            }
        }
    }

    private void add(NutsCommandLine args) {
        RemoteTomcatConfigService c = null;
        String appName = null;
        String instanceName = null;
        args.setCommandName("tomcat --remote add");
        NutsSession session = this.context.getSession();
        while (args.hasNext()) {
            RemoteTomcatAppConfigService tomcatAppConfig;
            String value;
            NutsArgument a = args.nextString(new String[]{"--name"});
            if (a != null) {
                if (c == null) {
                    instanceName = a.getValue().getString();
                    c = this.loadOrCreateTomcatConfig(instanceName);
                    continue;
                }
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"instance already defined", (Object[])new Object[0]), 2);
            }
            a = args.nextString(new String[]{"--server"});
            if (a != null) {
                if (c == null) {
                    c = this.loadOrCreateTomcatConfig(null);
                }
                c.getConfig().setServer(a.getValue().getString());
                continue;
            }
            a = args.nextString(new String[]{"--remote-temp-path"});
            if (a != null) {
                if (c == null) {
                    c = this.loadOrCreateTomcatConfig(null);
                }
                c.getConfig().setRemoteTempPath(a.getValue().getString());
                continue;
            }
            a = args.nextString(new String[]{"--remote-instance"});
            if (a != null) {
                value = a.getValue().getString();
                if (c == null) {
                    c = this.loadOrCreateTomcatConfig(null);
                }
                c.getConfig().setRemoteName(value);
                continue;
            }
            a = args.nextString(new String[]{"--app"});
            if (a != null) {
                appName = a.getValue().getString();
                if (c == null) {
                    c = this.loadOrCreateTomcatConfig(null);
                }
                c.getAppOrCreate(appName);
                continue;
            }
            a = args.nextString(new String[]{"--app.path"});
            if (a != null) {
                value = a.getValue().getString();
                if (c == null) {
                    c = this.loadOrCreateTomcatConfig(null);
                }
                tomcatAppConfig = c.getAppOrError(appName);
                tomcatAppConfig.getConfig().setPath(value);
                continue;
            }
            a = args.nextString(new String[]{"--app.version"});
            if (a != null) {
                value = a.getValue().getString();
                if (c == null) {
                    c = this.loadOrCreateTomcatConfig(null);
                }
                tomcatAppConfig = c.getAppOrError(appName);
                tomcatAppConfig.getConfig().setVersionCommand(value);
                continue;
            }
            this.context.configureLast(args);
        }
        if (c == null) {
            c = this.loadOrCreateTomcatConfig(null);
        }
        boolean ok = false;
        NutsTexts text = NutsTexts.of((NutsSession)this.getContext().getSession());
        while (!ok) {
            try {
                ok = true;
                if (NutsBlankable.isBlank((String)c.getConfig().getServer())) {
                    ok = false;
                    c.getConfig().setServer((String)session.getTerminal().ask().forString("[instance=%s] would you enter %s value ?", new Object[]{text.ofStyled(c.getName(), NutsTextStyle.primary1()), text.ofStyled("--server", NutsTextStyle.option())}).setDefaultValue((Object)"ssh://login@myserver/instanceName").getValue());
                }
                if (NutsBlankable.isBlank((String)c.getConfig().getRemoteTempPath())) {
                    ok = false;
                    c.getConfig().setRemoteTempPath((String)session.getTerminal().ask().resetLine().forString("[instance=%s] would you enter %s value ?", new Object[]{text.ofStyled(c.getName(), NutsTextStyle.primary1()), text.ofStyled("--remote-temp-path", NutsTextStyle.option())}).setDefaultValue((Object)"/tmp").getValue());
                }
                for (RemoteTomcatAppConfigService aa : c.getApps()) {
                    if (!NutsBlankable.isBlank((String)aa.getConfig().getPath())) continue;
                    ok = false;
                    aa.getConfig().setPath((String)session.getTerminal().ask().resetLine().forString("[instance=%s] [app=%s] would you enter %s value ?", new Object[]{text.ofStyled(c.getName(), NutsTextStyle.primary1()), text.ofStyled(aa.getName(), NutsTextStyle.option()), text.ofStyled("--app.path", NutsTextStyle.option())}).getValue());
                }
            }
            catch (NutsUserCancelException ex) {
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"cancelled", (Object[])new Object[0]), 1);
            }
        }
        c.save();
    }

    public void remove(NutsCommandLine args) {
        RemoteTomcatServiceBase s = null;
        boolean processed = false;
        int lastExitCode = 0;
        args.setCommandName("tomcat --remote remove");
        while (args.hasNext()) {
            s = this.readBaseServiceArg(args);
            if (s != null) {
                s.remove();
                if (!(s instanceof RemoteTomcatConfigService)) {
                    this.toRemoteTomcatConfigService(s).save();
                }
                processed = true;
                lastExitCode = 0;
                continue;
            }
            this.context.configureLast(args);
        }
        if (!processed) {
            throw new NutsExecutionException(this.context.getSession(), NutsMessage.cstyle((String)"invalid parameters", (Object[])new Object[0]), 2);
        }
        if (lastExitCode != 0) {
            throw new NutsExecutionException(this.context.getSession(), NutsMessage.cstyle((String)"tomcat remove failed", (Object[])new Object[0]), lastExitCode);
        }
    }

    private void install(NutsCommandLine args) {
        Object conf = null;
        Object app = null;
        args.setCommandName("tomcat --remote install");
        while (args.hasNext()) {
            NutsArgument a = args.nextString(new String[]{"--app"});
            if (a != null) {
                this.loadApp(a.getValue().getString()).install();
                continue;
            }
            this.context.configureLast(args);
        }
    }

    private void deploy(NutsCommandLine args) {
        String app = null;
        String version = null;
        args.setCommandName("tomcat --remote deploy");
        while (args.hasNext()) {
            NutsArgument a = args.nextString(new String[]{"--app"});
            if (a != null) {
                app = a.getValue().getString();
                continue;
            }
            a = args.nextString(new String[]{"--version"});
            if (a != null) {
                version = a.getValue().getString();
                continue;
            }
            this.context.configureLast(args);
        }
        this.loadApp(app).deploy(version);
    }

    private void stop(NutsCommandLine args) {
        String name = null;
        while (args.hasNext()) {
            if (args.peek().isNonOption()) {
                name = args.requireNonOption().next().getString();
                RemoteTomcatConfigService c = this.loadTomcatConfig(name);
                c.shutdown();
                continue;
            }
            this.context.configureLast(args);
        }
    }

    public void restart(NutsCommandLine args, boolean shutdown) {
        String instance = null;
        boolean deleteLog = false;
        boolean install = false;
        ArrayList<String> apps = new ArrayList<String>();
        while (args.hasNext()) {
            NutsArgument a = args.nextBoolean(new String[]{"--deleteLog"});
            if (a != null) {
                deleteLog = a.getBooleanValue();
                continue;
            }
            a = args.nextBoolean(new String[]{"--install"});
            if (a != null) {
                install = a.getBooleanValue();
                continue;
            }
            a = args.nextString(new String[]{"--name"});
            if (a != null) {
                instance = a.getValue().getString();
                continue;
            }
            a = args.nextString(new String[]{"--deploy"});
            if (a != null) {
                for (String s : a.getValue().getString().split(",")) {
                    if (NutsBlankable.isBlank((String)(s = s.trim()))) continue;
                    apps.add(s);
                }
                continue;
            }
            if (args.peek().isNonOption()) {
                instance = args.requireNonOption().next().getValue().getString();
                continue;
            }
            this.context.configureLast(args);
        }
        NutsSession session = this.getContext().getSession();
        if (install) {
            for (String app : apps) {
                this.install(NutsCommandLine.of((String[])new String[]{"--name", instance, "--app", app}, (NutsSession)session));
            }
        }
        RemoteTomcatConfigService c = this.loadTomcatConfig(instance);
        if (shutdown) {
            c.restart(apps.toArray(new String[0]), deleteLog);
        } else {
            c.start(apps.toArray(new String[0]), deleteLog);
        }
    }

    public void reset(NutsCommandLine args) {
        args.setCommandName("tomcat --remote reset");
        while (args.hasNext()) {
            this.context.configureLast(args);
        }
        for (RemoteTomcatConfigService tomcatConfig : this.listConfig()) {
            tomcatConfig.remove();
        }
    }

    public RemoteTomcatConfigService[] listConfig() {
        return (RemoteTomcatConfigService[])this.sharedConfigFolder.list().filter(pathname -> pathname.isRegularFile() && pathname.getName().endsWith(".remote-config"), "isRegularFile() && matches(*.remote-config)").mapUnsafe(NutsUnsafeFunction.of(x -> this.loadTomcatConfig((NutsPath)x), (String)"loadTomcatConfig"), null).filterNonNull().toArray(RemoteTomcatConfigService[]::new);
    }

    public void show(NutsCommandLine args) {
        class Helper {
            boolean json = false;

            Helper() {
            }

            public void show(RemoteTomcatServiceBase aa) {
                NutsSession session = RemoteTomcat.this.getContext().getSession();
                if (this.json) {
                    session.out().printf("%s :\n", new Object[]{NutsTexts.of((NutsSession)session).ofStyled(aa.getName(), NutsTextStyle.primary4())});
                    aa.println(session.out());
                } else {
                    session.out().printf("%s :\n", new Object[]{NutsTexts.of((NutsSession)session).ofStyled(aa.getName(), NutsTextStyle.primary4())});
                    aa.println(session.out());
                }
            }
        }
        Helper h = new Helper();
        args.setCommandName("tomcat --remote show");
        while (args.hasNext()) {
            NutsArgument a = args.nextBoolean(new String[]{"--json"});
            if (a != null) {
                h.json = a.getBooleanValue();
                continue;
            }
            RemoteTomcatServiceBase s = this.readBaseServiceArg(args);
            if (s != null) {
                h.show(s);
                continue;
            }
            this.context.configureLast(args);
        }
    }

    public RemoteTomcatConfigService loadTomcatConfig(String name) {
        RemoteTomcatConfigService t = new RemoteTomcatConfigService(name, this);
        t.loadConfig();
        return t;
    }

    public RemoteTomcatConfigService loadTomcatConfig(NutsPath name) {
        RemoteTomcatConfigService t = new RemoteTomcatConfigService(name, this);
        t.loadConfig();
        return t;
    }

    public RemoteTomcatConfigService createTomcatConfig(String name) {
        RemoteTomcatConfigService t = new RemoteTomcatConfigService(name, this);
        t.setConfig(new RemoteTomcatConfig());
        return t;
    }

    public RemoteTomcatConfigService loadOrCreateTomcatConfig(String name) {
        RemoteTomcatConfigService t = new RemoteTomcatConfigService(name, this);
        if (t.existsConfig()) {
            t.loadConfig();
        } else {
            t.setConfig(new RemoteTomcatConfig());
        }
        return t;
    }

    public RemoteTomcatServiceBase loadServiceBase(String name) {
        String[] strings = TomcatUtils.splitInstanceAppPreferInstance(name);
        if (strings[1].isEmpty()) {
            return this.loadOrCreateTomcatConfig(strings[0]);
        }
        RemoteTomcatConfigService u = this.loadOrCreateTomcatConfig(strings[0]);
        RemoteTomcatAppConfigService a = u.getAppOrNull(strings[1]);
        if (a == null) {
            throw new NutsExecutionException(this.context.getSession(), NutsMessage.cstyle((String)"unknown name %s. it is no domain or app", (Object[])new Object[]{name}), 3);
        }
        return a;
    }

    public RemoteTomcatServiceBase readBaseServiceArg(NutsCommandLine args) {
        NutsArgument a = args.nextString(new String[]{"--name"});
        if (a != null) {
            return this.loadOrCreateTomcatConfig(a.getValue().getString());
        }
        a = args.nextString(new String[]{"--app"});
        if (a != null) {
            return this.loadApp(a.getValue().getString());
        }
        if (args.hasNext() && args.peek().isOption()) {
            return null;
        }
        return this.loadServiceBase(args.next().getString());
    }

    public RemoteTomcatAppConfigService loadApp(String name) {
        String[] strings = TomcatUtils.splitInstanceAppPreferApp(name);
        return this.loadOrCreateTomcatConfig(strings[0]).getApp(strings[1]);
    }

    public NutsApplicationContext getContext() {
        return this.context;
    }

    public void setContext(NutsApplicationContext context) {
        this.context = context;
    }

    public RemoteTomcatConfigService toRemoteTomcatConfigService(RemoteTomcatServiceBase s) {
        if (s instanceof RemoteTomcatAppConfigService) {
            s = ((RemoteTomcatAppConfigService)s).getTomcat();
        }
        return (RemoteTomcatConfigService)s;
    }
}

