/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntomcat.local;

import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcatAppConfigService;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcatConfigService;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcatServiceBase;
import net.thevpc.nuts.toolbox.ntomcat.local.config.LocalTomcatDomainConfig;

public class LocalTomcatDomainConfigService
extends LocalTomcatServiceBase {
    private String name;
    private LocalTomcatDomainConfig config;
    private LocalTomcatConfigService tomcat;
    private NutsApplicationContext context;

    public LocalTomcatDomainConfigService(String name, LocalTomcatDomainConfig config, LocalTomcatConfigService tomcat) {
        this.config = config;
        this.tomcat = tomcat;
        this.name = name;
        this.context = tomcat.getTomcatServer().getContext();
    }

    @Override
    public LocalTomcatDomainConfig getConfig() {
        return this.config;
    }

    public LocalTomcatConfigService getTomcat() {
        return this.tomcat;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public NutsPath getDomainDeployPath() {
        NutsPath p;
        NutsPath b = this.tomcat.getCatalinaBase();
        if (b == null) {
            b = this.tomcat.getCatalinaHome();
        }
        NutsPath nutsPath = p = this.config.getDeployPath() == null ? null : NutsPath.of((String)this.config.getDeployPath(), (NutsSession)this.getSession());
        if (p == null) {
            p = this.tomcat.getDefaulDeployFolder(this.name);
        }
        return b.resolve(b);
    }

    private NutsSession getSession() {
        return this.context.getSession();
    }

    @Override
    public LocalTomcatDomainConfigService remove() {
        this.tomcat.getConfig().getDomains().remove(this.name);
        for (LocalTomcatAppConfigService aa : this.tomcat.getApps()) {
            if (!this.name.equals(aa.getConfig().getDomain())) continue;
            aa.remove();
        }
        this.getSession().out().printf("%s domain removed.\n", new Object[]{this.getBracketsPrefix(this.name)});
        return this;
    }

    public NutsString getBracketsPrefix(String str) {
        return NutsTexts.of((NutsSession)this.getSession()).builder().append((Object)"[").append((Object)str, NutsTextStyle.primary5()).append((Object)"]");
    }

    @Override
    public LocalTomcatDomainConfigService print(NutsPrintStream out) {
        NutsSession session = this.getSession();
        NutsElements.of((NutsSession)session).json().setValue((Object)this.getConfig()).print(out);
        return this;
    }
}

