/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntomcat.local;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallEvent;
import net.thevpc.nuts.NutsInstallListener;
import net.thevpc.nuts.NutsInstallStatusFilters;
import net.thevpc.nuts.NutsListener;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectFormat;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPathPermission;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsPs;
import net.thevpc.nuts.NutsSearchCommand;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcat;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcatAppConfigService;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcatDomainConfigService;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcatLogLineVisitor;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcatServiceBase;
import net.thevpc.nuts.toolbox.ntomcat.local.config.LocalTomcatAppConfig;
import net.thevpc.nuts.toolbox.ntomcat.local.config.LocalTomcatConfig;
import net.thevpc.nuts.toolbox.ntomcat.local.config.LocalTomcatDomainConfig;
import net.thevpc.nuts.toolbox.ntomcat.util.AppStatus;
import net.thevpc.nuts.toolbox.ntomcat.util.NamedItemNotFoundException;
import net.thevpc.nuts.toolbox.ntomcat.util.RunningTomcat;
import net.thevpc.nuts.toolbox.ntomcat.util.TomcatUtils;
import net.thevpc.nuts.toolbox.ntomcat.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class LocalTomcatConfigService
extends LocalTomcatServiceBase {
    public static final String LOCAL_CONFIG_EXT = ".local-config";
    private final LocalTomcat app;
    private final NutsApplicationContext context;
    private final NutsPath sharedConfigFolder;
    private String name;
    private LocalTomcatConfig config;
    private NutsDefinition catalinaNutsDefinition;
    private String catalinaVersion;

    public LocalTomcatConfigService(NutsPath file, LocalTomcat app) {
        this(file.getName().substring(0, file.getName().length() - LOCAL_CONFIG_EXT.length()), app);
        this.loadConfig();
    }

    public LocalTomcatConfigService(String name, LocalTomcat app) {
        this.app = app;
        this.setName(name);
        this.context = app.getContext();
        this.sharedConfigFolder = app.getContext().getVersionFolder(NutsStoreLocation.CONFIG, "0.8.0.0");
    }

    public void open(NutsOpenMode autoCreate) {
        switch (autoCreate) {
            case OPEN_OR_CREATE: {
                if (this.existsConfig()) {
                    this.loadConfig();
                    break;
                }
                this.setConfig(new LocalTomcatConfig());
                this.save();
                break;
            }
            case OPEN_OR_ERROR: {
                if (!this.existsConfig()) {
                    throw new NamedItemNotFoundException("Instance not found : " + this.getName(), this.getName());
                }
                this.loadConfig();
                break;
            }
            case CREATE_OR_ERROR: {
                if (this.existsConfig()) {
                    throw new NamedItemNotFoundException("Instance already exists : " + this.getName(), this.getName());
                }
                this.setConfig(new LocalTomcatConfig());
                this.save();
            }
        }
    }

    @Override
    public LocalTomcatConfig getConfig() {
        if (this.config == null) {
            this.loadConfig();
        }
        return this.config;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public LocalTomcatConfigService setName(String name) {
        if (".".equals(name)) {
            name = "default";
        }
        this.name = TomcatUtils.toValidFileName(name, "default");
        return this;
    }

    @Override
    public LocalTomcatConfigService print(NutsPrintStream out) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("config-name", this.getName());
        result.put("version", this.getValidCatalinaVersion());
        result.put("status", (Object)this.getStatus());
        result.put("home", this.getCatalinaHome());
        result.put("base", this.getCatalinaBase());
        result.put("out", this.getOutLogFile());
        result.put("http-port", this.getHttpConnectorPort());
        result.put("http-redirect-port", this.getHttpConnectorRedirectPort());
        result.put("ajp-port", this.getAjpConnectorPort());
        result.put("ajp-redirect-port", this.getAjpConnectorRedirectPort());
        result.put("shutdown-port", this.getShutdownPort());
        result.put("config", this.getConfig());
        NutsObjectFormat.of((NutsSession)this.getSession()).setValue(result).print(out);
        return this;
    }

    @Override
    public LocalTomcatConfigService remove() {
        this.sharedConfigFolder.resolve(this.getName() + LOCAL_CONFIG_EXT).delete();
        return this;
    }

    public LocalTomcatConfigService setConfig(LocalTomcatConfig config) {
        this.config = config;
        return this;
    }

    public LocalTomcatConfigService save() {
        String v = this.getConfig().getCatalinaVersion();
        if (v == null && (v = this.getValidCatalinaVersion()) != null) {
            this.getConfig().setCatalinaVersion(v);
        }
        NutsPath f = this.getConfigPath();
        NutsSession session = this.getSession();
        NutsElements.of((NutsSession)session).json().setValue((Object)this.config).print(f);
        return this;
    }

    public NutsPath getConfigPath() {
        return this.sharedConfigFolder.resolve(this.getName() + LOCAL_CONFIG_EXT);
    }

    public boolean existsConfig() {
        return this.getConfigPath().exists();
    }

    public String getRequestedCatalinaVersion() {
        LocalTomcatConfig c = this.getConfig();
        return c.getCatalinaVersion();
    }

    public String getValidCatalinaVersion() {
        String v = this.getConfig().getCatalinaVersion();
        if (!NutsBlankable.isBlank((String)v)) {
            return v;
        }
        v = TomcatUtils.getFolderCatalinaHomeVersion(this.getCatalinaHome());
        if (v != null) {
            return v;
        }
        NutsDefinition nf = this.getCatalinaNutsDefinition();
        return nf.getId().getVersion().toString();
    }

    public NutsPath getCatalinaBase() {
        LocalTomcatConfig c = this.getConfig();
        NutsPath catalinaBase = c.getCatalinaBase() == null ? null : NutsPath.of((String)c.getCatalinaBase(), (NutsSession)this.getSession());
        NutsPath catalinaHome = this.getCatalinaHome();
        if (NutsBlankable.isBlank((String)this.getConfig().getCatalinaHome()) && catalinaBase == null) {
            catalinaBase = NutsPath.of((String)this.getName(), (NutsSession)this.getSession());
        }
        if (catalinaBase == null) {
            int x2;
            String v = this.getValidCatalinaVersion();
            int x1 = v.indexOf(46);
            int n = x2 = x1 < 0 ? -1 : v.indexOf(46, x1 + 1);
            if (x2 > 0) {
                v = v.substring(0, x2);
            }
            catalinaBase = this.context.getSharedConfigFolder().resolve("catalina-base-" + v).resolve("default");
        } else if (!catalinaBase.isAbsolute()) {
            int x2;
            String v = this.getValidCatalinaVersion();
            int x1 = v.indexOf(46);
            int n = x2 = x1 < 0 ? -1 : v.indexOf(46, x1 + 1);
            if (x2 > 0) {
                v = v.substring(0, x2);
            }
            catalinaBase = this.context.getSharedConfigFolder().resolve("catalina-base-" + v).resolve(catalinaBase);
        }
        return catalinaBase;
    }

    public NutsPath resolveCatalinaHome() {
        NutsDefinition f = this.getCatalinaNutsDefinition();
        NutsPath u = f.getInstallInformation().getInstallFolder();
        try {
            NutsPath[] paths = (NutsPath[])u.list().filter(x -> x.isDirectory(), "isDirectory").toArray(NutsPath[]::new);
            if (paths.length == 1 && paths[0].getName().toLowerCase().startsWith("apache-tomcat")) {
                return paths[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return u;
    }

    public NutsPath getCatalinaHome() {
        String h = this.getConfig().getCatalinaHome();
        if (NutsBlankable.isBlank((String)h)) {
            NutsPath h2 = this.resolveCatalinaHome();
            this.getConfig().setCatalinaHome(h2.toString());
            this.save();
            return h2;
        }
        return NutsPath.of((String)h, (NutsSession)this.getSession());
    }

    private NutsSession getSession() {
        return this.context.getSession();
    }

    public NutsString getFormattedError(String str) {
        return NutsTexts.of((NutsSession)this.getSession()).ofStyled(str, NutsTextStyle.error());
    }

    public NutsString getFormattedSuccess(String str) {
        return NutsTexts.of((NutsSession)this.getSession()).ofStyled(str, NutsTextStyle.success());
    }

    public NutsString getFormattedPrefix(String str) {
        return NutsTexts.of((NutsSession)this.getSession()).builder().append((Object)"[").append((Object)str, NutsTextStyle.primary5()).append((Object)"]");
    }

    public void printStatus() {
        if (this.getSession().isPlainOut()) {
            switch (this.getStatus()) {
                case RUNNING: {
                    this.getSession().out().printf("%s Tomcat %s.\n", new Object[]{this.getFormattedPrefix(this.getName()), this.getFormattedSuccess("running")});
                    break;
                }
                case STOPPED: {
                    this.getSession().out().printf("%s Tomcat %s.\n", new Object[]{this.getFormattedPrefix(this.getName()), this.getFormattedError("stopped")});
                    break;
                }
                case OUT_OF_MEMORY: {
                    this.getSession().out().printf("%s Tomcat %s.\n", new Object[]{this.getFormattedPrefix(this.getName()), this.getFormattedError("out-of-memory")});
                }
            }
        } else {
            HashMap<String, String> r = new HashMap<String, String>();
            r.put("config-name", this.getName());
            switch (this.getStatus()) {
                case RUNNING: {
                    r.put("status", "running");
                    break;
                }
                case STOPPED: {
                    r.put("status", "stopped");
                    break;
                }
                case OUT_OF_MEMORY: {
                    r.put("status", "out-of-memory");
                }
            }
            this.object().setValue(r).println();
        }
    }

    public NutsObjectFormat object() {
        return NutsObjectFormat.of((NutsSession)this.getSession());
    }

    public String[] parseApps(String[] args) {
        ArrayList<String> apps = new ArrayList<String>();
        if (args != null) {
            for (String arg : args) {
                if (NutsBlankable.isBlank((String)arg)) continue;
                for (String s : arg.split("[, ]")) {
                    if (s.isEmpty()) continue;
                    apps.add(s);
                }
            }
        }
        return apps.toArray(new String[0]);
    }

    public boolean start() {
        return this.start(null, false);
    }

    public boolean buildCatalinaBase() {
        NutsPath catalinaHome = this.getCatalinaHome();
        NutsPath catalinaBase = this.getCatalinaBase();
        boolean catalinaBaseUpdated = false;
        catalinaBaseUpdated |= this.mkdirs(catalinaBase);
        String ext = this.getSession().env().getOsFamily() == NutsOsFamily.WINDOWS ? "bat" : "sh";
        catalinaBaseUpdated |= this.checkExec(catalinaHome.resolve("bin").resolve("catalina." + ext));
        LocalTomcatConfig c = this.getConfig();
        catalinaBaseUpdated |= this.mkdirs(catalinaBase.resolve("logs"));
        catalinaBaseUpdated |= this.mkdirs(catalinaBase.resolve("temp"));
        catalinaBaseUpdated |= this.mkdirs(catalinaBase.resolve("conf"));
        if (catalinaHome.resolve("conf").isDirectory()) {
            for (NutsPath conf : catalinaHome.resolve("conf").list()) {
                NutsPath confFile = catalinaBase.resolve("conf/" + conf.getName());
                if (confFile.exists()) continue;
                catalinaBaseUpdated = true;
                NutsCp.of((NutsSession)this.getSession()).from(conf).to(confFile).run();
            }
        }
        if (c.isDev()) {
            if (catalinaHome.resolve("webapps").resolve("host-manager").isDirectory()) {
                NutsCp.of((NutsSession)this.getSession()).from(catalinaHome.resolve("webapps").resolve("host-manager")).to(catalinaBase.resolve("webapps").resolve("host-manager")).removeOptions(new NutsPathOption[]{NutsPathOption.REPLACE_EXISTING}).run();
                catalinaBaseUpdated = true;
            }
            if (catalinaHome.resolve("webapps").resolve("manager").isDirectory()) {
                NutsCp.of((NutsSession)this.getSession()).from(catalinaHome.resolve("webapps").resolve("manager")).to(catalinaBase.resolve("webapps").resolve("manager")).removeOptions(new NutsPathOption[]{NutsPathOption.REPLACE_EXISTING}).run();
                catalinaBaseUpdated = true;
            }
        } else {
            if (catalinaBase.resolve("webapps").resolve("host-manager").isDirectory()) {
                catalinaBase.resolve("webapps").resolve("host-manager").deleteTree();
            }
            if (catalinaBase.resolve("webapps").resolve("manager").isDirectory()) {
                catalinaBase.resolve("webapps").resolve("manager").deleteTree();
            }
            catalinaBaseUpdated = true;
        }
        if (catalinaBaseUpdated) {
            if (this.getSession().isPlainOut()) {
                this.getSession().out().printf("%s updated catalina base %s\n", new Object[]{this.getFormattedPrefix(this.getName()), catalinaBase});
            }
            return true;
        }
        return false;
    }

    public NutsExecCommand invokeCatalina(String catalinaCommand) {
        this.buildCatalinaBase();
        NutsPath catalinaHome = this.getCatalinaHome();
        NutsPath catalinaBase = this.getCatalinaBase();
        NutsSession session = this.getSession();
        String ext = session.env().getOsFamily() == NutsOsFamily.WINDOWS ? "bat" : "sh";
        NutsExecCommand b = session.exec().setExecutionType(NutsExecutionType.SYSTEM).setSession(session);
        b.addCommand(new String[]{catalinaHome + "/bin/catalina." + ext});
        b.addCommand(new String[]{catalinaCommand});
        b.setDirectory(catalinaBase.toString());
        LocalTomcatConfig c = this.getConfig();
        String javaHome = c.getJavaHome();
        if (javaHome == null) {
            javaHome = System.getProperty("java.home");
        }
        b.setEnv("JAVA_HOME", javaHome);
        b.setEnv("JRE_HOME", javaHome);
        StringBuilder javaOptions = new StringBuilder();
        javaOptions.append("-Dnuts-config-name=").append(this.getName() == null ? "" : this.getName());
        if (this.getConfig().getJavaOptions() != null) {
            javaOptions.append(" ").append(this.getConfig().getJavaOptions());
        }
        b.setEnv("JAVA_OPTS", javaOptions.toString());
        b.setEnv("CATALINA_HOME", catalinaHome.toString());
        b.setEnv("CATALINA_BASE", catalinaBase.toString());
        b.setEnv("CATALINA_OUT", catalinaBase.resolve("logs").resolve("catalina.out").toString());
        b.setEnv("CATALINA_TMPDIR", catalinaBase.resolve("temp").toString());
        NutsElements elem = NutsElements.of((NutsSession)session);
        if ("start".equals(catalinaCommand)) {
            if (session.isPlainOut()) {
                session.out().printf("%s starting Tomcat on port " + this.getHttpConnectorPort() + ". CMD=%s.\n", new Object[]{this.getFormattedPrefix(this.getName()), b.toString()});
                b.getResult();
            } else {
                b.grabOutputString();
                int x = b.getResult();
                String txt = b.getOutputString();
                session.eout().add((NutsElement)elem.ofObject().set("command", "catalina-start").set("result-code", x).set("catalina-out", txt).build());
            }
        } else if ("stop".equals(catalinaCommand)) {
            if (session.isPlainOut()) {
                session.out().printf("%s stopping Tomcat. CMD=%s.\n", new Object[]{this.getFormattedPrefix(this.getName()), b.toString()});
                b.getResult();
            } else {
                b.grabOutputString();
                int x = b.getResult();
                String txt = b.getOutputString();
                session.eout().add((NutsElement)elem.ofObject().set("command", "catalina-stop").set("result-code", x).set("catalina-out", txt).build());
            }
        }
        return b;
    }

    private boolean mkdirs(NutsPath catalinaBase) {
        if (!catalinaBase.isDirectory()) {
            catalinaBase.mkdirs();
            return true;
        }
        return false;
    }

    public boolean start(String[] deployApps, boolean deleteLog) {
        LocalTomcatConfig c = this.getConfig();
        RunningTomcat jpsResult = this.getRunningTomcat();
        if (jpsResult != null) {
            NutsSession session = this.getSession();
            if (session.isPlainOut()) {
                session.out().printf("%s Tomcat already started on port " + this.getHttpConnectorPort() + ".\n", new Object[]{this.getFormattedPrefix(this.getName())});
            } else {
                session.eout().add((NutsElement)NutsElements.of((NutsSession)session).ofObject().set("config-name", this.getName()).set("command", "start").set("result", "already-started").build());
            }
            return false;
        }
        for (String app : new HashSet<String>(Arrays.asList(this.parseApps(deployApps)))) {
            this.getApp(app, NutsOpenMode.OPEN_OR_ERROR).deploy(null);
        }
        if (deleteLog) {
            this.deleteOutLog();
        }
        NutsExecCommand b = this.invokeCatalina("start");
        this.waitForRunningStatus(null, null, c.getStartupWaitTime());
        return true;
    }

    private NutsDefinition getCatalinaNutsDefinition() {
        String catalinaVersion = this.getRequestedCatalinaVersion();
        if (catalinaVersion == null) {
            catalinaVersion = "";
        }
        catalinaVersion = catalinaVersion.trim();
        NutsSession session = this.getSession();
        if (catalinaVersion.isEmpty()) {
            NutsVersion javaVersion = session.env().getPlatform().getVersion();
            catalinaVersion = javaVersion.compareTo("1.8") >= 0 ? "[9,[" : (javaVersion.compareTo("1.7") >= 0 ? "[8.5,9[" : (javaVersion.compareTo("1.6") >= 0 ? "[7,8[" : (javaVersion.compareTo("1.5") < 0 ? "[6,7[" : (javaVersion.compareTo("1.4") < 0 ? "[5.5,6[" : (javaVersion.compareTo("1.3") < 0 ? "[4.1,5[" : "[3.3,4[")))));
        }
        if (this.catalinaNutsDefinition == null || !Objects.equals(catalinaVersion, this.catalinaVersion) || !this.catalinaNutsDefinition.getInstallInformation().getInstallStatus().isInstalled()) {
            NutsSearchCommand searchLatestCommand;
            NutsDefinition r;
            this.catalinaVersion = catalinaVersion;
            String cv = catalinaVersion;
            if (!cv.startsWith("[") && !cv.startsWith("]")) {
                cv = "[" + catalinaVersion + "," + catalinaVersion + ".99999]";
            }
            if ((r = (NutsDefinition)(searchLatestCommand = session.search().addId("org.apache.catalina:apache-tomcat#" + cv).setSession(this.getSession()).setLatest(true)).setInstallStatus(NutsInstallStatusFilters.of((NutsSession)session).byDeployed(true)).getResultDefinitions().first()) == null) {
                r = (NutsDefinition)searchLatestCommand.setInstallStatus(NutsInstallStatusFilters.of((NutsSession)session).byInstalled(false)).setSession(searchLatestCommand.getSession().copy().setFetchStrategy(NutsFetchStrategy.OFFLINE)).getResultDefinitions().first();
            }
            if (r == null) {
                r = (NutsDefinition)searchLatestCommand.setSession(searchLatestCommand.getSession().copy().setFetchStrategy(NutsFetchStrategy.ONLINE)).setInstallStatus(NutsInstallStatusFilters.of((NutsSession)session).byInstalled(false)).getResultDefinitions().required();
            }
            if (r.getInstallInformation().isInstalledOrRequired()) {
                return r;
            }
            this.catalinaNutsDefinition = (NutsDefinition)session.install().addId(r.getId()).setSession(this.getSession().copy().addListener((NutsListener)new NutsInstallListener(){

                public void onInstall(NutsInstallEvent event) {
                    if (LocalTomcatConfigService.this.getSession().isPlainOut()) {
                        LocalTomcatConfigService.this.getSession().out().printf("%s Tomcat installed to catalina home %s\n", new Object[]{LocalTomcatConfigService.this.getFormattedPrefix(LocalTomcatConfigService.this.getName()), event.getDefinition().getInstallInformation().getInstallFolder()});
                    }
                }
            })).getResult().required();
            this.catalinaNutsDefinition = (NutsDefinition)searchLatestCommand.setInstallStatus(NutsInstallStatusFilters.of((NutsSession)session).byInstalled(true)).getResultDefinitions().first();
        }
        return this.catalinaNutsDefinition;
    }

    public void deployFile(NutsPath file, String contextName, String domain) {
        NutsPath c;
        String fileName = file.getName().toString();
        if (fileName.endsWith(".war")) {
            if (NutsBlankable.isBlank((String)contextName)) {
                contextName = fileName.substring(0, fileName.length() - ".war".length());
            }
            c = this.getDefaulDeployFolder(domain).resolve(contextName + ".war");
            if (this.getSession().isPlainOut()) {
                this.getSession().out().printf("%s deploy file file %s to %s.\n", new Object[]{this.getFormattedPrefix(this.getName()), file, c});
            }
        } else {
            throw new RuntimeException("expected war file");
        }
        NutsCp.of((NutsSession)this.getSession()).from(file).to(c).run();
    }

    public boolean stop() {
        if (this.getRunningTomcat() == null) {
            if (this.getSession().isPlainOut()) {
                this.getSession().out().printf("%s Tomcat already stopped.\n", new Object[]{this.getFormattedPrefix(this.getName())});
            }
            return false;
        }
        LocalTomcatConfig c = this.getConfig();
        NutsExecCommand b = this.invokeCatalina("stop");
        return this.waitForStoppedStatus(c.getShutdownWaitTime(), c.isKill());
    }

    public RunningTomcat getRunningTomcat() {
        NutsPath catalinaBase = this.getCatalinaBase();
        return Arrays.stream(TomcatUtils.getRunningInstances(this.context)).filter(p -> catalinaBase == null || catalinaBase.toString().equals(p.getBase())).findFirst().orElse(null);
    }

    private boolean checkExec(NutsPath pathname) {
        if (!pathname.getPermissions().contains(NutsPathPermission.CAN_EXECUTE)) {
            pathname.addPermissions(new NutsPathPermission[]{NutsPathPermission.CAN_EXECUTE});
            return true;
        }
        return false;
    }

    public boolean restart() {
        return this.restart(null, false);
    }

    public boolean restart(String[] deployApps, boolean deleteLog) {
        this.stop();
        if (this.getRunningTomcat() != null) {
            throw new NutsExecutionException(this.getSession(), NutsMessage.cstyle((String)"server %s is running. it cannot be stopped!", (Object[])new Object[]{this.getName()}), 2);
        }
        this.start(deployApps, deleteLog);
        return true;
    }

    public AppStatus waitForRunningStatus(String domain, String app, int timeout) {
        long startTime = System.currentTimeMillis();
        AppStatus y = this.getStatus(domain, app);
        NutsSession session = this.getSession();
        NutsElements elem = NutsElements.of((NutsSession)session);
        if (y == AppStatus.RUNNING) {
            if (session.isPlainOut()) {
                session.out().printf("%s Tomcat started on port " + this.getHttpConnectorPort() + ".\n", new Object[]{this.getFormattedPrefix(this.getName())});
            } else {
                session.eout().add((NutsElement)elem.ofObject().set("command", "wait-for-running").set("time", 0).set("result", "success").build());
            }
            return y;
        }
        if (timeout <= 0) {
            RunningTomcat ps = this.getRunningTomcat();
            if (ps != null) {
                if (session.isPlainOut()) {
                    session.out().printf("%s Tomcat started on port" + this.getHttpConnectorPort() + " .\n", new Object[]{this.getFormattedPrefix(this.getName())});
                    return AppStatus.RUNNING;
                }
                session.eout().add((NutsElement)elem.ofObject().set("command", "wait-for-running").set("time", 0).set("result", "success").build());
            } else if (!session.isPlainOut()) {
                session.eout().add((NutsElement)elem.ofObject().set("command", "wait-for-running").set("time", 0).set("result", "fail").build());
            }
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to start tomcat", (Object[])new Object[0]), 2);
        }
        for (int i = 0; i < timeout; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            y = this.getStatus(domain, app);
            if (y != AppStatus.RUNNING) continue;
            if (session.isPlainOut()) {
                session.out().printf("%s Tomcat started on port " + this.getHttpConnectorPort() + ".\n", new Object[]{this.getFormattedPrefix(this.getName())});
            } else {
                session.eout().add((NutsElement)elem.ofObject().set("command", "wait-for-running").set("config-name", this.getName()).set("http-connector-port", this.getHttpConnectorPort().intValue()).set("time", (double)(System.currentTimeMillis() - startTime)).set("result", "success").build());
            }
            return y;
        }
        if (y == AppStatus.OUT_OF_MEMORY) {
            if (session.isPlainOut()) {
                session.out().printf("%s Tomcat out of memory.\n", new Object[]{this.getFormattedPrefix(this.getName())});
            } else {
                session.eout().add((NutsElement)elem.ofObject().set("command", "wait-for-running").set("config-name", this.getName()).set("http-connector-port", this.getHttpConnectorPort().intValue()).set("time", (double)(System.currentTimeMillis() - startTime)).set("result", "out-of-memory").build());
            }
            return y;
        }
        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to start tomcat", (Object[])new Object[0]), 2);
    }

    public boolean waitForStoppedStatus(int timeout, boolean kill) {
        long startTime = System.currentTimeMillis();
        RunningTomcat ps = this.getRunningTomcat();
        NutsSession session = this.getSession();
        if (ps == null) {
            if (session.isPlainOut()) {
                session.out().printf("%s Tomcat stopped.\n", new Object[]{this.getFormattedPrefix(this.getName())});
            } else {
                session.eout().add((NutsElement)NutsElements.of((NutsSession)session).ofObject().set("command", "wait-for-stopped").set("config-name", this.getName()).set("http-connector-port", this.getHttpConnectorPort().intValue()).set("time", 0).set("result", "stopped").build());
            }
            return true;
        }
        for (int i = 0; i < timeout; ++i) {
            session.out().printf("%s waiting Tomcat process to die.\n", new Object[]{this.getFormattedPrefix(this.getName())});
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ps = this.getRunningTomcat();
            if (ps != null) continue;
            if (session.isPlainOut()) {
                session.out().printf("%s Tomcat stopped.\n", new Object[]{this.getFormattedPrefix(this.getName())});
            } else {
                session.eout().add((NutsElement)NutsElements.of((NutsSession)session).ofObject().set("command", "wait-for-stopped").set("config-name", this.getName()).set("http-connector-port", this.getHttpConnectorPort().intValue()).set("time", (double)(System.currentTimeMillis() - startTime)).set("result", "stopped").build());
            }
            return true;
        }
        if (kill && NutsPs.of((NutsSession)session).isSupportedKillProcess() && (ps = this.getRunningTomcat()) != null) {
            if (NutsPs.of((NutsSession)session).killProcess(ps.getPid())) {
                if (session.isPlainOut()) {
                    session.out().printf("%s Tomcat process killed (%s).\n", new Object[]{this.getFormattedPrefix(this.getName()), ps.getPid()});
                } else {
                    session.eout().add((NutsElement)NutsElements.of((NutsSession)session).ofObject().set("command", "wait-for-stopped").set("config-name", this.getName()).set("http-connector-port", this.getHttpConnectorPort().intValue()).set("time", (double)(System.currentTimeMillis() - startTime)).set("pid", ps.getPid()).set("result", "killed").build());
                }
                return true;
            }
            if (session.isPlainOut()) {
                session.out().printf("%s Tomcat process could not be killed ( %s).\n", new Object[]{this.getFormattedPrefix(this.getName()), ps.getPid()});
            } else {
                session.eout().add((NutsElement)NutsElements.of((NutsSession)session).ofObject().set("command", "wait-for-stopped").set("config-name", this.getName()).set("http-connector-port", this.getHttpConnectorPort().intValue()).set("time", (double)(System.currentTimeMillis() - startTime)).set("pid", ps.getPid()).set("result", "unable-to-kill").build());
            }
            return false;
        }
        ps = this.getRunningTomcat();
        if (ps != null) {
            if (session.isPlainOut()) {
                session.out().printf("%s Tomcat process could not be terminated (%s).\n", new Object[]{this.getFormattedPrefix(this.getName()), ps.getPid()});
            } else {
                session.eout().add((NutsElement)NutsElements.of((NutsSession)session).ofObject().set("command", "wait-for-stopped").set("config-name", this.getName()).set("http-connector-port", this.getHttpConnectorPort().intValue()).set("time", (double)(System.currentTimeMillis() - startTime)).set("pid", ps.getPid()).set("result", "unable-to-stop").build());
            }
            return true;
        }
        if (session.isPlainOut()) {
            session.out().printf("%s\n", new Object[]{this.getFormattedError("Tomcat stopped")});
        } else {
            session.eout().add((NutsElement)NutsElements.of((NutsSession)session).ofObject().set("command", "wait-for-stopped").set("config-name", this.getName()).set("http-connector-port", this.getHttpConnectorPort().intValue()).set("time", (double)(System.currentTimeMillis() - startTime)).set("result", "stopped").build());
        }
        return true;
    }

    public AppStatus getStatus() {
        return this.getStatus(null, null);
    }

    public AppStatus getStatus(String domain, String app) {
        LocalTomcatConfig c = this.getConfig();
        NutsPath catalinaBase = this.getCatalinaBase();
        RunningTomcat ps = this.getRunningTomcat();
        if (ps != null) {
            NutsPath log;
            String startupMessage = null;
            String shutdownMessage = null;
            String logFile = null;
            if (app != null) {
                LocalTomcatAppConfigService a = this.getApp(app, NutsOpenMode.OPEN_OR_ERROR);
                domain = a.getConfig().getDomain();
                startupMessage = a.getConfig().getStartupMessage();
                shutdownMessage = a.getConfig().getShutdownMessage();
            }
            if (domain != null) {
                LocalTomcatDomainConfigService tomcatDomain = this.getDomain(domain, NutsOpenMode.OPEN_OR_ERROR);
                startupMessage = tomcatDomain.getConfig().getStartupMessage();
                shutdownMessage = tomcatDomain.getConfig().getShutdownMessage();
                logFile = tomcatDomain.getConfig().getLogFile();
            }
            if (startupMessage == null || startupMessage.trim().isEmpty()) {
                startupMessage = c.getStartupMessage();
            }
            if (shutdownMessage == null || shutdownMessage.trim().isEmpty()) {
                shutdownMessage = c.getShutdownMessage();
            }
            if (startupMessage == null || startupMessage.trim().isEmpty()) {
                startupMessage = c.getStartupMessage();
            }
            if (startupMessage == null || startupMessage.trim().isEmpty()) {
                startupMessage = "org.apache.catalina.startup.Catalina.start Server startup";
            }
            if (shutdownMessage == null || shutdownMessage.trim().isEmpty()) {
                shutdownMessage = c.getShutdownMessage();
            }
            if (logFile == null || logFile.isEmpty()) {
                logFile = c.getLogFile();
            }
            if (logFile == null || logFile.isEmpty()) {
                logFile = "logs/catalina.out";
            }
            if (!(log = catalinaBase.resolve(logFile)).exists()) {
                return AppStatus.STOPPED;
            }
            LocalTomcatLogLineVisitor visitor = new LocalTomcatLogLineVisitor(log.toString(), startupMessage, shutdownMessage, this.getSession());
            visitor.visit();
            if (visitor.outOfMemoryError) {
                return AppStatus.OUT_OF_MEMORY;
            }
            if (visitor.started != null && visitor.started.booleanValue()) {
                return AppStatus.RUNNING;
            }
            return AppStatus.STOPPED;
        }
        return AppStatus.STOPPED;
    }

    public void checkExists() {
        if (!this.existsConfig()) {
            throw new NamedItemNotFoundException("Instance not found : " + this.getName(), this.getName());
        }
    }

    public LocalTomcatConfigService loadConfig() {
        String name = this.getName();
        NutsPath f = this.sharedConfigFolder.resolve(name + LOCAL_CONFIG_EXT);
        if (f.exists()) {
            NutsSession session = this.getSession();
            this.config = (LocalTomcatConfig)NutsElements.of((NutsSession)session).json().parse(f, LocalTomcatConfig.class);
            return this;
        }
        throw new NamedItemNotFoundException("Instance not found : " + this.getName(), this.getName());
    }

    public LocalTomcatAppConfigService getApp(String appName, NutsOpenMode mode) {
        appName = TomcatUtils.toValidFileName(appName, "default");
        LocalTomcatAppConfig a = this.getConfig().getApps().get(appName);
        if (mode == null) {
            if (a == null) {
                return null;
            }
        } else {
            switch (mode) {
                case OPEN_OR_ERROR: {
                    if (a != null) break;
                    throw new NutsExecutionException(this.getSession(), NutsMessage.cstyle((String)"app not found : %s", (Object[])new Object[]{appName}), 2);
                }
                case CREATE_OR_ERROR: {
                    if (a == null) {
                        a = new LocalTomcatAppConfig();
                        this.getConfig().getApps().put(appName, a);
                        break;
                    }
                    throw new NutsExecutionException(this.getSession(), NutsMessage.cstyle((String)"app already found : %s", (Object[])new Object[]{appName}), 2);
                }
                case OPEN_OR_CREATE: {
                    if (a != null) break;
                    a = new LocalTomcatAppConfig();
                    this.getConfig().getApps().put(appName, a);
                }
            }
        }
        return new LocalTomcatAppConfigService(appName, a, this);
    }

    public LocalTomcatDomainConfigService getDomain(String domainName, NutsOpenMode mode) {
        domainName = TomcatUtils.toValidFileName(domainName, "");
        LocalTomcatDomainConfig a = this.getConfig().getDomains().get(domainName);
        if (mode == null) {
            if (a == null) {
                return null;
            }
        } else {
            switch (mode) {
                case OPEN_OR_ERROR: {
                    if (a != null) break;
                    throw new NutsExecutionException(this.getSession(), NutsMessage.cstyle((String)"domain not found : %s", (Object[])new Object[]{domainName}), 2);
                }
                case CREATE_OR_ERROR: {
                    if (a == null) {
                        a = new LocalTomcatDomainConfig();
                        this.getConfig().getDomains().put(domainName, a);
                        break;
                    }
                    throw new NutsExecutionException(this.getSession(), NutsMessage.cstyle((String)"domain already found : %s", (Object[])new Object[]{domainName}), 2);
                }
                case OPEN_OR_CREATE: {
                    if (a != null) break;
                    a = new LocalTomcatDomainConfig();
                    this.getConfig().getDomains().put(domainName, a);
                }
            }
        }
        return new LocalTomcatDomainConfigService(domainName, a, this);
    }

    public NutsPath getLogFolder() {
        return this.getCatalinaBase().resolve("logs");
    }

    public NutsPath getTempFolder() {
        return this.getCatalinaBase().resolve("temp");
    }

    public NutsPath getWorkFolder() {
        return this.getCatalinaBase().resolve("work");
    }

    public void deleteOutLog() {
        NutsPath file = this.getLogFolder().resolve("catalina.out");
        if (file.isRegularFile()) {
            if (this.getSession().isPlainOut()) {
                this.getSession().out().printf("%s delete log file %s.\n", new Object[]{this.getFormattedPrefix(this.getName()), file});
            }
            file.delete();
        }
    }

    public void deleteTemp() {
        NutsPath tempFolder = this.getTempFolder();
        if (tempFolder.isDirectory()) {
            tempFolder.list().forEach(file -> {
                if (this.getSession().isPlainOut()) {
                    this.getSession().out().printf("%s delete temp file %s.\n", new Object[]{this.getFormattedPrefix(this.getName()), file});
                }
                file.delete();
            });
        }
    }

    public void deleteWork() {
        NutsPath workFolder = this.getWorkFolder();
        if (workFolder.isDirectory()) {
            workFolder.list().forEach(file -> {
                if (this.getSession().isPlainOut()) {
                    this.getSession().out().printf("%s delete work file %s.\n", new Object[]{this.getFormattedPrefix(this.getName()), file});
                }
                file.delete();
            });
        }
    }

    public NutsPath getOutLogFile() {
        return this.getLogFolder().resolve("catalina.out");
    }

    public void showOutLog(int tail) {
        NutsPath file = this.getOutLogFile();
        NutsSession session = this.getSession();
        if (tail <= 0) {
            NutsCp.of((NutsSession)session).from(file).to(session.out()).run();
            return;
        }
        if (file.isRegularFile()) {
            for (String line : file.tail(tail)) {
                session.out().println(line);
            }
        }
    }

    public void deleteAllLog() {
        NutsPath logFolder = this.getLogFolder();
        if (logFolder.isDirectory()) {
            logFolder.list().forEach(file -> {
                String n;
                if (file.isRegularFile() && ((n = file.getName()).endsWith(".out") || n.endsWith(".txt") || n.endsWith(".log"))) {
                    if (this.getSession().isPlainOut()) {
                        this.getSession().out().printf("%s delete log file %s.\n", new Object[]{this.getFormattedPrefix(this.getName()), file});
                    }
                    file.delete();
                }
            });
        }
    }

    public List<LocalTomcatAppConfigService> getApps() {
        ArrayList<LocalTomcatAppConfigService> a = new ArrayList<LocalTomcatAppConfigService>();
        for (String s : this.getConfig().getApps().keySet()) {
            a.add(new LocalTomcatAppConfigService(s, this.getConfig().getApps().get(s), this));
        }
        return a;
    }

    public List<LocalTomcatDomainConfigService> getDomains() {
        ArrayList<LocalTomcatDomainConfigService> a = new ArrayList<LocalTomcatDomainConfigService>();
        for (String s : this.getConfig().getDomains().keySet()) {
            a.add(new LocalTomcatDomainConfigService(s, this.getConfig().getDomains().get(s), this));
        }
        return a;
    }

    public NutsPath getDefaulDeployFolder(String domainName) {
        String p = "webapps";
        if (domainName == null) {
            domainName = "";
        }
        if (!domainName.equals("")) {
            p = p + "/" + domainName;
        }
        return this.getCatalinaBase().resolve(p);
    }

    public LocalTomcat getTomcatServer() {
        return this.app;
    }

    public NutsApplicationContext getContext() {
        return this.context;
    }

    public Integer getShutdownPort() {
        block3: {
            try {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                NutsPath serverXml = this.getCatalinaBase().resolve("conf").resolve("server.xml");
                if (serverXml.exists()) {
                    Document doc = docBuilder.parse(serverXml.toFile().toFile());
                    Element root = doc.getDocumentElement();
                    String port = root.getAttribute("port");
                    return port == null ? null : Integer.valueOf(Integer.parseInt(port));
                }
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                if (!this.getSession().isPlainOut()) break block3;
                this.getSession().err().println("```error ERROR:``` : " + ex);
            }
        }
        return null;
    }

    public void setShutdownPort(int port) {
        block5: {
            try {
                if (port <= 0) {
                    port = 8005;
                }
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                NutsPath serverXml = this.getCatalinaBase().resolve("conf").resolve("server.xml");
                if (serverXml.exists()) {
                    Document doc = docBuilder.parse(serverXml.toFile().toFile());
                    Element root = doc.getDocumentElement();
                    String p = root.getAttribute("port");
                    if (String.valueOf(port).equals(p)) {
                        return;
                    }
                    root.setAttribute("port", String.valueOf(port));
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource domSource = new DOMSource(doc);
                    StreamResult streamResult = new StreamResult(serverXml.toFile().toFile());
                    transformer.transform(domSource, streamResult);
                }
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException ex) {
                if (!this.getSession().isPlainOut()) break block5;
                this.getSession().err().println("```error ERROR:``` : " + ex);
            }
        }
    }

    public Integer getHttpConnectorPort(boolean redirect) {
        return this.getConnectorPort("HTTP/1.1", redirect);
    }

    public Integer getAjpConnectorPort(boolean redirect) {
        return this.getConnectorPort("AJP/1.3", redirect);
    }

    public Integer getHttpConnectorPort() {
        return this.getHttpConnectorPort(false);
    }

    public Integer getHttpConnectorRedirectPort() {
        return this.getHttpConnectorPort(true);
    }

    public Integer getAjpConnectorPort() {
        return this.getAjpConnectorPort(false);
    }

    public Integer getAjpConnectorRedirectPort() {
        return this.getAjpConnectorPort(true);
    }

    public Integer getConnectorPort(String protocol, boolean redirect) {
        block4: {
            if (protocol == null) {
                protocol = "HTTP/1.1";
            }
            String _protocol = protocol;
            try {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                NutsPath serverXml = this.getCatalinaBase().resolve("conf").resolve("server.xml");
                if (serverXml.exists()) {
                    Document doc = docBuilder.parse(serverXml.toFile().toFile());
                    Element root = doc.getDocumentElement();
                    String port = XmlUtils.streamElements(root.getChildNodes()).filter(x -> "Service".equalsIgnoreCase(x.getTagName())).flatMap(x -> XmlUtils.streamElements(x.getChildNodes())).filter(x -> "Connector".equalsIgnoreCase(x.getTagName()) && _protocol.equals(x.getAttribute("protocol"))).map(x -> x.getAttribute(redirect ? "redirectPort" : "port")).distinct().findAny().get();
                    return port == null ? null : Integer.valueOf(Integer.parseInt(port));
                }
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                if (!this.getSession().isPlainOut()) break block4;
                this.getSession().err().println("```error ERROR:``` : " + ex);
            }
        }
        return null;
    }

    public void setAjpConnectorPort(boolean redirect, int port) {
        this.setConnectorPort("AJP/1.3", redirect, port);
    }

    public void setHttpConnectorPort(boolean redirect, int port) {
        this.setConnectorPort("HTTP/1.1", redirect, port);
    }

    public void setConnectorPort(String protocol, boolean redirect, int port) {
        block10: {
            if (protocol == null) {
                protocol = "HTTP/1.1";
            }
            if (port <= 0) {
                if ("AJP/1.3".equals(protocol)) {
                    port = redirect ? 8443 : 8009;
                } else if ("HTTP/1.1".equals(protocol)) {
                    port = redirect ? 8080 : 8443;
                }
            }
            String _protocol = protocol;
            try {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                NutsPath serverXml = this.getCatalinaBase().resolve("conf").resolve("server.xml");
                if (serverXml.exists()) {
                    Document doc = docBuilder.parse(serverXml.toFile().toFile());
                    Element root = doc.getDocumentElement();
                    Element elem = XmlUtils.streamElements(root.getChildNodes()).filter(x -> "Service".equalsIgnoreCase(x.getTagName())).flatMap(x -> XmlUtils.streamElements(x.getChildNodes())).filter(x -> "Connector".equalsIgnoreCase(x.getTagName()) && _protocol.equals(x.getAttribute("protocol"))).findAny().orElse(null);
                    if (elem != null) {
                        String p = elem.getAttribute(redirect ? "redirectPort" : "port");
                        if (String.valueOf(port).equals(p)) {
                            return;
                        }
                        elem.setAttribute(redirect ? "redirectPort" : "port", String.valueOf(port));
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                        Transformer transformer = transformerFactory.newTransformer();
                        DOMSource domSource = new DOMSource(doc);
                        StreamResult streamResult = new StreamResult(serverXml.toFile().toFile());
                        transformer.transform(domSource, streamResult);
                        return;
                    }
                    throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"not found connector", (Object[])new Object[0]));
                }
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException ex) {
                if (!this.getSession().isPlainOut()) break block10;
                this.getSession().err().printf("```error ERROR:``` : %s%n", new Object[]{ex});
            }
        }
    }
}

