/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntomcat.local;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcatConfigService;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcatDomainConfigService;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcatServiceBase;
import net.thevpc.nuts.toolbox.ntomcat.local.config.LocalTomcatAppConfig;
import net.thevpc.nuts.toolbox.ntomcat.util._StringUtils;

public class LocalTomcatAppConfigService
extends LocalTomcatServiceBase {
    private String name;
    private LocalTomcatAppConfig config;
    private LocalTomcatConfigService tomcat;
    private NutsApplicationContext context;
    private NutsPath sharedConfigFolder;

    public LocalTomcatAppConfigService(String name, LocalTomcatAppConfig config, LocalTomcatConfigService tomcat) {
        this.name = name;
        this.config = config;
        this.tomcat = tomcat;
        this.context = tomcat.getTomcatServer().getContext();
        this.sharedConfigFolder = tomcat.getContext().getVersionFolder(NutsStoreLocation.CONFIG, "0.8.0.0");
    }

    @Override
    public LocalTomcatAppConfig getConfig() {
        return this.config;
    }

    public LocalTomcatConfigService getTomcat() {
        return this.tomcat;
    }

    public Path getArchiveFile(String version) {
        String runningFolder = this.tomcat.getConfig().getArchiveFolder();
        if (runningFolder == null || runningFolder.trim().isEmpty()) {
            runningFolder = this.context.getSharedConfigFolder().resolve("archive").toString();
        }
        String packaging = "war";
        return Paths.get(runningFolder, new String[0]).resolve(this.name + "-" + version + "." + packaging);
    }

    public NutsPath getRunningFile() {
        NutsPath runningFolder;
        String s = this.getConfig().getSourceFilePath();
        if (!NutsBlankable.isBlank((String)s)) {
            return NutsPath.of((String)s, (NutsSession)this.getSession());
        }
        String _runningFolder = this.tomcat.getConfig().getRunningFolder();
        NutsPath nutsPath = runningFolder = _runningFolder == null || _runningFolder.trim().isEmpty() ? null : NutsPath.of((String)_runningFolder, (NutsSession)this.getSession());
        if (runningFolder == null) {
            runningFolder = this.context.getSharedConfigFolder().resolve("running");
        }
        String packaging = "war";
        return runningFolder.resolve(this.name + "." + packaging);
    }

    private NutsSession getSession() {
        return this.context.getSession();
    }

    public NutsPath getVersionFile() {
        return this.sharedConfigFolder.resolve(this.name + ".version");
    }

    public String getCurrentVersion() {
        NutsPath f = this.getVersionFile();
        if (f.exists()) {
            return new String(f.readAllBytes());
        }
        return null;
    }

    public NutsString getFormattedPath(String str) {
        return NutsTexts.of((NutsSession)this.getSession()).ofStyled(str, NutsTextStyle.path());
    }

    public NutsString getFormattedVersion(String str) {
        return NutsTexts.of((NutsSession)this.getSession()).ofStyled(str, NutsTextStyle.version());
    }

    public NutsString getFormattedPrefix(String str) {
        return NutsTexts.of((NutsSession)this.getSession()).builder().append((Object)"[").append((Object)str, NutsTextStyle.primary5()).append((Object)"]");
    }

    public LocalTomcatAppConfigService setCurrentVersion(String version) {
        if (version == null || version.trim().isEmpty()) {
            this.getSession().out().printf("%s unset version.\n", new Object[]{this.getFormattedPrefix(this.getFullName())});
            this.getVersionFile().delete();
            this.getSession().out().printf("%s [LOG] delete version file %s.\n", new Object[]{this.getFormattedPrefix(this.getFullName()), this.getFormattedPath(this.getVersionFile().toString())});
            this.getRunningFile().delete();
            this.getSession().out().printf("%s [LOG] delete running file %s.\n", new Object[]{this.getFormattedPrefix(this.getFullName()), this.getFormattedPath(this.getRunningFile().toString())});
        } else {
            this.getSession().out().printf("%s set version %s.\n", new Object[]{this.getFullName(), this.getFormattedVersion(version)});
            this.getSession().out().printf("%s [LOG] updating version file %s to %s.\n", new Object[]{this.getFormattedPrefix(this.getFullName()), this.getFormattedVersion(_StringUtils.coalesce(version, "<DEFAULT>")), this.getFormattedPath(this.getVersionFile().toString())});
            this.getVersionFile().writeBytes(version.getBytes());
            this.getSession().out().printf("%s [LOG] updating archive file %s -> %s.\n", new Object[]{this.getFormattedPrefix(this.getFullName()), this.getFormattedPath(this.getArchiveFile(version).toString()), this.getFormattedPath(this.getRunningFile().toString())});
            NutsCp.of((NutsSession)this.getSession()).from(this.getArchiveFile(version)).to(this.getRunningFile()).run();
        }
        return this;
    }

    public NutsPath getDeployFile() {
        LocalTomcatDomainConfigService d = this.tomcat.getDomain(this.getConfig().getDomain(), NutsOpenMode.OPEN_OR_ERROR);
        String deployName = this.getConfig().getDeployName();
        if (NutsBlankable.isBlank((String)deployName)) {
            deployName = this.name + ".war";
        }
        if (!deployName.endsWith(".war")) {
            deployName = deployName + ".war";
        }
        return d.getDomainDeployPath().resolve(deployName);
    }

    public NutsPath getDeployFolder() {
        NutsPath f = this.getDeployFile();
        String fn = f.getName().toString();
        return f.resolveSibling(fn.substring(0, fn.length() - ".war".length()));
    }

    public LocalTomcatAppConfigService resetDeployment() {
        NutsPath deployFile = this.getDeployFile();
        NutsPath deployFolder = this.getDeployFolder();
        this.getSession().out().printf("%s reset deployment (delete %s ).\n", new Object[]{this.getFormattedPrefix(this.getFullName()), this.getFormattedPath(deployFile.toString())});
        deployFile.delete();
        deployFolder.delete();
        return this;
    }

    public LocalTomcatAppConfigService deploy(String version) {
        if (NutsBlankable.isBlank((String)version)) {
            version = this.getCurrentVersion();
        }
        NutsPath runningFile = this.getRunningFile();
        NutsPath deployFile = this.getDeployFile();
        this.getSession().out().printf("%s deploy %s as file %s to %s.\n", new Object[]{this.getFormattedPrefix(this.getFullName()), this.getFormattedVersion(_StringUtils.coalesce(version, "<DEFAULT>")), this.getFormattedPath(runningFile.toString()), this.getFormattedPath(deployFile.toString())});
        NutsCp.of((NutsSession)this.getSession()).from(runningFile).to(deployFile).addOptions(new NutsPathOption[]{NutsPathOption.REPLACE_EXISTING}).run();
        return this;
    }

    public LocalTomcatAppConfigService install(String version, String file, boolean setVersion) {
        try {
            Path f = Paths.get(file, new String[0]);
            if (!Files.isRegularFile(f, new LinkOption[0])) {
                throw new UncheckedIOException(new IOException("File not found " + f));
            }
            if (NutsBlankable.isBlank((String)version)) {
                version = this.getCurrentVersion();
            }
            Path domainDeployPath = this.getArchiveFile(version);
            Files.createDirectories(domainDeployPath.getParent(), new FileAttribute[0]);
            this.getSession().out().printf("%s install version %s : %s->%s.\n", new Object[]{this.getFormattedPrefix(this.getFullName()), this.getFormattedVersion(version), this.getFormattedPath(f.toString()), this.getFormattedPath(domainDeployPath.toString())});
            Files.copy(f, domainDeployPath, new CopyOption[0]);
            if (setVersion) {
                this.setCurrentVersion(version);
            }
            return this;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public LocalTomcatAppConfigService remove() {
        this.tomcat.getConfig().getApps().remove(this.name);
        this.getSession().out().printf("%s app removed.\n", new Object[]{this.getFormattedPrefix(this.getFullName())});
        return this;
    }

    public String getFullName() {
        return this.tomcat.getName() + "/" + this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalTomcatAppConfigService print(NutsPrintStream out) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("name", this.getFullName());
        result.put("config", this.getConfig());
        result.put("version", this.getCurrentVersion());
        result.put("deployFile", this.getDeployFile());
        result.put("deployfolder", this.getDeployFolder());
        result.put("runningfolder", this.getRunningFile());
        result.put("versionFolder", this.getVersionFile());
        NutsSession session = this.getSession();
        NutsElements.of((NutsSession)session).json().setValue(result).print(out);
        return this;
    }
}

