/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntomcat.local;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectFormat;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUnsafeFunction;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcatAppConfigService;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcatConfigService;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcatDomainConfigService;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcatServiceBase;
import net.thevpc.nuts.toolbox.ntomcat.util.NamedItemNotFoundException;
import net.thevpc.nuts.toolbox.ntomcat.util.RunningTomcat;
import net.thevpc.nuts.toolbox.ntomcat.util.TomcatUtils;

public class LocalTomcat {
    private NutsApplicationContext context;
    private NutsCommandLine cmdLine;
    private NutsPath sharedConfigFolder;

    public LocalTomcat(NutsApplicationContext applicationContext, NutsCommandLine cmdLine) {
        this.setContext(applicationContext);
        this.cmdLine = cmdLine;
        this.sharedConfigFolder = applicationContext.getVersionFolder(NutsStoreLocation.CONFIG, "0.8.0.0");
    }

    public void runArgs() {
        this.cmdLine.setCommandName("tomcat --local");
        while (this.cmdLine.hasNext()) {
            if (this.cmdLine.peek().isOption()) {
                this.context.configureLast(this.cmdLine);
                continue;
            }
            NutsArgument a = this.cmdLine.requireNonOption().next();
            switch (a.getString()) {
                case "list": {
                    this.list(this.cmdLine);
                    return;
                }
                case "show": 
                case "describe": {
                    this.describe(this.cmdLine);
                    return;
                }
                case "add": {
                    this.add(this.cmdLine, NutsOpenMode.CREATE_OR_ERROR);
                    return;
                }
                case "set": {
                    this.add(this.cmdLine, NutsOpenMode.OPEN_OR_ERROR);
                    return;
                }
                case "remove": {
                    this.remove(this.cmdLine);
                    return;
                }
                case "start": {
                    this.restart(this.cmdLine, false);
                    return;
                }
                case "stop": {
                    this.stop(this.cmdLine);
                    return;
                }
                case "status": {
                    this.status(this.cmdLine);
                    return;
                }
                case "restart": {
                    this.restart(this.cmdLine, true);
                    return;
                }
                case "install": {
                    this.installApp(this.cmdLine);
                    return;
                }
                case "reset": {
                    this.reset();
                    return;
                }
                case "deploy": {
                    this.deployApp(this.cmdLine);
                    return;
                }
                case "deploy-file": {
                    this.deployFile(this.cmdLine);
                    return;
                }
                case "delete": {
                    this.delete(this.cmdLine);
                    return;
                }
                case "log": {
                    this.showLog(this.cmdLine);
                    return;
                }
                case "port": {
                    this.showPort(this.cmdLine);
                    return;
                }
                case "base": 
                case "catalina-base": {
                    this.showCatalinaBase(this.cmdLine);
                    return;
                }
                case "home": 
                case "catalina-home": {
                    this.showCatalinaHome(this.cmdLine);
                    return;
                }
                case "version": 
                case "catalina-version": {
                    this.showCatalinaVersion(this.cmdLine);
                }
                case "ps": {
                    this.ps(this.cmdLine);
                    return;
                }
            }
            throw new NutsExecutionException(this.context.getSession(), NutsMessage.cstyle((String)"unsupported action %s", (Object[])new Object[]{a.getString()}), 1);
        }
        throw new NutsExecutionException(this.context.getSession(), NutsMessage.cstyle((String)"missing tomcat action. Type: nuts tomcat --help", (Object[])new Object[0]), 1);
    }

    public void list(NutsCommandLine args) {
        class Helper {
            boolean apps = false;
            boolean domains = false;
            boolean processed = false;
            boolean instances = false;

            Helper() {
            }

            boolean isApps() {
                return this.apps || !this.apps && !this.domains;
            }

            boolean isDomains() {
                return this.domains || !this.apps && !this.domains;
            }

            boolean isHeader() {
                return this.isApps() && this.isDomains();
            }

            void print(LocalTomcatConfigService c) {
                List<LocalTomcatDomainConfigService> domains;
                List<LocalTomcatAppConfigService> apps;
                this.processed = true;
                if (this.isApps() && !(apps = c.getApps()).isEmpty()) {
                    if (this.isHeader()) {
                        LocalTomcat.this.context.getSession().out().printf("[[\\[%s\\]]]:\n", new Object[]{"Apps"});
                    }
                    for (LocalTomcatAppConfigService localTomcatAppConfigService : apps) {
                        LocalTomcat.this.context.getSession().out().printf("%s\n", new Object[]{localTomcatAppConfigService.getName()});
                    }
                }
                if (this.isDomains() && !(domains = c.getDomains()).isEmpty()) {
                    if (this.isHeader()) {
                        LocalTomcat.this.context.getSession().out().printf("[[\\[%s\\]]]:\n", new Object[]{"Domains"});
                    }
                    for (LocalTomcatDomainConfigService localTomcatDomainConfigService : domains) {
                        LocalTomcat.this.context.getSession().out().printf("%s\n", new Object[]{localTomcatDomainConfigService.getName()});
                    }
                }
            }
        }
        Helper x = new Helper();
        while (args.hasNext()) {
            NutsArgument a = args.nextBoolean(new String[]{"-a", "--apps"});
            if (a != null) {
                x.apps = a.getBooleanValue();
                continue;
            }
            a = args.nextBoolean(new String[]{"-d", "--domains"});
            if (a != null) {
                x.domains = a.getBooleanValue();
                continue;
            }
            a = args.nextBoolean(new String[]{"-i", "--instances"});
            if (a != null) {
                x.instances = a.getBooleanValue();
                continue;
            }
            this.context.configureLast(this.cmdLine);
        }
        if (x.instances) {
            for (LocalTomcatConfigService tomcatConfig : this.listConfig()) {
                this.getContext().getSession().out().println(tomcatConfig.getName());
            }
        } else {
            LocalTomcatConfigService s = this.nextLocalTomcatConfigService(args, NutsOpenMode.OPEN_OR_ERROR);
            x.print(s);
        }
    }

    public void ps(NutsCommandLine args) {
        String format = "default";
        args.setCommandName("tomcat --local show");
        while (args.hasNext()) {
            NutsArgument a = args.nextBoolean(new String[]{"-l", "--long"});
            if (a != null) {
                format = "long";
                continue;
            }
            a = args.nextBoolean(new String[]{"-s", "--short"});
            if (a != null) {
                format = "short";
                continue;
            }
            this.context.configureLast(this.cmdLine);
        }
        if (args.isExecMode()) {
            NutsSession session = this.context.getSession();
            NutsTexts factory = NutsTexts.of((NutsSession)session);
            if (session.isPlainOut()) {
                NutsPrintStream out = session.out();
                block9: for (RunningTomcat jpsResult : TomcatUtils.getRunningInstances(this.context)) {
                    switch (format) {
                        case "short": {
                            out.printf("%s\n", new Object[]{factory.ofStyled(jpsResult.getPid(), NutsTextStyle.primary1())});
                            continue block9;
                        }
                        case "long": {
                            out.printf("%s v%s HOME: %s BASE: %s ==CMD:== %s\n", new Object[]{factory.ofStyled(jpsResult.getPid(), NutsTextStyle.primary1()), jpsResult.getHome() == null ? null : TomcatUtils.getFolderCatalinaHomeVersion(jpsResult.getHome()), jpsResult.getHome(), jpsResult.getBase(), this.context.getCommandLine().parseLine(jpsResult.getArgsLine())});
                            continue block9;
                        }
                        default: {
                            out.printf("%s ==v==%s ==BASE:== %s\n", new Object[]{factory.ofStyled(jpsResult.getPid(), NutsTextStyle.primary1()), jpsResult.getHome() == null ? null : TomcatUtils.getFolderCatalinaHomeVersion(jpsResult.getHome()), jpsResult.getBase()});
                        }
                    }
                }
            } else {
                NutsObjectFormat.of((NutsSession)this.context.getSession()).setValue((Object)TomcatUtils.getRunningInstances(this.context)).println();
            }
        }
    }

    public void describe(NutsCommandLine args) {
        ArrayList<LocalTomcatServiceBase> toShow = new ArrayList<LocalTomcatServiceBase>();
        args.setCommandName("tomcat --local show");
        while (args.hasNext()) {
            LocalTomcatServiceBase s = this.readBaseServiceArg(args, NutsOpenMode.OPEN_OR_ERROR);
            if (s != null) {
                toShow.add(s);
                continue;
            }
            this.context.configureLast(this.cmdLine);
        }
        if (args.isExecMode()) {
            if (toShow.isEmpty()) {
                toShow.add(this.loadServiceBase("", NutsOpenMode.OPEN_OR_ERROR));
            }
            for (LocalTomcatServiceBase s2 : toShow) {
                s2.println(this.getContext().getSession().out());
            }
        }
    }

    public void add(NutsCommandLine args, NutsOpenMode autoCreate) {
        NutsArgument a = args.nextNonOption();
        if (a != null) {
            switch (a.getString()) {
                case "instance": {
                    LocalTomcatConfigService s = this.nextLocalTomcatConfigService(args, autoCreate);
                    this.addInstance(s, args, autoCreate);
                    return;
                }
                case "domain": {
                    LocalTomcatDomainConfigService s = this.nextLocalTomcatDomainConfigService(args, autoCreate);
                    this.addDomain(s, args, autoCreate);
                    return;
                }
                case "app": {
                    LocalTomcatAppConfigService s = this.nextLocalTomcatAppConfigService(args, autoCreate);
                    this.addApp(s, args, autoCreate);
                    return;
                }
            }
            args.pushBack(a);
            args.setCommandName("tomcat --local add").unexpectedArgument(NutsMessage.cstyle((String)"expected instance|domain|app", (Object[])new Object[0]));
            return;
        }
        args.setCommandName("tomcat --local add").required(NutsMessage.cstyle((String)"expected instance|domain|app", (Object[])new Object[0]));
    }

    public void addInstance(LocalTomcatConfigService c, NutsCommandLine args, NutsOpenMode autoCreate) {
        args.setCommandName("tomcat --local add");
        while (args.hasNext()) {
            NutsArgument a = args.nextString(new String[]{"--catalina-version", "--tomcat-version", "--version"});
            if (a != null) {
                if (c == null) {
                    c = this.openTomcatConfig("", autoCreate);
                }
                c.getConfig().setCatalinaVersion(a.getValue().getString());
                c.getConfig().setCatalinaHome(null);
                c.getConfig().setCatalinaBase(null);
                continue;
            }
            a = args.nextString(new String[]{"--catalina-base"});
            if (a != null) {
                if (c == null) {
                    c = this.openTomcatConfig("", autoCreate);
                }
                c.getConfig().setCatalinaBase(a.getValue().getString());
                continue;
            }
            a = args.nextString(new String[]{"--catalina-home"});
            if (a != null) {
                if (c == null) {
                    c = this.openTomcatConfig("", autoCreate);
                }
                c.getConfig().setCatalinaHome(a.getValue().getString());
                c.getConfig().setCatalinaBase(null);
                c.getConfig().setCatalinaVersion(null);
                continue;
            }
            a = args.nextString(new String[]{"--shutdown-wait-time"});
            if (a != null) {
                if (c == null) {
                    c = this.openTomcatConfig("", autoCreate);
                }
                c.getConfig().setShutdownWaitTime(a.getValue().getInt());
                continue;
            }
            a = args.nextString(new String[]{"--archive-folder"});
            if (a != null) {
                if (c == null) {
                    c = this.openTomcatConfig("", NutsOpenMode.OPEN_OR_ERROR);
                }
                c.getConfig().setArchiveFolder(a.getValue().getString());
                continue;
            }
            a = args.nextString(new String[]{"--running-folder"});
            if (a != null) {
                if (c == null) {
                    c = this.openTomcatConfig("", NutsOpenMode.OPEN_OR_ERROR);
                }
                c.getConfig().setRunningFolder(a.getValue().getString());
                continue;
            }
            a = args.nextString(new String[]{"--http-port"});
            if (a != null) {
                if (c == null) {
                    c = this.openTomcatConfig("", NutsOpenMode.OPEN_OR_ERROR);
                }
                c.setHttpConnectorPort(false, a.getValue().getInt());
                continue;
            }
            a = args.nextString(new String[]{"--port"});
            if (a != null) {
                if (c == null) {
                    c = this.openTomcatConfig("", NutsOpenMode.OPEN_OR_ERROR);
                }
                c.setHttpConnectorPort(false, a.getValue().getInt());
                continue;
            }
            a = args.nextBoolean(new String[]{"-d", "--dev"});
            if (a != null) {
                if (c == null) {
                    c = this.openTomcatConfig("", NutsOpenMode.OPEN_OR_ERROR);
                }
                c.getConfig().setDev(a.getBooleanValue());
                continue;
            }
            this.context.configureLast(args);
        }
        c.save();
        c.buildCatalinaBase();
    }

    public void addDomain(LocalTomcatDomainConfigService c, NutsCommandLine args, NutsOpenMode autoCreate) {
        boolean changed = false;
        args.setCommandName("tomcat --local add");
        while (args.hasNext()) {
            NutsArgument a = args.nextString(new String[]{"--log"});
            if (a != null) {
                c.getConfig().setLogFile(a.getValue().getString());
                changed = true;
                continue;
            }
            this.context.configureLast(args);
        }
        if (changed) {
            c.getTomcat().save();
        }
    }

    public void addApp(LocalTomcatAppConfigService c, NutsCommandLine args, NutsOpenMode autoCreate) {
        boolean changed = false;
        args.setCommandName("tomcat --local add");
        while (args.hasNext()) {
            String value;
            NutsArgument a = args.nextString(new String[]{"--source"});
            if (a != null) {
                value = a.getValue().getString();
                c.getConfig().setSourceFilePath(value);
                changed = true;
                continue;
            }
            a = args.nextString(new String[]{"--deploy"});
            if (a != null) {
                value = a.getValue().getString();
                c.getConfig().setDeployName(value);
                changed = true;
                continue;
            }
            a = args.nextString(new String[]{"--domain"});
            if (a != null) {
                value = a.getValue().getString();
                c.getTomcat().getDomain(value, NutsOpenMode.OPEN_OR_ERROR);
                c.getConfig().setDomain(value);
                changed = true;
                continue;
            }
            this.context.configureLast(args);
        }
        if (changed) {
            c.getTomcat().save();
        }
    }

    public void remove(NutsCommandLine args) {
        NutsArgument a = args.nextNonOption();
        if (a != null) {
            NutsSession session = this.context.getSession();
            switch (a.getString()) {
                case "instance": {
                    LocalTomcatConfigService s = this.nextLocalTomcatConfigService(args, NutsOpenMode.OPEN_OR_ERROR);
                    if (session.getTerminal().ask().resetLine().forBoolean("Confirm Deleting %s?", new Object[]{s.getName()}).setDefaultValue((Object)true).getBooleanValue().booleanValue()) {
                        s.remove();
                    }
                    return;
                }
                case "domain": {
                    LocalTomcatDomainConfigService s = this.nextLocalTomcatDomainConfigService(args, NutsOpenMode.OPEN_OR_ERROR);
                    if (session.getTerminal().ask().resetLine().forBoolean("Confirm Deleting %s?", new Object[]{s.getName()}).setDefaultValue((Object)true).getBooleanValue().booleanValue()) {
                        s.remove();
                        s.getTomcat().save();
                    }
                    return;
                }
                case "app": {
                    LocalTomcatAppConfigService s = this.nextLocalTomcatAppConfigService(args, NutsOpenMode.OPEN_OR_ERROR);
                    if (session.getTerminal().ask().resetLine().forBoolean("Confirm Deleting %s?", new Object[]{s.getName()}).setDefaultValue((Object)true).getBooleanValue().booleanValue()) {
                        s.remove();
                        s.getTomcat().save();
                    }
                    return;
                }
            }
        }
        args.required(NutsMessage.cstyle((String)"expected instance|domain|app", (Object[])new Object[0]));
    }

    public void stop(NutsCommandLine args) {
        LocalTomcatConfigService c = this.nextLocalTomcatConfigService(args, NutsOpenMode.OPEN_OR_ERROR);
        args.setCommandName("tomcat --local stop");
        while (args.hasNext()) {
            this.context.configureLast(args);
        }
        if (!c.stop()) {
            throw new NutsExecutionException(this.context.getSession(), NutsMessage.cstyle((String)"unable to stop", (Object[])new Object[0]), 1);
        }
    }

    public NutsString getBracketsPrefix(String str) {
        return NutsTexts.of((NutsSession)this.context.getSession()).builder().append((Object)"[").append((Object)str, NutsTextStyle.primary5()).append((Object)"]");
    }

    public void status(NutsCommandLine args) {
        LocalTomcatConfigService c = null;
        String name = null;
        try {
            c = this.nextLocalTomcatConfigService(args, NutsOpenMode.OPEN_OR_ERROR);
            name = c.getName();
        }
        catch (NamedItemNotFoundException ex) {
            name = ex.getName();
        }
        if (c != null) {
            c.printStatus();
        } else {
            NutsSession session = this.context.getSession();
            if (session.isPlainOut()) {
                session.out().printf("%s Tomcat %s.\n", new Object[]{this.getBracketsPrefix(name), NutsTexts.of((NutsSession)session).ofStyled("not found", NutsTextStyle.error())});
            } else {
                session.eout().add((NutsElement)NutsElements.of((NutsSession)session).ofObject().set("config-name", name).set("status", "not-found").build());
            }
        }
    }

    public void installApp(NutsCommandLine args) {
        LocalTomcatAppConfigService app = null;
        String version = null;
        String file = null;
        LocalTomcatConfigService s = null;
        args.setCommandName("tomcat --local install");
        while (args.hasNext()) {
            NutsArgument a = args.nextString(new String[]{"--name"});
            if (a != null) {
                s = this.openTomcatConfig(a.getValue().getString(), NutsOpenMode.OPEN_OR_ERROR);
                continue;
            }
            a = args.nextString(new String[]{"--app"});
            if (a != null) {
                app = this.loadApp(a.getValue().getString(), NutsOpenMode.OPEN_OR_ERROR);
                continue;
            }
            a = args.nextString(new String[]{"--version"});
            if (a != null) {
                version = a.getValue().getString();
                continue;
            }
            a = args.nextString(new String[]{"--file"});
            if (a != null) {
                file = a.getValue().getString();
                continue;
            }
            a = args.nextNonOption();
            if (a != null) {
                if (file == null) {
                    file = a.getString();
                    continue;
                }
                args.setCommandName("tomcat --local install").unexpectedArgument();
                continue;
            }
            this.context.configureLast(args);
        }
        if (app == null) {
            throw new NutsExecutionException(this.context.getSession(), NutsMessage.cstyle((String)"tomcat install: Missing Application", (Object[])new Object[0]), 2);
        }
        if (file == null) {
            throw new NutsExecutionException(this.context.getSession(), NutsMessage.cstyle((String)"tomcat install: Missing File", (Object[])new Object[0]), 2);
        }
        app.install(version, file, true);
    }

    public void delete(NutsCommandLine args) {
        if (args.hasNext()) {
            NutsArgument a = args.next(new String[]{"log"});
            if (a != null) {
                this.deleteLog(args);
            } else {
                a = args.next(new String[]{"temp"});
                if (a != null) {
                    this.deleteTemp(args);
                } else {
                    a = args.next(new String[]{"work"});
                    if (a != null) {
                        this.deleteWork(args);
                    } else {
                        args.setCommandName("tomcat --local delete").unexpectedArgument();
                    }
                }
            }
        } else {
            args.setCommandName("tomcat --local delete").required(NutsMessage.cstyle((String)"missing log|temp|work", (Object[])new Object[0]));
        }
    }

    private void deleteLog(NutsCommandLine args) {
        LocalTomcatConfigService c;
        LocalTomcatServiceBase s = null;
        boolean all = false;
        boolean processed = false;
        args.setCommandName("tomcat --local delete-log");
        while (args.hasNext()) {
            NutsArgument a = args.nextBoolean(new String[]{"-a", "--all"});
            if (a != null) {
                all = a.getBooleanValue();
                continue;
            }
            s = this.readBaseServiceArg(args, NutsOpenMode.OPEN_OR_ERROR);
            if (s != null) {
                c = this.toLocalTomcatConfigService(s);
                if (all) {
                    c.deleteAllLog();
                } else {
                    c.deleteOutLog();
                }
                processed = true;
                continue;
            }
            this.context.configureLast(args);
        }
        if (!processed) {
            c = this.openTomcatConfig("", NutsOpenMode.OPEN_OR_ERROR);
            if (all) {
                c.deleteAllLog();
            } else {
                c.deleteOutLog();
            }
        }
    }

    private void deleteTemp(NutsCommandLine args) {
        LocalTomcatConfigService c;
        LocalTomcatServiceBase s = null;
        boolean processed = false;
        args.setCommandName("tomcat --local delete-temp");
        while (args.hasNext()) {
            s = this.readBaseServiceArg(args, NutsOpenMode.OPEN_OR_ERROR);
            if (s != null) {
                c = this.toLocalTomcatConfigService(s);
                c.deleteTemp();
                processed = true;
                continue;
            }
            this.context.configureLast(args);
        }
        if (!processed) {
            c = this.openTomcatConfig("", NutsOpenMode.OPEN_OR_ERROR);
            c.deleteTemp();
        }
    }

    private void deleteWork(NutsCommandLine args) {
        LocalTomcatConfigService c;
        LocalTomcatServiceBase s = null;
        boolean processed = false;
        args.setCommandName("tomcat --local delete-work");
        while (args.hasNext()) {
            s = this.readBaseServiceArg(args, NutsOpenMode.OPEN_OR_ERROR);
            if (s != null) {
                c = this.toLocalTomcatConfigService(s);
                c.deleteWork();
                processed = true;
                continue;
            }
            this.context.configureLast(args);
        }
        if (!processed) {
            c = this.openTomcatConfig("", NutsOpenMode.OPEN_OR_ERROR);
            c.deleteWork();
        }
    }

    public void showCatalinaBase(NutsCommandLine args) {
        args.setCommandName("tomcat --local show-catalina-base");
        LocalTomcatConfigService s = this.nextLocalTomcatConfigService(args, NutsOpenMode.OPEN_OR_ERROR);
        while (args.hasNext()) {
            this.context.configureLast(args);
        }
        LocalTomcatConfigService c = this.toLocalTomcatConfigService(s);
        NutsObjectFormat.of((NutsSession)this.context.getSession()).setValue((Object)c.getCatalinaBase()).println();
    }

    public void showCatalinaVersion(NutsCommandLine args) {
        args.setCommandName("tomcat --local show-catalina-version");
        LocalTomcatConfigService s = this.nextLocalTomcatConfigService(args, NutsOpenMode.OPEN_OR_ERROR);
        while (args.hasNext()) {
            this.context.configureLast(args);
        }
        LocalTomcatConfigService c = this.toLocalTomcatConfigService(s);
        NutsObjectFormat.of((NutsSession)this.context.getSession()).setValue((Object)c.getValidCatalinaVersion()).println();
    }

    public void showCatalinaHome(NutsCommandLine args) {
        args.setCommandName("tomcat --local show-catalina-home");
        LocalTomcatConfigService s = this.nextLocalTomcatConfigService(args, NutsOpenMode.OPEN_OR_ERROR);
        while (args.hasNext()) {
            this.context.configureLast(args);
        }
        LocalTomcatConfigService c = this.toLocalTomcatConfigService(s);
        NutsObjectFormat.of((NutsSession)this.context.getSession()).setValue((Object)c.getCatalinaHome()).println();
    }

    public void showPort(NutsCommandLine args) {
        int port;
        args.setCommandName("tomcat --local port");
        LocalTomcatConfigService c = this.nextLocalTomcatConfigService(args, NutsOpenMode.OPEN_OR_ERROR);
        boolean redirect = false;
        boolean setValue = false;
        String type = "http";
        int newValue = -1;
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        while (args.hasNext()) {
            NutsArgument a = args.nextBoolean(new String[]{"--redirect"});
            if (a != null) {
                redirect = a.getBooleanValue();
                continue;
            }
            a = args.nextBoolean(new String[]{"--shutdown"});
            if (a != null) {
                type = "shutdown";
                continue;
            }
            a = args.nextBoolean(new String[]{"--ajp"});
            if (a != null) {
                type = "ajp";
                continue;
            }
            a = args.nextString(new String[]{"--set"});
            if (a != null) {
                newValue = a.getValue().getInt();
                setValue = true;
                continue;
            }
            a = args.nextString(new String[]{"--set-port"});
            if (a != null) {
                port = a.getValue().getInt();
                runnables.add(() -> c.setHttpConnectorPort(false, port));
                continue;
            }
            a = args.nextString(new String[]{"--set-redirect-port"});
            if (a != null) {
                port = a.getValue().getInt();
                runnables.add(() -> c.setHttpConnectorPort(true, port));
                continue;
            }
            a = args.nextString(new String[]{"--set-shutdown-port"});
            if (a != null) {
                port = a.getValue().getInt();
                runnables.add(() -> c.setShutdownPort(port));
                continue;
            }
            a = args.nextString(new String[]{"--set-ajp-port"});
            if (a != null) {
                port = a.getValue().getInt();
                runnables.add(() -> c.setAjpConnectorPort(false, port));
                continue;
            }
            a = args.nextString(new String[]{"--set-redirect-ajp-port"});
            if (a != null) {
                port = a.getValue().getInt();
                runnables.add(() -> c.setAjpConnectorPort(true, port));
                continue;
            }
            this.context.configureLast(args);
        }
        if (setValue) {
            runnables.forEach(Runnable::run);
            port = newValue;
            switch (type) {
                case "shutdown": {
                    c.setShutdownPort(port);
                    break;
                }
                case "ajp": {
                    c.setAjpConnectorPort(redirect, port);
                    break;
                }
                case "http": {
                    c.setHttpConnectorPort(redirect, port);
                }
            }
        } else if (runnables.size() > 0) {
            runnables.forEach(Runnable::run);
        } else {
            port = 8080;
            switch (type) {
                case "shutdown": {
                    port = c.getShutdownPort();
                    break;
                }
                case "ajp": {
                    port = c.getAjpConnectorPort(redirect);
                    break;
                }
                case "http": {
                    port = c.getHttpConnectorPort(redirect);
                }
            }
            NutsObjectFormat.of((NutsSession)this.context.getSession()).setValue((Object)port).println();
        }
    }

    public void showLog(NutsCommandLine commandLine) {
        LocalTomcatServiceBase s = this.nextLocalTomcatServiceBase(commandLine, NutsOpenMode.OPEN_OR_ERROR);
        boolean path = false;
        int count = -1;
        commandLine.setCommandName("tomcat --local log");
        while (commandLine.hasNext()) {
            NutsArgument a = commandLine.nextString(new String[]{"--path"});
            if (a != null) {
                path = true;
                continue;
            }
            if (commandLine.peek().isOption() && TomcatUtils.isPositiveInt(commandLine.peek().getString().substring(1))) {
                count = Integer.parseInt(commandLine.next().getString().substring(1));
                continue;
            }
            this.context.configureLast(commandLine);
        }
        LocalTomcatConfigService c = this.toLocalTomcatConfigService(s);
        if (path) {
            this.getContext().getSession().out().printf("%s\n", new Object[]{c.getOutLogFile()});
        } else {
            c.showOutLog(count);
        }
    }

    public void deployFile(NutsCommandLine args) {
        String instance = null;
        Object version = null;
        String file = null;
        Object app = null;
        String domain = null;
        String contextName = null;
        args.setCommandName("tomcat --local deploy-file");
        while (args.hasNext()) {
            NutsArgument a = args.nextString(new String[]{"--file"});
            if (a != null) {
                file = a.getValue().getString();
                continue;
            }
            a = args.nextString(new String[]{"--name"});
            if (a != null) {
                instance = a.getValue().getString();
                continue;
            }
            a = args.nextString(new String[]{"--context"});
            if (a != null) {
                contextName = a.getValue().getString();
                continue;
            }
            a = args.nextString(new String[]{"--domain"});
            if (a != null) {
                domain = a.getValue().getString();
                continue;
            }
            a = args.nextNonOption();
            if (a != null) {
                if (file == null) {
                    file = a.getString();
                    continue;
                }
                args.setCommandName("tomcat --local deploy-file").unexpectedArgument();
                continue;
            }
            this.context.configureLast(args);
        }
        if (file == null) {
            throw new NutsExecutionException(this.context.getSession(), NutsMessage.cstyle((String)"tomcat deploy: Missing File", (Object[])new Object[0]), 2);
        }
        LocalTomcatConfigService c = this.openTomcatConfig(instance, NutsOpenMode.OPEN_OR_ERROR);
        c.deployFile(NutsPath.of(file, (NutsSession)this.getContext().getSession()), contextName, domain);
    }

    public void deployApp(NutsCommandLine args) {
        String version = null;
        String app = null;
        args.setCommandName("tomcat --local deploy");
        while (args.hasNext()) {
            NutsArgument a = args.nextString(new String[]{"--version"});
            if (a != null) {
                version = a.getValue().getString();
                continue;
            }
            a = args.nextString(new String[]{"--app"});
            if (a != null) {
                app = a.getValue().getString();
                continue;
            }
            a = args.nextNonOption();
            if (a != null) {
                if (app == null) {
                    app = a.getString();
                    continue;
                }
                args.setCommandName("tomcat --local deploy").unexpectedArgument();
                continue;
            }
            this.context.configureLast(args);
        }
        this.loadApp(app, NutsOpenMode.OPEN_OR_ERROR).deploy(version);
    }

    public void restart(NutsCommandLine args, boolean shutdown) {
        LocalTomcatConfigService c;
        boolean deleteLog = false;
        String instance = null;
        LocalTomcatConfigService[] srvRef = new LocalTomcatConfigService[1];
        ArrayList<String> apps = new ArrayList<String>();
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        args.setCommandName("tomcat restart");
        while (args.hasNext()) {
            int port;
            NutsArgument a = null;
            a = args.nextBoolean(new String[]{"--delete-out-log"});
            if (a != null) {
                deleteLog = a.getBooleanValue();
                continue;
            }
            a = args.nextString(new String[]{"--deploy"});
            if (a != null) {
                apps.add(a.getValue().getString());
                continue;
            }
            a = args.nextString(new String[]{"--port"});
            if (a != null) {
                port = a.getValue().getInt();
                runnables.add(() -> srvRef[0].setHttpConnectorPort(false, port));
                continue;
            }
            a = args.nextString(new String[]{"--http-port"});
            if (a != null) {
                port = a.getValue().getInt();
                runnables.add(() -> srvRef[0].setHttpConnectorPort(false, port));
                continue;
            }
            a = args.nextString(new String[]{"--redirect-port"});
            if (a != null) {
                port = a.getValue().getInt();
                runnables.add(() -> srvRef[0].setHttpConnectorPort(true, port));
                continue;
            }
            a = args.nextString(new String[]{"--shutdown-port"});
            if (a != null) {
                port = a.getValue().getInt();
                runnables.add(() -> srvRef[0].setShutdownPort(port));
                continue;
            }
            a = args.nextString(new String[]{"--ajp-port"});
            if (a != null) {
                port = a.getValue().getInt();
                runnables.add(() -> srvRef[0].setAjpConnectorPort(false, port));
                continue;
            }
            a = args.nextString(new String[]{"--redirect-ajp-port"});
            if (a != null) {
                port = a.getValue().getInt();
                runnables.add(() -> srvRef[0].setAjpConnectorPort(true, port));
                continue;
            }
            a = args.nextNonOption();
            if (a != null) {
                if (instance == null) {
                    instance = a.getString();
                    continue;
                }
                args.setCommandName("tomcat --local restart").unexpectedArgument();
                continue;
            }
            this.context.configureLast(args);
        }
        if (instance == null) {
            instance = "";
        }
        srvRef[0] = c = this.openTomcatConfig(instance, NutsOpenMode.OPEN_OR_CREATE);
        c.buildCatalinaBase();
        runnables.forEach(Runnable::run);
        if (shutdown) {
            c.restart(apps.toArray(new String[0]), deleteLog);
        } else {
            c.start(apps.toArray(new String[0]), deleteLog);
        }
    }

    public void reset() {
        for (LocalTomcatConfigService tomcatConfig : this.listConfig()) {
            tomcatConfig.remove();
        }
    }

    public LocalTomcatConfigService[] listConfig() {
        return (LocalTomcatConfigService[])this.sharedConfigFolder.list().filter(pathname -> pathname.isRegularFile() && pathname.getName().toString().endsWith(".local-config"), "isRegularFile() && matches(*.local-config)").mapUnsafe(NutsUnsafeFunction.of(x -> this.openTomcatConfig((NutsPath)x, NutsOpenMode.OPEN_OR_ERROR), (String)"openTomcatConfig"), null).filterNonNull().toArray(LocalTomcatConfigService[]::new);
    }

    public LocalTomcatConfigService openTomcatConfig(String name, NutsOpenMode autoCreate) {
        LocalTomcatConfigService t = new LocalTomcatConfigService(name, this);
        if (autoCreate == null) {
            if (!t.existsConfig()) {
                return null;
            }
            autoCreate = NutsOpenMode.OPEN_OR_ERROR;
        }
        t.open(autoCreate);
        return t;
    }

    public LocalTomcatConfigService openTomcatConfig(NutsPath file, NutsOpenMode autoCreate) {
        LocalTomcatConfigService t = new LocalTomcatConfigService(file, this);
        if (autoCreate == null) {
            if (!t.existsConfig()) {
                return null;
            }
            autoCreate = NutsOpenMode.OPEN_OR_ERROR;
        }
        t.open(autoCreate);
        return t;
    }

    public LocalTomcatServiceBase loadServiceBase(String name, NutsOpenMode autoCreate) {
        String[] strings;
        if (".".equals(name)) {
            name = "";
        }
        if ((strings = TomcatUtils.splitInstanceAppPreferInstance(name))[1].isEmpty()) {
            return this.openTomcatConfig(strings[0], autoCreate);
        }
        LocalTomcatConfigService u = this.openTomcatConfig(strings[0], autoCreate);
        LocalTomcatDomainConfigService d = u.getDomain(strings[1], null);
        LocalTomcatAppConfigService a = u.getApp(strings[1], null);
        if (d != null && a != null) {
            throw new NutsExecutionException(this.context.getSession(), NutsMessage.cstyle((String)"ambiguous name %s. Could be either domain or app", (Object[])new Object[]{name}), 3);
        }
        if (d == null && a == null) {
            throw new NutsExecutionException(this.context.getSession(), NutsMessage.cstyle((String)"unknown name %s. it is no domain nor app", (Object[])new Object[]{name}), 3);
        }
        if (d != null) {
            return d;
        }
        return a;
    }

    public LocalTomcatAppConfigService loadApp(String name, NutsOpenMode autoCreate) {
        String[] strings = TomcatUtils.splitInstanceAppPreferApp(name);
        return this.openTomcatConfig(strings[0], autoCreate).getApp(strings[1], NutsOpenMode.OPEN_OR_ERROR);
    }

    public LocalTomcatDomainConfigService loadDomain(String name, NutsOpenMode autoCreate) {
        String[] strings = TomcatUtils.splitInstanceAppPreferApp(name);
        return this.openTomcatConfig(strings[0], autoCreate).getDomain(strings[1], NutsOpenMode.OPEN_OR_ERROR);
    }

    public NutsApplicationContext getContext() {
        return this.context;
    }

    public void setContext(NutsApplicationContext context) {
        this.context = context;
    }

    public LocalTomcatConfigService toLocalTomcatConfigService(LocalTomcatServiceBase s) {
        if (s instanceof LocalTomcatAppConfigService) {
            s = ((LocalTomcatAppConfigService)s).getTomcat();
        } else if (s instanceof LocalTomcatDomainConfigService) {
            s = ((LocalTomcatDomainConfigService)s).getTomcat();
        }
        return (LocalTomcatConfigService)s;
    }

    public LocalTomcatServiceBase nextLocalTomcatServiceBase(NutsCommandLine args, NutsOpenMode autoCreate) {
        NutsArgument o;
        if (args.hasNext() && (o = args.nextNonOption()) != null) {
            return this.loadServiceBase(o.toString(), autoCreate);
        }
        return this.loadServiceBase("", autoCreate);
    }

    public LocalTomcatConfigService nextLocalTomcatConfigService(NutsCommandLine args, NutsOpenMode autoCreate) {
        NutsArgument o;
        if (args.hasNext() && (o = args.nextNonOption()) != null) {
            return this.openTomcatConfig(o.toString(), autoCreate);
        }
        return this.openTomcatConfig("", autoCreate);
    }

    public LocalTomcatDomainConfigService nextLocalTomcatDomainConfigService(NutsCommandLine args, NutsOpenMode autoCreate) {
        NutsArgument o;
        if (args.hasNext() && (o = args.nextNonOption()) != null) {
            String[] p = TomcatUtils.splitInstanceAppPreferApp(o.toString());
            return this.openTomcatConfig(p[0], NutsOpenMode.OPEN_OR_ERROR).getDomain(p[1], autoCreate);
        }
        return this.openTomcatConfig("", NutsOpenMode.OPEN_OR_ERROR).getDomain("", autoCreate);
    }

    public LocalTomcatAppConfigService nextLocalTomcatAppConfigService(NutsCommandLine args, NutsOpenMode autoCreate) {
        NutsArgument o;
        if (args.hasNext() && (o = args.nextNonOption()) != null) {
            String[] p = TomcatUtils.splitInstanceAppPreferApp(o.toString());
            return this.openTomcatConfig(p[0], NutsOpenMode.OPEN_OR_ERROR).getApp(p[1], autoCreate);
        }
        return this.openTomcatConfig("", NutsOpenMode.OPEN_OR_ERROR).getApp("", autoCreate);
    }

    public LocalTomcatConfigService readTomcatServiceArg(NutsCommandLine args, NutsOpenMode autoCreate) {
        LocalTomcatServiceBase s = this.readBaseServiceArg(args, autoCreate);
        return this.toLocalTomcatConfigService(s);
    }

    public LocalTomcatServiceBase readBaseServiceArg(NutsCommandLine args, NutsOpenMode autoCreate) {
        NutsArgument a = args.nextString(new String[]{"--name"});
        if (a != null) {
            return this.loadServiceBase(a.getValue().getString(), autoCreate);
        }
        a = args.nextString(new String[]{"--app"});
        if (a != null) {
            return this.loadApp(a.getValue().getString(), autoCreate);
        }
        a = args.nextString(new String[]{"--domain"});
        if (a != null) {
            return this.loadDomain(a.getValue().getString(), autoCreate);
        }
        if (args.hasNext() && args.peek().isOption() && args.peek().toElement().isDouble()) {
            return null;
        }
        if (args.hasNext() && args.peek().isOption()) {
            return null;
        }
        if (args.hasNext()) {
            return this.loadServiceBase(args.next().getString(), autoCreate);
        }
        return null;
    }
}

