/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntomcat;

import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsApplication;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryModel;
import net.thevpc.nuts.toolbox.ntomcat.local.LocalTomcat;
import net.thevpc.nuts.toolbox.ntomcat.remote.RemoteTomcat;
import net.thevpc.nuts.toolbox.ntomcat.util.ApacheTomcatRepositoryModel;

public class NTomcatMain
implements NutsApplication {
    public static void main(String[] args) {
        new NTomcatMain().runAndExit(args);
    }

    public void run(NutsApplicationContext appContext) {
        Object m;
        NutsRepository apacheRepo = appContext.getSession().repos().findRepository("apache-tomcat");
        if (apacheRepo == null) {
            appContext.getSession().repos().addRepository(new NutsAddRepositoryOptions().setRepositoryModel((NutsRepositoryModel)new ApacheTomcatRepositoryModel()).setTemporary(true));
        }
        NutsCommandLine cmdLine = appContext.getCommandLine();
        Boolean local = null;
        boolean skipFirst = false;
        if (cmdLine.hasNext()) {
            NutsArgument a = cmdLine.peek();
            if (a.getString().equals("--remote") || a.getString().equals("-r")) {
                cmdLine.skip();
                local = false;
            } else if (a.getString().equals("--local") || a.getString().equals("-l")) {
                cmdLine.skip();
                local = true;
            }
        }
        if (local == null) {
            local = true;
        }
        if (local.booleanValue()) {
            m = new LocalTomcat(appContext, cmdLine);
            ((LocalTomcat)m).runArgs();
            appContext.getSession().flush();
        } else {
            m = new RemoteTomcat(appContext, cmdLine);
            ((RemoteTomcat)m).runArgs();
            appContext.getSession().flush();
        }
    }
}

