/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntemplate.filetemplate.processors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.FileTemplater;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.StreamProcessor;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.util.FileProcessorUtils;

public class DollarVarStreamProcessor
implements StreamProcessor {
    public static final DollarVarStreamProcessor INSTANCE = new DollarVarStreamProcessor();

    @Override
    public void processStream(InputStream source, OutputStream target, FileTemplater context) {
        try {
            OutputStreamWriter out = new OutputStreamWriter(target);
            char[] charArray = FileProcessorUtils.loadString(source, null).toCharArray();
            boolean dollarAtLineStart = false;
            int brackets = 0;
            int charArrayLength = charArray.length;
            block12: for (int i = 0; i < charArrayLength; ++i) {
                char c = charArray[i];
                switch (c) {
                    case '\\': {
                        if (i + 1 < charArray.length && charArray[i + 1] == '$') {
                            out.append('$');
                            ++i;
                            continue block12;
                        }
                        out.append(c);
                        continue block12;
                    }
                    case '$': {
                        if (i + 1 < charArray.length && charArray[i + 1] == '{') {
                            dollarAtLineStart = i == 0 || charArray[i - 1] == '\n';
                            StringBuilder sb2 = new StringBuilder();
                            StringBuilder sb20 = new StringBuilder();
                            sb20.append("${");
                            int offset = i += 2;
                            boolean end = false;
                            block13: while (!end && i < charArrayLength) {
                                c = charArray[i];
                                switch (c) {
                                    case '/': {
                                        if (i + 1 < charArray.length && charArray[i + 1] == '/') {
                                            c = charArray[i];
                                            sb2.append(c);
                                            sb2.append(charArray[++i]);
                                            while (i < charArray.length && charArray[i] != '\n') {
                                                sb2.append(charArray[i]);
                                                ++i;
                                            }
                                            continue block13;
                                        }
                                        sb2.append(c);
                                        continue block13;
                                    }
                                    case '\"': 
                                    case '\'': 
                                    case '`': {
                                        char s = c;
                                        sb2.append(c);
                                        ++i;
                                        while (i < charArray.length) {
                                            c = charArray[i];
                                            if (c == s) {
                                                sb2.append(c);
                                                ++i;
                                                continue block13;
                                            }
                                            if (c == '\\') {
                                                sb2.append(c);
                                                if (++i < charArray.length) {
                                                    c = charArray[i];
                                                    sb2.append(c);
                                                }
                                            } else {
                                                sb2.append(c);
                                            }
                                            ++i;
                                        }
                                        continue block13;
                                    }
                                    case '{': {
                                        sb2.append(c);
                                        ++brackets;
                                        continue block13;
                                    }
                                    case '}': {
                                        if (--brackets <= 0) {
                                            if (dollarAtLineStart && i + 2 < charArray.length && charArray[i + 1] == '\r' && charArray[i + 2] == '\n') {
                                                sb20.append("}\r\n");
                                                i += 2;
                                            } else if (dollarAtLineStart && i + 1 < charArray.length && charArray[i + 1] == '\n') {
                                                sb20.append("}\n");
                                                ++i;
                                            } else {
                                                sb20.append("}");
                                            }
                                            end = true;
                                            continue block13;
                                        }
                                        sb2.append(c);
                                        continue block13;
                                    }
                                }
                                sb2.append(c);
                                sb20.append(c);
                                ++i;
                            }
                            String v = this.evaluateDollarValue(sb2.toString(), context);
                            ((Writer)out).append(String.valueOf(v));
                            continue block12;
                        }
                        out.append(c);
                        continue block12;
                    }
                    default: {
                        out.append(c);
                    }
                }
            }
            ((Writer)out).flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    protected String evaluateDollarValue(String str, FileTemplater context) {
        return context.executeStream(new ByteArrayInputStream(str.getBytes()), "text/ftex");
    }

    public String toString() {
        return "Replace(${})";
    }
}

