/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.ExprEvaluator;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.FileTemplater;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval.AbstractExprEvalEct;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval.ExprEvalFct;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval.ExprNode;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval.ExprNodeFunction;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval.ExprNodeLiteral;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval.ExprNodeParser;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval.ExprNodeVar;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.util.FileProcessorUtils;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.util.StringUtils;

public class FtexEvaluator
implements ExprEvaluator {
    private Map<String, ExprEvalFct> functions = new HashMap<String, ExprEvalFct>();

    public FtexEvaluator() {
        this.addFunction(new AbstractExprEvalEct(";"){

            @Override
            public Object evalFunction(ExprNode[] args, FileTemplater context) {
                Object a = "";
                for (ExprNode arg : args) {
                    a = FtexEvaluator.this.evalNode(arg, context);
                }
                return a;
            }
        });
        this.addFunction(new AbstractExprEvalEct("get"){

            @Override
            public Object evalFunction(ExprNode[] args, FileTemplater context) {
                if (args.length != 1) {
                    throw new IllegalStateException(this.getName() + " : invalid arguments count");
                }
                String varName = String.valueOf(FtexEvaluator.this.evalNode(args[0], context));
                return context.getVarRequired(varName);
            }
        });
        this.addFunction(new AbstractExprEvalEct("set"){

            @Override
            public Object evalFunction(ExprNode[] args, FileTemplater context) {
                if (args.length != 2) {
                    throw new IllegalStateException(this.getName() + " : invalid arguments count");
                }
                String varName = String.valueOf(FtexEvaluator.this.evalNode(args[0], context));
                Object newValue = FtexEvaluator.this.evalNode(args[1], context);
                context.getLog().debug("eval", varName + "=" + StringUtils.toLiteralString(newValue));
                context.setVar(varName, newValue);
                return "";
            }
        });
        this.addFunction(new AbstractExprEvalEct("exec"){

            @Override
            public Object evalFunction(ExprNode[] args, FileTemplater context) {
                if (args.length != 1) {
                    throw new IllegalStateException(this.getName() + " : invalid arguments count");
                }
                String pathString = (String)FtexEvaluator.this.evalNode(args[0], context);
                context.getLog().debug("eval", this.getName() + "(" + StringUtils.toLiteralString(pathString) + ")");
                return context.executeRegularFile(Paths.get(pathString, new String[0]), null);
            }
        });
        this.addFunction(new AbstractExprEvalEct("println"){

            @Override
            public Object evalFunction(ExprNode[] args, FileTemplater context) {
                ArrayList<String> all = new ArrayList<String>();
                for (ExprNode arg : args) {
                    all.add(String.valueOf(FtexEvaluator.this.evalNode(arg, context)));
                }
                StringBuilder sb = new StringBuilder();
                if (!all.isEmpty()) {
                    if (all.size() == 1) {
                        sb.append((String)all.get(0)).append("\n");
                    } else {
                        sb.append(String.join((CharSequence)", ", all)).append("\n");
                    }
                }
                context.getLog().debug("eval", this.getName() + "(" + StringUtils.toLiteralString(sb.toString()) + ")");
                return sb.toString();
            }
        });
        this.addFunction(new AbstractExprEvalEct("print"){

            @Override
            public Object evalFunction(ExprNode[] args, FileTemplater context) {
                ArrayList<String> all = new ArrayList<String>();
                for (ExprNode arg : args) {
                    all.add(String.valueOf(FtexEvaluator.this.evalNode(arg, context)));
                }
                StringBuilder sb = new StringBuilder();
                if (!all.isEmpty()) {
                    if (all.size() == 1) {
                        sb.append((String)all.get(0));
                    } else {
                        sb.append(String.join((CharSequence)", ", all));
                    }
                }
                context.getLog().debug("eval", this.getName() + "(" + StringUtils.toLiteralString(sb.toString()) + ")");
                return sb.toString();
            }
        });
        this.addFunction(new AbstractExprEvalEct("string"){

            @Override
            public Object evalFunction(ExprNode[] args, FileTemplater context) {
                if (args.length != 1) {
                    throw new IllegalStateException(this.getName() + " : invalid arguments count");
                }
                String str = (String)FtexEvaluator.this.evalNode(args[0], context);
                context.getLog().debug("eval", this.getName() + "(" + StringUtils.toLiteralString(str) + ")");
                return "\"" + StringUtils.escapeString(str) + "\"";
            }
        });
        this.addFunction(new AbstractExprEvalEct("processFile"){

            @Override
            public Object evalFunction(ExprNode[] args, FileTemplater context) {
                if (args.length != 1) {
                    throw new IllegalStateException(this.getName() + " : invalid arguments count");
                }
                String str = (String)FtexEvaluator.this.evalNode(args[0], context);
                String path = FileProcessorUtils.toAbsolute(str, context.getWorkingDirRequired());
                Path opath = Paths.get(path, new String[0]);
                context.getLog().debug("eval", this.getName() + "(" + StringUtils.toLiteralString(opath) + ")");
                context.processRegularFile(opath, null);
                return "";
            }
        });
        this.addFunction(new AbstractExprEvalEct("loadFile"){

            @Override
            public Object evalFunction(ExprNode[] args, FileTemplater context) {
                if (args.length != 1) {
                    throw new IllegalStateException(this.getName() + " : invalid arguments count");
                }
                String str = (String)FtexEvaluator.this.evalNode(args[0], context);
                context.getLog().debug("eval", this.getName() + "(" + StringUtils.toLiteralString(str) + ")");
                return FileProcessorUtils.loadString(Paths.get(FileProcessorUtils.toAbsolute(str, context.getWorkingDirRequired()), new String[0]));
            }
        });
        this.addFunction(new AbstractExprEvalEct("include"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Object evalFunction(ExprNode[] args, FileTemplater context) {
                if (args.length != 1) {
                    throw new IllegalStateException(this.getName() + " : invalid arguments count");
                }
                String str = (String)FtexEvaluator.this.evalNode(args[0], context);
                String path = FileProcessorUtils.toAbsolute(str, context.getWorkingDirRequired());
                Path opath = Paths.get(path, new String[0]);
                context.getLog().debug("eval", this.getName() + "(" + StringUtils.toLiteralString(opath) + ")");
                try (InputStream in = Files.newInputStream(opath, new OpenOption[0]);){
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    context.processStream(in, out, context.getMimeTypeResolver().resolveMimetype(opath.toString()));
                    String string = out.toString();
                    return string;
                }
                catch (IOException io) {
                    throw new UncheckedIOException(io);
                }
            }
        });
    }

    @Override
    public Object eval(String content, FileTemplater context) {
        ExprNode p = new ExprNodeParser(content = content.trim(), context).parseDocument();
        if (p != null) {
            return String.valueOf(this.evalNode(p, context));
        }
        return "";
    }

    protected Object evalFunction(String functionName, ExprNode[] args, FileTemplater context) {
        return this.getFunction(functionName).evalFunction(args, context);
    }

    public Object evalNode(ExprNode node, FileTemplater context) {
        switch (node.getClass().getSimpleName()) {
            case "ExprNodeLiteral": {
                ExprNodeLiteral n = (ExprNodeLiteral)node;
                switch (n.getType()) {
                    case "\"": {
                        return this.evalDoubleQuotesString((String)n.getValue(), context);
                    }
                    case "'": {
                        return this.evalSimpleQuotesString((String)n.getValue(), context);
                    }
                    case "`": {
                        return this.evalAntiQuotesString((String)n.getValue(), context);
                    }
                    case "$\"": {
                        return this.evalDoubleQuotesStringInterp((String)n.getValue(), context);
                    }
                    case "number": {
                        return this.evalDouble((Double)n.getValue(), context);
                    }
                }
                throw new IllegalArgumentException("Unsupported " + n.getType());
            }
            case "ExprNodeVar": {
                return this.getFunction("get").evalFunction(new ExprNode[]{new ExprNodeLiteral("\"", ((ExprNodeVar)node).getName())}, context);
            }
            case "ExprNodeFunction": {
                ExprNodeFunction f = (ExprNodeFunction)node;
                String functionName = f.getName();
                ExprNode[] args = f.getArgs();
                return this.evalFunction(functionName, args, context);
            }
        }
        throw new IllegalStateException("Invalid statement " + node);
    }

    public String toString() {
        return "Ftex";
    }

    private Object evalDouble(Double value, FileTemplater ctx) {
        return value;
    }

    private Object evalAntiQuotesString(String value, FileTemplater ctx) {
        NutsSession ws = ctx.getSession();
        return ws.exec().addCommand(NutsCommandLine.of((String)value, (NutsSession)ws).toStringArray()).setDirectory(ctx.getWorkingDirRequired()).grabOutputString().run().getOutputString();
    }

    private Object evalSimpleQuotesString(String value, FileTemplater ctx) {
        return value;
    }

    private Object evalDoubleQuotesString(String value, FileTemplater ctx) {
        return value;
    }

    private Object evalDoubleQuotesStringInterp(String value, FileTemplater context) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        context.newChild().processStream(new ByteArrayInputStream(value.getBytes()), baos, "application/x-file-placeholder-dollars");
        return baos.toString();
    }

    public FtexEvaluator removeFunction(String name) {
        this.functions.remove(name);
        return this;
    }

    public final FtexEvaluator addFunction(ExprEvalFct fct) {
        this.functions.put(fct.getName(), fct);
        return this;
    }

    public ExprEvalFct findFunction(String name) {
        return this.functions.get(name);
    }

    public ExprEvalFct getFunction(String name) {
        ExprEvalFct f = this.functions.get(name);
        if (f == null) {
            throw new NoSuchElementException("function not found " + name);
        }
        return f;
    }
}

