/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.FileTemplater;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval.ExprNode;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval.ExprNodeFunction;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval.ExprNodeLiteral;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval.ExprNodeVar;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval.ExprToken;

public class ExprNodeParser {
    public static final int STR_INTERP = -100;
    StreamTokenizer st;
    FileTemplater context;
    private List<ExprToken> tokens = new ArrayList<ExprToken>();

    public ExprNodeParser(String r, FileTemplater context) {
        this(new StringReader(r), context);
    }

    public ExprNodeParser(Reader r, FileTemplater context) {
        this.st = new StreamTokenizer(r);
        this.st.ordinaryChar(10);
        this.st.quoteChar(96);
        this.st.commentChar(35);
        this.context = context;
    }

    public FileTemplater getContext() {
        return this.context;
    }

    private ExprNode parseExpression() {
        ExprToken w = this.nextToken();
        if (w == null) {
            this.context.getLog().error("set statement", "missing expression");
            return null;
        }
        switch (w.ttype) {
            case -3: {
                ExprToken t = this.nextToken();
                if (t != null && t.ttype == 40) {
                    String fctName = (String)w.value;
                    ArrayList<ExprNode> args = new ArrayList<ExprNode>();
                    ExprNode arg0 = this.parseExpression();
                    if (arg0 == null) {
                        return null;
                    }
                    args.add(arg0);
                    while (true) {
                        ExprToken nt;
                        if ((nt = this.peekToken()) == null) {
                            this.context.getLog().error("function", "missing argument for " + fctName + "(" + args.stream().map(x -> x.toString()).collect(Collectors.joining(",")) + ")");
                            this.nextToken();
                            continue;
                        }
                        if (nt.ttype == 44) {
                            this.nextToken();
                            arg0 = this.parseExpression();
                            if (arg0 == null) {
                                return null;
                            }
                            args.add(arg0);
                            continue;
                        }
                        if (nt.ttype == 41) break;
                        this.context.getLog().error("function", "missing ',' or ')'");
                    }
                    this.nextToken();
                    return new ExprNodeFunction(fctName, args.toArray(new ExprNode[0]));
                }
                if (t != null && t.ttype == 61) {
                    String varName = (String)w.value;
                    ExprNode arg0 = this.parseExpression();
                    if (arg0 == null) {
                        return null;
                    }
                    return new ExprNodeFunction("set", new ExprNode[]{new ExprNodeLiteral("\"", varName), arg0});
                }
                this.pushBack(t);
                return new ExprNodeVar((String)w.value);
            }
            case -2: {
                return new ExprNodeLiteral("number", w.value);
            }
            case 34: 
            case 39: 
            case 96: {
                return new ExprNodeLiteral(String.valueOf((char)w.ttype), w.value);
            }
            case -100: {
                return new ExprNodeLiteral("$\"", w.value);
            }
        }
        this.context.getLog().error("expression", "invalid token " + w);
        return null;
    }

    private boolean parseColonOrNewLine(boolean required) {
        ExprToken w = this.nextToken();
        if (w != null && (w.ttype == 59 || w.ttype == 10)) {
            while ((w = this.peekToken()) != null && (w.ttype == 59 || w.ttype == 10)) {
                this.nextToken();
            }
            return true;
        }
        if (required) {
            this.context.getLog().error("expression", "expected ';' or new line, encountered '" + w + "'");
        }
        if (w != null) {
            this.pushBack(w);
        }
        return false;
    }

    private String parseWord() {
        ExprToken w = this.nextToken();
        if (w != null && w.ttype == -3) {
            return (String)w.value;
        }
        this.context.getLog().error("set statement", "missing word");
        this.readUntilNextStatement();
        return null;
    }

    private boolean moreTokens() {
        return this.peekToken() != null;
    }

    public ExprNode parseDocument() {
        if (this.moreTokens()) {
            this.parseColonOrNewLine(false);
            ArrayList<ExprNode> exprs = new ArrayList<ExprNode>();
            ExprNode e = this.parseExpression();
            if (e == null) {
                return null;
            }
            exprs.add(e);
            while (this.moreTokens()) {
                if (!this.parseColonOrNewLine(true)) {
                    return null;
                }
                if (!this.moreTokens()) break;
                e = this.parseExpression();
                if (e == null) {
                    return null;
                }
                exprs.add(e);
            }
            return new ExprNodeFunction(";", exprs.toArray(new ExprNode[0]));
        }
        return new ExprNodeFunction(";", new ExprNode[0]);
    }

    private void readUntilNextStatement() {
        int t;
        do {
            t = 0;
            try {
                t = this.st.nextToken();
            }
            catch (IOException e) {
                return;
            }
        } while (t != 59);
    }

    private void pushBack(ExprToken st) {
        if (st != null) {
            this.tokens.add(0, st);
        }
    }

    private ExprToken peekToken() {
        if (!this.tokens.isEmpty()) {
            return this.tokens.get(0);
        }
        ExprToken t = this.nextToken();
        if (t != null) {
            this.pushBack(t);
        }
        return t;
    }

    private ExprToken nextToken() {
        if (!this.tokens.isEmpty()) {
            return this.tokens.remove(0);
        }
        int ttype = -1;
        int t = 0;
        try {
            t = this.st.nextToken();
        }
        catch (IOException e) {
            return null;
        }
        switch (t) {
            case -1: {
                return null;
            }
            case -2: {
                return new ExprToken(t, this.st.nval);
            }
            case -3: 
            case 34: 
            case 39: 
            case 96: {
                return new ExprToken(t, this.st.sval);
            }
            case 36: {
                ExprToken old = new ExprToken(t, String.valueOf((char)t));
                ExprToken nt = this.nextToken();
                if (nt == null) {
                    return old;
                }
                if (nt.ttype == 34) {
                    return new ExprToken(-100, this.st.sval);
                }
                this.pushBack(nt);
                return old;
            }
        }
        return new ExprToken(t, String.valueOf((char)t));
    }
}

