/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntemplate.filetemplate;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.FileTemplater;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.util.StringUtils;

public class ProcessCmd
extends SimpleJShellBuiltin {
    private final FileTemplater fileTemplater;

    public ProcessCmd(FileTemplater fileTemplater) {
        super("process", 10, Options.class);
        this.fileTemplater = fileTemplater;
    }

    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options o = (Options)context.getOptions();
        if (commandLine.isNonOption(0)) {
            o.args.add(commandLine.next().getString());
            while (commandLine.hasNext()) {
                o.args.add(commandLine.next().getString());
            }
            return true;
        }
        return false;
    }

    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options o = (Options)context.getOptions();
        if (o.args.size() == 0) {
            throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"%s : invalid arguments count", (Object[])new Object[]{this.getName()}), 1);
        }
        for (String pathString : o.args) {
            this.fileTemplater.getLog().debug("eval", this.getName() + "(" + StringUtils.toLiteralString(pathString) + ")");
            this.fileTemplater.executeRegularFile(Paths.get(pathString, new String[0]), null);
        }
    }

    private static class Options {
        List<String> args = new ArrayList<String>();

        private Options() {
        }
    }
}

