/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntemplate;

import java.nio.file.Path;
import net.thevpc.nuts.NutsAppCmdProcessor;
import net.thevpc.nuts.NutsApplication;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.toolbox.nsh.jshell.JShell;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellVar;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellVarListener;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellVariables;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.ExprEvaluator;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.FileTemplater;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.ProcessCmd;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.TemplateConfig;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.util.StringUtils;

public class NTemplateMain
implements NutsApplication,
NutsAppCmdProcessor {
    TemplateConfig config = new TemplateConfig();
    private FileTemplater fileTemplater;

    public static void main(String[] args) {
        NutsApplication.main(NTemplateMain.class, (String[])args);
    }

    public void run(NutsApplicationContext appContext) {
        appContext.processCommandLine((NutsAppCmdProcessor)this);
    }

    public boolean onCmdNextOption(NutsArgument option, NutsCommandLine commandline, NutsApplicationContext context) {
        switch (option.getKey().getString()) {
            case "-i": 
            case "--init": {
                this.config.addInitScript(commandline.nextString(new String[0]).getValue().getString());
                return true;
            }
            case "-s": 
            case "--scriptType": {
                this.config.setScriptType(commandline.nextString(new String[0]).getValue().getString());
                return true;
            }
            case "-t": 
            case "--to": {
                this.config.setTargetFolder(commandline.nextString(new String[0]).getValue().getString());
                return true;
            }
            case "-p": 
            case "--project": {
                this.config.setProjectPath(commandline.nextString(new String[0]).getValue().getString());
                return true;
            }
        }
        return false;
    }

    public boolean onCmdNextNonOption(NutsArgument nonOption, NutsCommandLine commandline, NutsApplicationContext context) {
        this.config.addSource(commandline.next().getString());
        return false;
    }

    public void onCmdFinishParsing(NutsCommandLine commandline, NutsApplicationContext context) {
        this.fileTemplater = new NFileTemplater(context);
    }

    public void onCmdExec(NutsCommandLine commandline, NutsApplicationContext context) {
        this.fileTemplater.processProject(this.config);
    }

    private static class NFileTemplater
    extends FileTemplater {
        public NFileTemplater(NutsApplicationContext appContext) {
            super(appContext.getSession());
            this.setDefaultExecutor("text/ntemplate-nsh-project", new NshEvaluator(appContext, this));
            this.setProjectFileName("project.nsh");
        }

        @Override
        public void executeProjectFile(Path path, String mimeTypesString) {
            this.executeRegularFile(path, "text/ntemplate-nsh-project");
        }
    }

    private static class NshEvaluator
    implements ExprEvaluator {
        private final NutsApplicationContext appContext;
        private final JShell shell;
        private final FileTemplater fileTemplater;

        public NshEvaluator(NutsApplicationContext appContext, FileTemplater fileTemplater) {
            this.appContext = appContext;
            this.fileTemplater = fileTemplater;
            this.shell = new JShell(appContext, new String[0]);
            JShellContext rootContext = this.shell.getRootContext();
            rootContext.setSession(rootContext.getSession().copy());
            rootContext.vars().addVarListener(new JShellVarListener(){

                public void varAdded(JShellVar jShellVar, JShellVariables vars, JShellContext context) {
                    this.setVar(jShellVar.getName(), jShellVar.getValue());
                }

                public void varValueUpdated(JShellVar jShellVar, String oldValue, JShellVariables vars, JShellContext context) {
                    this.setVar(jShellVar.getName(), jShellVar.getValue());
                }

                public void varRemoved(JShellVar jShellVar, JShellVariables vars, JShellContext context) {
                    this.setVar(jShellVar.getName(), null);
                }
            });
            rootContext.builtins().set((JShellBuiltin)new ProcessCmd(fileTemplater));
        }

        public void setVar(String varName, String newValue) {
            this.fileTemplater.getLog().debug("eval", varName + "=" + StringUtils.toLiteralString(newValue));
            this.fileTemplater.setVar(varName, newValue);
        }

        @Override
        public Object eval(String content, FileTemplater context) {
            JShellContext ctx = this.shell.createInlineContext(this.shell.getRootContext(), context.getSourcePath().orElse("nsh"), new String[0]);
            NutsSession session = context.getSession().copy();
            session.setTerminal(NutsSessionTerminal.ofMem((NutsSession)session));
            ctx.setSession(session);
            this.shell.executeScript(content, ctx);
            return session.out().toString();
        }

        public String toString() {
            return "nsh";
        }
    }
}

