/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntemplate.filetemplate.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class FileProcessorUtils {
    private static final char[] HEXARR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void mkdirs(Path parent) {
        if (parent == null) {
            return;
        }
        if (!Files.isDirectory(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    public static String extractWorkDir(String pathString, String defaultWorkdir) {
        if (pathString.startsWith("http://") || pathString.startsWith("https://")) {
            return ".";
        }
        if (pathString.startsWith("file://")) {
            try {
                File ff = Paths.get(new URL(pathString).toURI()).toFile();
                File pf = ff.getParentFile();
                if (pf != null) {
                    return pf.getAbsolutePath();
                }
                return defaultWorkdir;
            }
            catch (Exception ff) {
                return defaultWorkdir;
            }
        }
        File f = null;
        try {
            File d0 = new File(pathString);
            f = d0.isAbsolute() ? d0.getCanonicalFile().getParentFile() : new File(defaultWorkdir + File.separator + pathString).getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (f == null) {
            return defaultWorkdir;
        }
        return f.getPath();
    }

    public static Path toRealPath(Path path, Path workingDir) {
        try {
            return FileProcessorUtils.toAbsolutePath(path, workingDir).toRealPath(new LinkOption[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static Path toAbsolutePath(Path path, Path workingDir) {
        if (!path.isAbsolute()) {
            return workingDir.resolve(path).toAbsolutePath().normalize();
        }
        return path;
    }

    public static Path toAbsolute(Path pathString, Path workingDir) {
        if (pathString.isAbsolute()) {
            return pathString.normalize();
        }
        if (workingDir == null) {
            workingDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        }
        return workingDir.resolve(pathString).toAbsolutePath().normalize();
    }

    public static String toAbsolute(String pathString, String workingDir) {
        if (!new File(pathString).isAbsolute()) {
            if (workingDir == null) {
                workingDir = System.getProperty("user.dir");
            }
            pathString = workingDir + File.separator + pathString;
        }
        return pathString;
    }

    public static String loadString(Path s) {
        return FileProcessorUtils.loadString(s, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadString(Path s, String encoding) {
        try (InputStream in = Files.newInputStream(s, new OpenOption[0]);){
            String string = FileProcessorUtils.loadString(in, encoding);
            return string;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static String loadString(InputStream s, String encoding) {
        try {
            byte[] bytes = FileProcessorUtils.loadBytes(s);
            if (encoding == null) {
                return new String(bytes);
            }
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static String[] splitMimeTypes(String mt) {
        if (mt == null) {
            return new String[0];
        }
        return new String[]{mt};
    }

    public static byte[] loadBytes(InputStream s) {
        try {
            int r;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((r = s.read(buffer)) > 0) {
                bos.write(buffer, 0, r);
            }
            return bos.toByteArray();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static char toHex(int nibble) {
        return HEXARR[nibble & 0xF];
    }
}

