/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntemplate.filetemplate.processors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.FileTemplater;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.StreamProcessor;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.TemplateProcessor;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.util.FileProcessorUtils;

public class StreamToTemplateProcessor
implements TemplateProcessor {
    private StreamProcessor streamProcessor;

    public StreamToTemplateProcessor(StreamProcessor streamProcessor) {
        this.streamProcessor = streamProcessor;
    }

    @Override
    public void processPath(Path source, String mimeType, FileTemplater context) {
        String p = context.getPathTranslator().translatePath(source.toString());
        if (p != null) {
            Path targetPath = Paths.get(p, new String[0]);
            FileProcessorUtils.mkdirs(targetPath.getParent());
            try (InputStream in = Files.newInputStream(source, new OpenOption[0]);
                 OutputStream out = Files.newOutputStream(targetPath, new OpenOption[0]);){
                this.streamProcessor.processStream(in, out, context);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    @Override
    public void processStream(InputStream source, OutputStream target, FileTemplater context) {
        this.streamProcessor.processStream(source, target, context);
    }

    public String toString() {
        return String.valueOf(this.streamProcessor);
    }
}

