/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval;

import net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval.ExprNode;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.util.StringUtils;

public class ExprNodeLiteral
implements ExprNode {
    private String type;
    private Object value;

    public ExprNodeLiteral(String type, Object value) {
        this.type = type;
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        switch (this.type) {
            case "$\"": {
                return "$\"" + StringUtils.escapeString(String.valueOf(this.value)) + "\"";
            }
            case "\"": {
                return "\"" + StringUtils.escapeString(String.valueOf(this.value)) + "\"";
            }
            case "'": {
                return "'" + StringUtils.escapeString(String.valueOf(this.value)) + "'";
            }
            case "`": {
                return "`" + StringUtils.escapeString(String.valueOf(this.value)) + "`";
            }
        }
        if (this.value instanceof String) {
            return "\"" + this.value + "\"";
        }
        return String.valueOf(this.value);
    }
}

