/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntemplate.filetemplate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Stream;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextFormatStyle;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.DefaultMimeTypeResolver;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.DefaultPathTranslator;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.DefaultTemplateLog;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.ExprEvaluator;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.MimeTypeResolver;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.PathTranslator;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.TemplateConfig;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.TemplateLog;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.TemplateProcessor;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.TemplateProcessorFactory;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.eval.FtexEvaluator;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.processors.CopyStreamProcessor;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.processors.DefaultExecutor;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.processors.DollarVarStreamProcessor;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.processors.StreamToTemplateProcessor;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.util.FileProcessorUtils;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.util.StringUtils;

public class FileTemplater {
    private static final Map<String, TemplateProcessor> globalProcessorsByMimeType = new HashMap<String, TemplateProcessor>();
    private static final Map<String, TemplateProcessor> globalExecProcessorsByMimeType = new HashMap<String, TemplateProcessor>();
    private static final StreamToTemplateProcessor DEFAULT_PROCESSOR = new StreamToTemplateProcessor(new CopyStreamProcessor());
    private static final StreamToTemplateProcessor FTEX_PROCESSOR = new StreamToTemplateProcessor(new DefaultExecutor(new FtexEvaluator()));
    private static final TemplateProcessor IGNORE_PROCESSOR = new TemplateProcessor(){

        @Override
        public void processStream(InputStream source, OutputStream target, FileTemplater context) {
        }

        @Override
        public void processPath(Path source, String mimeType, FileTemplater context) {
        }
    };
    public static final String ROOT_DIR = "rootDir";
    public static final String WORKING_DIR = "workingDir";
    public static final String SOURCE_PATH = "sourcePath";
    public static final String PROJECT_FILENAME = "project.ftex";
    private FileTemplater parent;
    private Function<String, Object> customVarEvaluator;
    private TemplateProcessorFactory processorFactory;
    private TemplateProcessorFactory executorFactory;
    private MimeTypeResolver mimeTypeResolver;
    private String sourcePath;
    private String rootDir;
    private String workingDir;
    private final Map<String, Object> vars = new HashMap<String, Object>();
    private final Map<String, TemplateProcessor> processorsByMimeType = new HashMap<String, TemplateProcessor>();
    private final Map<String, TemplateProcessor> execProcessorsByMimeType = new HashMap<String, TemplateProcessor>();
    private boolean userParentProperties;
    private PathTranslator pathTranslator;
    private String projectFileName = "project.ftex";
    private NutsSession session;

    public FileTemplater(final NutsSession session) {
        this.session = session;
        this.setLog(new TemplateLog(){
            NutsLoggerOp logOp;

            @Override
            public void info(String title, String message) {
                this.log().verb(NutsLogVerb.INFO).level(Level.FINER).log("{0} : {1}", new Object[]{title, message});
            }

            @Override
            public void debug(String title, String message) {
                this.log().verb(NutsLogVerb.DEBUG).level(Level.FINER).log("{0} : {1}", new Object[]{title, message});
            }

            @Override
            public void error(String title, String message) {
                this.log().verb(NutsLogVerb.FAIL).level(Level.FINER).log("{0} : {1}", new Object[]{title, message});
            }

            private NutsLoggerOp log() {
                if (this.logOp == null) {
                    this.logOp = session.getWorkspace().log().of(FileTemplater.this.getClass()).with().style(NutsTextFormatStyle.JSTYLE);
                }
                return this.logOp;
            }
        });
    }

    public FileTemplater(FileTemplater parent) {
        this(parent.session);
        this.parent = parent;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public boolean isUserParentProperties() {
        return this.userParentProperties;
    }

    public FileTemplater setUserParentProperties(boolean userParentProperties) {
        this.userParentProperties = userParentProperties;
        return this;
    }

    public String getProjectFileName() {
        return this.projectFileName;
    }

    public FileTemplater setProjectFileName(String projectFileName) {
        if (projectFileName == null || projectFileName.isEmpty()) {
            projectFileName = PROJECT_FILENAME;
        }
        this.projectFileName = projectFileName;
        return this;
    }

    public FileTemplater newChild() {
        return new FileTemplater(this);
    }

    public TemplateProcessor getProcessor(String mimetype) {
        if (mimetype == null || mimetype.isEmpty() || mimetype.equals("*")) {
            mimetype = "*/*";
        }
        for (String mt : mimetype.split(";")) {
            TemplateProcessor m;
            if ((mt = mt.trim()).length() <= 0 || (m = this.getProcessorExact(mt)) == null) continue;
            return m;
        }
        for (String mt : mimetype.split(";")) {
            TemplateProcessor m;
            int slash;
            if ((mt = mt.trim()).length() <= 0 || (slash = mimetype.indexOf(47)) <= 0) continue;
            String a = mimetype.substring(0, slash);
            String b = mimetype.substring(slash + 1);
            if (b.equals("*") || (m = this.getProcessorExact(a + "/*")) == null) continue;
            return m;
        }
        return this.getProcessorExact("*/*");
    }

    public Function<String, Object> getCustomVarEvaluator() {
        if (this.customVarEvaluator != null) {
            return this.customVarEvaluator;
        }
        if (this.parent != null) {
            return this.parent.getCustomVarEvaluator();
        }
        return null;
    }

    public FileTemplater setCustomVarEvaluator(Function<String, Object> customVarEvaluator) {
        this.customVarEvaluator = customVarEvaluator;
        return this;
    }

    public TemplateProcessor getDefaultProcessor(String mimetype) {
        TemplateProcessor processor = this.processorsByMimeType.get(mimetype);
        if (processor != null) {
            return processor;
        }
        if (this.parent != null) {
            return this.parent.getDefaultProcessor(mimetype);
        }
        return null;
    }

    public FileTemplater setDefaultProcessor(String mimetype, ExprEvaluator processor) {
        return this.setDefaultProcessor(mimetype, processor == null ? null : new StreamToTemplateProcessor(new DefaultExecutor(processor)));
    }

    public FileTemplater setDefaultProcessor(String mimetype, TemplateProcessor processor) {
        if (processor == null) {
            this.processorsByMimeType.remove(mimetype);
        } else {
            this.processorsByMimeType.put(mimetype, processor);
        }
        return this;
    }

    public TemplateProcessor getExecutor(String mimetype) {
        String[] mts;
        if (mimetype == null || mimetype.isEmpty() || mimetype.equals("*")) {
            mimetype = "*/*";
        }
        for (String mt : mts = (String[])Stream.of(mimetype.split(";")).map(String::trim).filter(x -> x.length() > 0).toArray(String[]::new)) {
            TemplateProcessor m = this.getExecutorExact(mt);
            if (m == null) continue;
            return m;
        }
        for (String mt : mts) {
            TemplateProcessor m;
            int slash = mt.indexOf(47);
            if (slash <= 0) continue;
            String a = mt.substring(0, slash);
            String b = mt.substring(slash + 1);
            if (b.equals("*") || (m = this.getExecutorExact(a + "/*")) == null) continue;
            return m;
        }
        TemplateProcessor z = this.getExecutorExact("*/*");
        if (z != null) {
            return z;
        }
        return DEFAULT_PROCESSOR;
    }

    public TemplateProcessor getProcessorExact(String mimetype) {
        TemplateProcessor p;
        if (this.processorFactory != null && (p = this.processorFactory.getProcessor(mimetype)) != null) {
            return p;
        }
        p = this.processorsByMimeType.get(mimetype);
        if (p != null) {
            return p;
        }
        if (this.parent != null) {
            return this.parent.getProcessorExact(mimetype);
        }
        p = globalProcessorsByMimeType.get(mimetype);
        if (p != null) {
            return p;
        }
        return null;
    }

    public TemplateProcessor getExecutorExact(String mimetype) {
        TemplateProcessor p;
        if (this.executorFactory != null && (p = this.executorFactory.getProcessor(mimetype)) != null) {
            return p;
        }
        p = this.execProcessorsByMimeType.get(mimetype);
        if (p != null) {
            return p;
        }
        if (this.parent != null) {
            return this.parent.getExecutorExact(mimetype);
        }
        p = globalExecProcessorsByMimeType.get(mimetype);
        if (p != null) {
            return p;
        }
        return null;
    }

    public TemplateProcessor getDefaultExecutor(String mimetype) {
        TemplateProcessor processor = this.execProcessorsByMimeType.get(mimetype);
        if (processor != null) {
            return processor;
        }
        if (this.parent != null) {
            return this.parent.getDefaultExecutor(mimetype);
        }
        return null;
    }

    public FileTemplater setDefaultExecutor(String mimetype, ExprEvaluator executor) {
        return this.setDefaultExecutor(mimetype, executor == null ? null : new StreamToTemplateProcessor(new DefaultExecutor(executor)));
    }

    public FileTemplater setDefaultExecutor(String mimetype, TemplateProcessor executor) {
        if (executor == null) {
            this.execProcessorsByMimeType.remove(mimetype);
        } else {
            this.execProcessorsByMimeType.put(mimetype, executor);
        }
        return this;
    }

    public TemplateProcessorFactory getExecutorFactory() {
        if (this.executorFactory != null) {
            return this.executorFactory;
        }
        if (this.parent != null) {
            return this.parent.getExecutorFactory();
        }
        return null;
    }

    public FileTemplater setExecutorFactory(TemplateProcessorFactory processorFactory) {
        this.executorFactory = processorFactory;
        return this;
    }

    public TemplateProcessorFactory getProcessorFactory() {
        if (this.processorFactory != null) {
            return this.processorFactory;
        }
        if (this.parent != null) {
            return this.parent.getProcessorFactory();
        }
        return null;
    }

    public FileTemplater setProcessorFactory(TemplateProcessorFactory processorFactory) {
        this.processorFactory = processorFactory;
        return this;
    }

    public TemplateLog getLog() {
        TemplateLog ll = (TemplateLog)this.getVar("log", null);
        if (ll == null) {
            return DefaultTemplateLog.INSTANCE;
        }
        return ll;
    }

    public FileTemplater setLog(TemplateLog log) {
        return this.setVar("log", log);
    }

    public FileTemplater setParent(FileTemplater parent) {
        this.parent = parent;
        return this;
    }

    public FileTemplater getParent() {
        return this.parent;
    }

    public String getWorkingDirRequired() {
        return (String)this.getVarRequired(WORKING_DIR);
    }

    public String getRootDirRequired() {
        return (String)this.getVarRequired(ROOT_DIR);
    }

    public Optional<String> getWorkingDir() {
        return this.getVar(WORKING_DIR);
    }

    public Optional<String> getRootDir() {
        return this.getVar(ROOT_DIR);
    }

    public FileTemplater setWorkingDir(String workingDir) {
        return this.setVar(WORKING_DIR, workingDir);
    }

    public FileTemplater setRootDir(String rootDir) {
        return this.setVar(ROOT_DIR, rootDir);
    }

    public FileTemplater removeWorkingDir() {
        return this.remove(WORKING_DIR);
    }

    public FileTemplater removeRootDir() {
        return this.remove(ROOT_DIR);
    }

    public String getSourcePathRequired() {
        return (String)this.getVarRequired(SOURCE_PATH);
    }

    public Optional<String> getSourcePath() {
        return this.getVar(SOURCE_PATH);
    }

    public FileTemplater setSourcePath(String workingDir) {
        return this.setVar(SOURCE_PATH, workingDir);
    }

    public boolean isSet(String name) {
        switch (name) {
            case "rootDir": 
            case "sourcePath": 
            case "workingDir": {
                return true;
            }
        }
        return this.vars.containsKey(name);
    }

    public FileTemplater setVar(String name, Object value) {
        switch (name) {
            case "sourcePath": {
                this.sourcePath = (String)value;
                return this;
            }
            case "workingDir": {
                this.workingDir = (String)value;
                return this;
            }
            case "rootDir": {
                this.rootDir = (String)value;
                return this;
            }
        }
        if (this.parent != null && this.userParentProperties) {
            this.parent.setVar(name, value);
            return this;
        }
        this.vars.put(name, value);
        return this;
    }

    public FileTemplater remove(String name) {
        switch (name) {
            case "rootDir": 
            case "sourcePath": 
            case "workingDir": {
                this.setVar(name, null);
                return this;
            }
        }
        if (this.parent != null && this.userParentProperties) {
            this.parent.remove(name);
            return this;
        }
        this.vars.remove(name);
        return this;
    }

    public Map<String, Object> getVars() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.vars);
        if (this.parent != null) {
            for (Map.Entry<String, Object> e : this.parent.getVars().entrySet()) {
                if (result.containsKey(e.getKey())) continue;
                result.put(e.getKey(), e.getValue());
            }
        }
        return result;
    }

    public Object getVar(String name, Object defaultValue) {
        return this.getVar(name).orElse(defaultValue);
    }

    public Object getVarRequired(final String name) {
        return this.getVar(name).orElseThrow(new Supplier<NoSuchElementException>(){

            @Override
            public NoSuchElementException get() {
                String source = FileTemplater.this.getSourcePath().orElse(null);
                if (source == null) {
                    return new NoSuchElementException("var not found: " + StringUtils.escapeString(name));
                }
                return new NoSuchElementException("var not found: " + StringUtils.escapeString(name) + " in " + source);
            }
        });
    }

    public Optional<Object> getVar(String name) {
        switch (name) {
            case "sourcePath": {
                if (this.sourcePath == null) break;
                return Optional.of(this.sourcePath);
            }
            case "workingDir": {
                if (this.workingDir == null) break;
                return Optional.of(this.workingDir);
            }
            case "rootDir": {
                if (this.rootDir == null) break;
                return Optional.of(this.rootDir);
            }
        }
        Object r = this.vars.get(name);
        if (r != null) {
            return Optional.of(r);
        }
        if (this.vars.containsKey(name)) {
            return Optional.of(null);
        }
        if (this.customVarEvaluator != null && (r = this.customVarEvaluator.apply(name)) != null) {
            return Optional.of(r);
        }
        if (this.parent != null) {
            return this.parent.getVar(name);
        }
        return Optional.empty();
    }

    public void processTree(Path path, Predicate<Path> filter) {
        block19: {
            Path path0;
            if (!this.getRootDir().isPresent()) {
                this.setRootDir(path.toString());
            }
            if (Files.isRegularFile(path0 = this.toAbsolutePath(path), new LinkOption[0])) {
                if (filter == null || filter.test(path0)) {
                    this.processRegularFile(path, null);
                }
            } else {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    try (Stream<Path> stream = Files.walk(path0, new FileVisitOption[0]).filter(x -> Files.isRegularFile(x, new LinkOption[0]));){
                        stream.forEach(x -> {
                            if (filter == null || filter.test((Path)x)) {
                                try {
                                    this.processRegularFile((Path)x, null);
                                }
                                catch (Exception ex) {
                                    throw new RuntimeException("error processing " + x + ": " + ex.toString(), ex);
                                }
                            }
                        });
                        break block19;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                throw new UncheckedIOException(new IOException("Unsupported path " + path));
            }
        }
    }

    public void processFiles(Path path, Predicate<Path> filter) {
        block18: {
            Path path0 = this.toAbsolutePath(path);
            if (Files.isRegularFile(path0, new LinkOption[0])) {
                if (filter == null || filter.test(path0)) {
                    this.processRegularFile(path0, null);
                }
            } else {
                if (Files.isDirectory(path0, new LinkOption[0])) {
                    try (Stream<Path> stream = Files.list(path0);){
                        stream.filter(filter).forEach(x -> {
                            if (Files.isRegularFile(x, new LinkOption[0]) && (filter == null || filter.test((Path)x))) {
                                this.processRegularFile(path0, null);
                            }
                        });
                        break block18;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                throw new UncheckedIOException(new IOException("Unsupported path " + path));
            }
        }
    }

    public void executeProjectFile(Path path, String mimeTypesString) {
        this.executeRegularFile(path, mimeTypesString);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeRegularFile(Path path, String mimeTypesString) {
        String[] mimeTypesArray;
        Path absolutePath = this.toAbsolutePath(path);
        Path parentPath = absolutePath.getParent();
        if (!Files.isRegularFile(absolutePath, new LinkOption[0])) {
            throw new IllegalArgumentException("no a file : " + path.toString());
        }
        String[] stringArray = mimeTypesArray = mimeTypesString == null ? FileProcessorUtils.splitMimeTypes(this.getMimeTypeResolver().resolveMimetype(path.toString())) : FileProcessorUtils.splitMimeTypes(mimeTypesString);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String mimeType = stringArray[n2];
            TemplateProcessor proc = null;
            try {
                proc = this.getExecutor(mimeType);
            }
            catch (Exception ex) {
                this.getLog().error("file", "error resolving executor for mimetype " + mimeType + " and file : " + path.toString() + ". " + ex.toString());
            }
            if (proc != null) {
                try {
                    String s1 = path.toString();
                    String s2 = absolutePath.toString();
                    if (s1.equals(s2)) {
                        this.getLog().debug("file", "[" + proc + "] [" + mimeType + "] execute path : " + s1);
                    } else {
                        this.getLog().debug("file", "[" + proc + "] [" + mimeType + "] execute path : " + s1 + " = " + s2);
                    }
                    try (InputStream in = Files.newInputStream(absolutePath, new OpenOption[0]);){
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        proc.processStream(in, out, this.newChild().setUserParentProperties(true).setWorkingDir(parentPath.toString()).setSourcePath(absolutePath.toString()));
                        String string = out.toString();
                        return string;
                    }
                }
                catch (IOException ex) {
                    throw new UncheckedIOException("error executing file : " + path.toString(), ex);
                }
            }
            ++n2;
        }
        throw new IllegalArgumentException("processor not found for " + mimeTypesString);
    }

    public void processRegularFile(Path path, String mimeType) {
        String[] mimeTypes;
        Path absolutePath = this.toAbsolutePath(path);
        Path parentPath = absolutePath.getParent();
        if (!Files.isRegularFile(absolutePath, new LinkOption[0])) {
            throw new IllegalArgumentException("unsupported file : " + path.toString());
        }
        for (String mimeType0 : mimeTypes = mimeType == null ? FileProcessorUtils.splitMimeTypes(this.getMimeTypeResolver().resolveMimetype(path.toString())) : FileProcessorUtils.splitMimeTypes(mimeType)) {
            String s2;
            TemplateProcessor proc = null;
            try {
                proc = this.getProcessor(mimeType0);
            }
            catch (Exception ex) {
                this.getLog().error("file", "error resolving processor for mimetype " + mimeType0 + " and file : " + path.toString() + ". " + ex.toString());
            }
            if (proc == null) continue;
            String s1 = path.toString();
            if (s1.equals(s2 = absolutePath.toString())) {
                this.getLog().debug("file", "[" + proc + "] [" + mimeType + "] process path : " + s1);
            } else {
                this.getLog().debug("file", "[" + proc + "] [" + mimeType + "] process path : " + s1 + " = " + s2);
            }
            proc.processPath(path, mimeType0, this.newChild().setUserParentProperties(true).setWorkingDir(parentPath.toString()).setSourcePath(absolutePath.toString()));
        }
    }

    private Path toAbsolutePath(Path path) {
        return FileProcessorUtils.toRealPath(path, Paths.get(this.getWorkingDirRequired(), new String[0]));
    }

    public String executeString(String source, String mimeType) {
        return this.executeStream(new ByteArrayInputStream(source.getBytes()), mimeType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeStream(InputStream source, String mimeType) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String[] mimeTypes;
            String[] stringArray = mimeTypes = FileProcessorUtils.splitMimeTypes(mimeType);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String mimeType0 = stringArray[n2];
                TemplateProcessor proc = null;
                proc = this.getExecutor(mimeType0);
                if (proc != null) {
                    try {
                        proc.processStream(source, bos, this.newChild().setUserParentProperties(true));
                    }
                    catch (Exception ex) {
                        this.getLog().error("file", "error processing mimeType : " + mimeType + ". " + ex.toString());
                    }
                    String string = bos.toString();
                    return string;
                }
                ++n2;
            }
            throw new IllegalArgumentException("unsupported mimetype : " + mimeType);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String processString(String source, String mimeType) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.processStream(new ByteArrayInputStream(source.getBytes()), bos, mimeType);
        return bos.toString();
    }

    public void processStream(InputStream source, OutputStream target, String mimeType) {
        String[] mimeTypes;
        for (String mimeType0 : mimeTypes = FileProcessorUtils.splitMimeTypes(mimeType)) {
            TemplateProcessor proc = null;
            try {
                proc = this.getProcessor(mimeType0);
            }
            catch (Exception ex) {
                this.getLog().error("file", "unsupported mimeType : " + mimeType0 + ". " + ex);
            }
            if (proc == null) continue;
            try {
                proc.processStream(source, target, this.newChild().setUserParentProperties(true));
            }
            catch (Exception ex) {
                this.getLog().error("file", "error processing mimeType : " + mimeType + ". " + ex);
            }
            return;
        }
        throw new IllegalArgumentException("unsupported mimetype : " + mimeType);
    }

    public MimeTypeResolver getMimeTypeResolver() {
        if (this.mimeTypeResolver != null) {
            return this.mimeTypeResolver;
        }
        if (this.parent != null) {
            return this.parent.getMimeTypeResolver();
        }
        return DefaultMimeTypeResolver.DEFAULT;
    }

    public FileTemplater setMimeTypeResolver(MimeTypeResolver mimeTypeResolver) {
        this.mimeTypeResolver = mimeTypeResolver;
        return this;
    }

    public PathTranslator getPathTranslator() {
        if (this.pathTranslator != null) {
            return this.pathTranslator;
        }
        if (this.parent != null) {
            return this.parent.getPathTranslator();
        }
        return null;
    }

    public FileTemplater setPathTranslator(Path from, Path to) {
        return this.setPathTranslator(new DefaultPathTranslator(from, to));
    }

    public FileTemplater setTargetPath(Path to) {
        return this.setPathTranslator(new DefaultPathTranslator(Paths.get(this.getWorkingDirRequired(), new String[0]), to));
    }

    public FileTemplater setPathTranslator(PathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
        return this;
    }

    public void processProject(TemplateConfig config) {
        String tf;
        String projectPath = config.getProjectPath();
        String scriptType = config.getScriptType();
        String targetFolder = config.getTargetFolder();
        if (projectPath == null) {
            if (config.getPaths().isEmpty()) {
                throw new IllegalArgumentException("missing path to process");
            }
            if (targetFolder == null) {
                throw new IllegalArgumentException("missing target folder");
            }
        }
        Path oProjectDirPath = Paths.get(projectPath, new String[0]);
        Path oProjectFile = oProjectDirPath.resolve(this.getProjectFileName());
        Path oProjectSrc = oProjectDirPath.resolve("src");
        if (!Files.isDirectory(oProjectSrc, new LinkOption[0])) {
            throw new IllegalArgumentException("invalid project, missing src/ folder : " + oProjectDirPath);
        }
        if (!Files.isRegularFile(oProjectFile, new LinkOption[0])) {
            throw new IllegalArgumentException("invalid project, missing project.ftex : " + oProjectDirPath);
        }
        ArrayList<String> initScripts = new ArrayList<String>(config.getInitScripts());
        initScripts.add(oProjectFile.toString());
        ArrayList<String> paths = new ArrayList<String>(config.getPaths());
        paths.add(oProjectSrc.toString());
        if (scriptType != null && scriptType.indexOf(47) < 0) {
            scriptType = "text/" + scriptType;
        }
        for (String initScript : initScripts) {
            Path fpath = Paths.get(initScript, new String[0]).toAbsolutePath();
            this.setWorkingDir(FileTemplater.workingPath(fpath).toString());
            this.executeProjectFile(fpath, scriptType);
        }
        if (projectPath != null && (tf = (String)this.getVar("targetFolder", null)) != null && targetFolder == null) {
            targetFolder = tf;
        }
        if (targetFolder == null) {
            throw new IllegalArgumentException("missing target folder");
        }
        FileProcessorUtils.mkdirs(Paths.get(targetFolder, new String[0]));
        try {
            targetFolder = Paths.get(targetFolder, new String[0]).toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        for (String path : paths) {
            Path opath;
            try {
                opath = Paths.get(path, new String[0]).toRealPath(new LinkOption[0]);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            if (Files.isDirectory(opath, new LinkOption[0])) {
                this.setWorkingDir(opath.toString());
                if (targetFolder != null) {
                    this.setPathTranslator(new DefaultPathTranslator(opath, Paths.get(targetFolder, new String[0])));
                }
            } else {
                Path ppath = opath.getParent();
                this.setWorkingDir(ppath.toString());
                if (targetFolder != null) {
                    this.setPathTranslator(new DefaultPathTranslator(opath, ppath));
                }
            }
            this.processTree(opath, config.getPathFilter());
        }
    }

    private static Path workingPath(Path p) {
        if (Files.isDirectory(p, new LinkOption[0])) {
            return p;
        }
        Path pp = p.getParent();
        if (pp == null) {
            throw new IllegalArgumentException("Unsupported");
        }
        return pp;
    }

    static {
        globalProcessorsByMimeType.put("application/x-file-placeholder-dollars", new StreamToTemplateProcessor(new DollarVarStreamProcessor()));
        globalProcessorsByMimeType.put("text/*", new StreamToTemplateProcessor(new DollarVarStreamProcessor()));
        globalProcessorsByMimeType.put("*/*", DEFAULT_PROCESSOR);
        globalExecProcessorsByMimeType.put("text/ftex", FTEX_PROCESSOR);
        globalExecProcessorsByMimeType.put("application/x-file-ignore", IGNORE_PROCESSOR);
    }
}

