/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntemplate.filetemplate;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.MimeTypeResolver;

public class DefaultMimeTypeResolver
implements MimeTypeResolver {
    public static final MimeTypeResolver DEFAULT = new DefaultMimeTypeResolver().setExtensionMimeType("ftex", "text/ftex").setImmutable();
    private final Map<String, String> extensionToMimeType = new HashMap<String, String>();
    private final Map<String, String> nameToMimeType = new HashMap<String, String>();
    private boolean immutable = false;

    public DefaultMimeTypeResolver copy() {
        DefaultMimeTypeResolver copy = new DefaultMimeTypeResolver();
        for (Map.Entry<String, String> e : this.extensionToMimeType.entrySet()) {
            copy.setExtensionMimeType(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, String> e : this.nameToMimeType.entrySet()) {
            copy.setNameMimeType(e.getKey(), e.getValue());
        }
        return copy;
    }

    public DefaultMimeTypeResolver setNameMimeType(String name, String mimeType) {
        this.checkImmutable();
        if (mimeType == null) {
            this.nameToMimeType.remove(name);
        } else {
            this.nameToMimeType.put(name, mimeType);
        }
        return this;
    }

    public DefaultMimeTypeResolver setExtensionMimeType(String extension, String mimeType) {
        this.checkImmutable();
        if (mimeType == null) {
            this.extensionToMimeType.remove(extension);
        } else {
            this.extensionToMimeType.put(extension, mimeType);
        }
        return this;
    }

    public MimeTypeResolver setImmutable() throws IllegalArgumentException {
        this.immutable = true;
        return this;
    }

    private void checkImmutable() throws IllegalArgumentException {
        if (this.immutable) {
            throw new IllegalArgumentException("Immutable Resolver");
        }
    }

    protected String[] getExtensions(String path) {
        int li;
        ArrayList<String> all = new ArrayList<String>();
        int index = path.length();
        while (index > 0 && (li = path.lastIndexOf(46, index)) > 0) {
            all.add(path.substring(li + 1));
            index = li - 1;
        }
        return all.toArray(new String[0]);
    }

    @Override
    public String resolveMimetype(String path) {
        try {
            String s = this.nameToMimeType.get(Paths.get(path, new String[0]).getFileName().toString());
            if (s != null) {
                return s;
            }
            for (String extension : this.getExtensions(path)) {
                String r = this.extensionToMimeType.get(extension);
                if (r == null) continue;
                return r;
            }
            String mimeType = Files.probeContentType(Paths.get(path, new String[0]));
            if (mimeType != null) {
                return mimeType;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DefaultMimeTypeResolver.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "application/binary";
    }
}

