/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntemplate;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.thevpc.nuts.NutsApplication;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineProcessor;
import net.thevpc.nuts.NutsMemoryPrintStream;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.toolbox.nsh.AbstractNshBuiltin;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShell;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellContext;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellFileContext;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellVar;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellVarListener;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellVariables;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.ExprEvaluator;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.FileTemplater;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.TemplateConfig;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.util.StringUtils;

public class NTemplateMain
implements NutsApplication {
    public static void main(String[] args) {
        NutsApplication.main(NTemplateMain.class, (String[])args);
    }

    public void run(final NutsApplicationContext appContext) {
        appContext.processCommandLine(new NutsCommandLineProcessor(){
            TemplateConfig config = new TemplateConfig();
            private FileTemplater fileTemplater;

            public boolean onNextOption(NutsArgument option, NutsCommandLine commandline) {
                switch (option.getStringKey()) {
                    case "-i": 
                    case "--init": {
                        this.config.addInitScript(commandline.nextString(new String[0]).getStringValue());
                        return true;
                    }
                    case "-s": 
                    case "--scriptType": {
                        this.config.setScriptType(commandline.nextString(new String[0]).getStringValue());
                        return true;
                    }
                    case "-t": 
                    case "--to": {
                        this.config.setTargetFolder(commandline.nextString(new String[0]).getStringValue());
                        return true;
                    }
                    case "-p": 
                    case "--project": {
                        this.config.setProjectPath(commandline.nextString(new String[0]).getStringValue());
                        return true;
                    }
                }
                return false;
            }

            public boolean onNextNonOption(NutsArgument nonOption, NutsCommandLine commandline) {
                this.config.addSource(commandline.next().getString());
                return false;
            }

            public void onPrepare(NutsCommandLine commandline) {
                this.fileTemplater = new NFileTemplater(appContext);
            }

            public void onExec() {
                this.fileTemplater.processProject(this.config);
            }
        });
    }

    private static class NFileTemplater
    extends FileTemplater {
        public NFileTemplater(NutsApplicationContext appContext) {
            super(appContext.getSession());
            this.setDefaultExecutor("text/ntemplate-nsh-project", new NshEvaluator(appContext, this));
            this.setProjectFileName("project.nsh");
        }

        @Override
        public void executeProjectFile(Path path, String mimeTypesString) {
            this.executeRegularFile(path, "text/ntemplate-nsh-project");
        }
    }

    private static class NshEvaluator
    implements ExprEvaluator {
        private NutsApplicationContext appContext;
        private JShell shell;
        private FileTemplater fileTemplater;

        public NshEvaluator(NutsApplicationContext appContext, final FileTemplater fileTemplater) {
            this.appContext = appContext;
            this.fileTemplater = fileTemplater;
            this.shell = new JShell(appContext, new String[0]);
            this.shell.setSession(this.shell.getSession().copy());
            this.shell.getRootContext().vars().addVarListener(new JShellVarListener(){

                public void varAdded(JShellVar jShellVar, JShellVariables vars, JShellContext context) {
                    this.setVar(jShellVar.getName(), jShellVar.getValue());
                }

                public void varValueUpdated(JShellVar jShellVar, String oldValue, JShellVariables vars, JShellContext context) {
                    this.setVar(jShellVar.getName(), jShellVar.getValue());
                }

                public void varRemoved(JShellVar jShellVar, JShellVariables vars, JShellContext context) {
                    this.setVar(jShellVar.getName(), null);
                }
            });
            this.shell.getRootContext().builtins().set((JShellBuiltin)new AbstractNshBuiltin("process", 10){

                public int execImpl(String[] args, JShellExecutionContext context) {
                    if (args.length != 1) {
                        context.err().println(this.getName() + " : invalid arguments count");
                        return 1;
                    }
                    String pathString = args[0];
                    fileTemplater.getLog().debug("eval", this.getName() + "(" + StringUtils.toLiteralString(pathString) + ")");
                    fileTemplater.executeRegularFile(Paths.get(pathString, new String[0]), null);
                    return 0;
                }
            });
        }

        public void setVar(String varName, String newValue) {
            this.fileTemplater.getLog().debug("eval", varName + "=" + StringUtils.toLiteralString(newValue));
            this.fileTemplater.setVar(varName, newValue);
        }

        @Override
        public Object eval(String content, FileTemplater context) {
            NutsMemoryPrintStream out = this.shell.getSession().getWorkspace().io().createMemoryPrintStream();
            NutsMemoryPrintStream err = this.shell.getSession().getWorkspace().io().createMemoryPrintStream();
            this.shell.getSession().setTerminal(this.shell.getSession().getWorkspace().term().createTerminal((InputStream)new ByteArrayInputStream(new byte[0]), (NutsPrintStream)out, (NutsPrintStream)err));
            JShellFileContext ctx = this.shell.createSourceFileContext(this.shell.getRootContext(), context.getSourcePath().orElse("nsh"), new String[0]);
            this.shell.executeString(content, ctx);
            return out.toString();
        }

        public String toString() {
            return "nsh";
        }
    }
}

