/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntemplate.filetemplate.util;

import java.io.File;
import java.nio.file.Path;
import net.thevpc.nuts.toolbox.ntemplate.filetemplate.util.FileProcessorUtils;

public class StringUtils {
    public static String toLiteralString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Number) {
            return String.valueOf(o);
        }
        if (o instanceof CharSequence) {
            return "\"" + StringUtils.escapeString(String.valueOf(o)) + "\"";
        }
        if (o instanceof File) {
            return "\"" + StringUtils.escapeString(String.valueOf(((File)o).getPath())) + "\"";
        }
        if (o instanceof Path) {
            return "\"" + StringUtils.escapeString(String.valueOf(((Path)o).toString())) + "\"";
        }
        if (o instanceof Character) {
            return "'" + StringUtils.escapeString(String.valueOf(o)) + "'";
        }
        return "<" + o.getClass().getSimpleName() + ">\"" + StringUtils.escapeString(String.valueOf(o)) + "\"";
    }

    public static String escapeString(String s) {
        StringBuilder outBuffer = new StringBuilder();
        block6: for (char aChar : s.toCharArray()) {
            if (aChar == '\\') {
                outBuffer.append("\\\\");
                continue;
            }
            if (aChar == '\"') {
                outBuffer.append("\\\"");
                continue;
            }
            if (aChar > '=' && aChar < '\u007f') {
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case '\t': {
                    outBuffer.append("\\t");
                    continue block6;
                }
                case '\n': {
                    outBuffer.append("\\n");
                    continue block6;
                }
                case '\r': {
                    outBuffer.append("\\r");
                    continue block6;
                }
                case '\f': {
                    outBuffer.append("\\f");
                    continue block6;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(FileProcessorUtils.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(FileProcessorUtils.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(FileProcessorUtils.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(FileProcessorUtils.toHex(aChar & 0xF));
                        continue block6;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }
}

