/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.ntemplate.filetemplate.util;

import java.util.ArrayList;

public class CommandlineUtils {
    public static String[] parseCommandLine(String commandLineString) {
        if (commandLineString == null) {
            return new String[0];
        }
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean START = false;
        boolean IN_WORD = true;
        int IN_QUOTED_WORD = 2;
        int IN_DBQUOTED_WORD = 3;
        int status = 0;
        char[] charArray = commandLineString.toCharArray();
        block31: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            switch (status) {
                case 0: {
                    switch (c) {
                        case ' ': {
                            continue block31;
                        }
                        case '\'': {
                            status = 2;
                            continue block31;
                        }
                        case '\"': {
                            status = 3;
                            continue block31;
                        }
                        case '\\': {
                            status = 1;
                            sb.append(charArray[++i]);
                            continue block31;
                        }
                    }
                    sb.append(c);
                    status = 1;
                    continue block31;
                }
                case 1: {
                    switch (c) {
                        case ' ': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block31;
                        }
                        case '\'': {
                            throw new IllegalArgumentException("Illegal char " + c);
                        }
                        case '\"': {
                            throw new IllegalArgumentException("Illegal char " + c);
                        }
                        case '\\': {
                            sb.append(charArray[++i]);
                            continue block31;
                        }
                    }
                    sb.append(c);
                    continue block31;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block31;
                        }
                        case '\\': {
                            i = CommandlineUtils.readEscaped(charArray, i + 1, sb);
                            continue block31;
                        }
                    }
                    sb.append(c);
                    continue block31;
                }
                case 3: {
                    switch (c) {
                        case '\"': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block31;
                        }
                        case '\\': {
                            i = CommandlineUtils.readEscaped(charArray, i + 1, sb);
                            continue block31;
                        }
                    }
                    sb.append(c);
                }
            }
        }
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                args.add(sb.toString());
                sb.delete(0, sb.length());
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Expected '");
            }
        }
        return args.toArray(new String[0]);
    }

    private static int readEscaped(char[] charArray, int i, StringBuilder sb) {
        char c = charArray[i];
        switch (c) {
            case 'n': {
                sb.append('\n');
                break;
            }
            case 't': {
                sb.append('\t');
                break;
            }
            case 'r': {
                sb.append('\r');
                break;
            }
            case 'f': {
                sb.append('\f');
                break;
            }
            default: {
                sb.append(c);
            }
        }
        return i;
    }
}

