/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class PropertyFilter
implements Serializable {
    private String regexPattern;
    private transient String[] regexPatternOrder;

    public PropertyFilter(String filter) {
        this.regexPattern = filter;
    }

    public boolean matchesProperty(String propertyName) {
        return propertyName.matches(this.regexPattern);
    }

    public List<String> filter(List<String> properties) {
        ArrayList<String> a = new ArrayList<String>();
        for (String p : properties) {
            int x = this.getMatchingIndex(p);
            if (x < 0) continue;
            a.add(p);
        }
        this.reorderProperties(a);
        return a;
    }

    public void reorderProperties(List<String> properties) {
        final HashMap h = new HashMap();
        Collections.sort(properties, new Comparator<String>(){

            @Override
            public int compare(String s, String s1) {
                int i1;
                int i;
                if (!h.containsKey(s)) {
                    h.put(s, PropertyFilter.this.getMatchingIndex(s));
                }
                if (!h.containsKey(s1)) {
                    h.put(s1, PropertyFilter.this.getMatchingIndex(s1));
                }
                if ((i = ((Integer)h.get(s)).intValue()) * (i1 = ((Integer)h.get(s1)).intValue()) >= 0) {
                    return i - i1;
                }
                if (i < 0) {
                    return 1;
                }
                return -1;
            }
        });
    }

    public int getMatchingIndex(String propertyName) {
        if (!propertyName.matches(this.regexPattern)) {
            return -1;
        }
        if (this.regexPatternOrder == null) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(this.regexPattern, "|");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                list.add(s);
            }
            this.regexPatternOrder = list.toArray(new String[0]);
        }
        for (int i = 0; i < this.regexPatternOrder.length; ++i) {
            String s = this.regexPatternOrder[i];
            if (!propertyName.matches(s)) continue;
            return i;
        }
        return -1;
    }
}

