/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell.util;

import java.util.Arrays;
import java.util.Stack;

public class ShellUtils {
    public static String shellPatternToRegexp(String pattern) {
        String pathSeparator = "/";
        if (pattern == null) {
            pattern = "*";
        }
        char[] cc = pattern.toCharArray();
        StringBuilder sb = new StringBuilder("^");
        block7: for (int i = 0; i < cc.length; ++i) {
            char c = cc[i];
            switch (c) {
                case '!': 
                case '$': 
                case '+': 
                case '.': 
                case '{': 
                case '}': {
                    sb.append('\\').append(c);
                    continue block7;
                }
                case '\\': {
                    sb.append(c);
                    sb.append(cc[++i]);
                    continue block7;
                }
                case '[': {
                    while (i < cc.length) {
                        sb.append(cc[i]);
                        if (cc[i] != ']') continue;
                        continue block7;
                    }
                    continue block7;
                }
                case '?': {
                    sb.append("[^").append(pathSeparator).append("]");
                    continue block7;
                }
                case '*': {
                    if (i + 1 < cc.length && cc[i + 1] == '*') {
                        ++i;
                        sb.append(".*");
                        continue block7;
                    }
                    sb.append("[^").append(pathSeparator).append("]*");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('$');
        return sb.toString();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static String alignLeft(String s, int width) {
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            sb.append(s);
            int x = width - sb.length();
            if (x > 0) {
                sb.append(ShellUtils.fillString(' ', x));
            }
        }
        return sb.toString();
    }

    public static String alignRight(String s, int width) {
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            sb.append(s);
            int x = width - sb.length();
            if (x > 0) {
                sb.insert(0, ShellUtils.fillString(' ', x));
            }
        }
        return sb.toString();
    }

    public static String fillString(char x, int width) {
        char[] cc = new char[width];
        Arrays.fill(cc, x);
        return new String(cc);
    }

    public static String fillString(String pattern, int width) {
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("Empty Pattern");
        }
        char[] cc = new char[width];
        int len = pattern.length();
        for (int i = 0; i < cc.length; ++i) {
            cc[i] = pattern.charAt(i % len);
        }
        return new String(cc);
    }

    private static String repeat(char c, int count) {
        char[] a = new char[count];
        Arrays.fill(a, 0, count, c);
        return new String(a);
    }

    private static String repeatV(char c, int count) {
        char[] a = new char[2 * count - 1];
        for (int i = 0; i < count; i += 2) {
            a[i] = c;
            if (i + 1 >= a.length) continue;
            a[i + 1] = 10;
        }
        return new String(a);
    }

    public static boolean isFilePath(String path) {
        return path != null && path.indexOf(47) >= 0 && !path.contains("://");
    }

    public static String simpexpToRegexp(String pattern) {
        return ShellUtils.simpexpToRegexp(pattern, false);
    }

    public static String simpexpToRegexp(String pattern, boolean contains) {
        if (pattern == null) {
            pattern = "*";
        }
        char[] cc = pattern.toCharArray();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < cc.length; ++i) {
            char c = cc[i];
            switch (c) {
                case '!': 
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '|': {
                    sb.append('\\').append(c);
                    continue block4;
                }
                case '*': {
                    sb.append(".*");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (!contains) {
            sb.insert(0, '^');
            sb.append('$');
        }
        return sb.toString();
    }

    public static int readQuotes(char[] chars, int i, StringBuilder v) {
        Stack<Character> s = new Stack<Character>();
        s.push(Character.valueOf(chars[i]));
        int j = 0;
        while (i + j < chars.length && !s.isEmpty()) {
            switch (chars[i + j]) {
                case '\\': {
                    ++j;
                    break;
                }
                case '\"': {
                    if (((Character)s.peek()).equals(Character.valueOf('\"'))) {
                        s.pop();
                        break;
                    }
                    s.push(Character.valueOf('\"'));
                    break;
                }
                case '\'': {
                    if (((Character)s.peek()).equals(Character.valueOf('\''))) {
                        s.pop();
                        break;
                    }
                    s.push(Character.valueOf('\''));
                    break;
                }
                case '`': {
                    if (((Character)s.peek()).equals(Character.valueOf('`'))) {
                        s.pop();
                        break;
                    }
                    s.push(Character.valueOf('`'));
                }
            }
            v.append(chars[i + j]);
            ++j;
        }
        return i;
    }
}

