/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import net.thevpc.nuts.NutsGlob;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.toolbox.nsh.jshell.JShell;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellArgumentNode;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellCommandLineNode;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellCommandNode;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellNode;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellUniformException;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.Lexer;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.PreloadedLexer;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.Token;

public class Yaccer {
    private final Lexer lexer;
    private final LinkedList<JShellNode> buffer = new LinkedList();

    public Yaccer(Lexer lexer) {
        this.lexer = lexer;
    }

    public Iterable<JShellNode> nodes() {
        return () -> new Iterator<JShellNode>(){
            JShellNode n = null;

            @Override
            public boolean hasNext() {
                this.n = Yaccer.this.readNode();
                return this.n != null;
            }

            @Override
            public JShellNode next() {
                return this.n;
            }
        };
    }

    public JShellNode readNodeL0() {
        if (!this.buffer.isEmpty()) {
            return this.buffer.removeFirst();
        }
        Token u = this.getLexer().peekToken();
        if (u == null) {
            return null;
        }
        switch (u.type) {
            case "WHITE": {
                this.getLexer().skipWhites();
                return new WhiteNode(u);
            }
            case "NEWLINE": {
                u = this.getLexer().nextToken();
                return new NewlineNode(u);
            }
            case "#": {
                return this.readComments();
            }
            case "WORD": 
            case "$WORD": 
            case "\"": 
            case "'": 
            case "`": 
            case "$(": 
            case "$((": 
            case "${": 
            case "{": 
            case "=": 
            case ":": 
            case "&&": 
            case "&": 
            case "|": 
            case "||": 
            case "<": 
            case "<<": 
            case ">": 
            case ">>": 
            case "&>": 
            case "&>>": 
            case "&<": 
            case "&<<": 
            case "*": 
            case "?": {
                return new TokenNode(this.getLexer().nextToken());
            }
            case "(": {
                return this.readScriptPar();
            }
        }
        return new TokenNode(this.getLexer().nextToken());
    }

    private Lexer getLexer() {
        return this.lexer;
    }

    private JShellCommandNode readScriptL1() {
        Token not;
        Token u = this.getLexer().peekToken();
        if (u == null) {
            return null;
        }
        while ((not = this.getLexer().peekToken()) != null && (not.isNewline() || not.isEndCommand())) {
            this.getLexer().nextToken();
        }
        u = not;
        if (u == null) {
            return null;
        }
        if (u.type.equals("!")) {
            not = this.getLexer().nextToken();
            JShellCommandNode next = this.readScriptL1();
            return new UnOpPrefix(not, next);
        }
        if (u.type.equals("(")) {
            return this.readScriptPar();
        }
        if (u.type.equals("#")) {
            Comments c = this.readComments();
            JShellCommandNode next = this.readScriptL1();
            return new CommentedNode(next, c);
        }
        ArgumentsLine a = this.readScriptLine();
        if (a == null) {
            return a;
        }
        u = this.getLexer().peekToken();
        if (u == null) {
            return a;
        }
        switch (u.type) {
            case "&&": 
            case "||": {
                Token op = this.getLexer().nextToken();
                ArgumentsLine b = this.readScriptLine();
                if (b == null) {
                    return new UnOpSuffix(a, op);
                }
                return new BinOp(a, op, b);
            }
        }
        return a;
    }

    public JShellCommandNode readScriptL2() {
        JShellCommandNode a = this.readScriptL1();
        if (a == null) {
            return null;
        }
        block6: while (true) {
            Token u;
            if ((u = this.getLexer().peekToken()) == null) {
                return a;
            }
            switch (u.type) {
                case "|": {
                    Token op = this.getLexer().nextToken();
                    JShellCommandNode b = this.readScriptL1();
                    if (b == null) {
                        return new UnOpSuffix(a, op);
                    }
                    a = new BinOp(a, op, b);
                    continue block6;
                }
            }
            break;
        }
        return a;
    }

    public JShellCommandNode readScriptL3() {
        JShellCommandNode a = this.readScriptL2();
        if (a == null) {
            return null;
        }
        block6: while (true) {
            Token u;
            if ((u = this.getLexer().peekToken()) == null) {
                return a;
            }
            switch (u.type) {
                case "&": {
                    Token op = this.getLexer().nextToken();
                    JShellCommandNode b = this.readScriptL2();
                    if (b == null) {
                        return new UnOpSuffix(a, op);
                    }
                    a = new BinOp(a, op, b);
                    continue block6;
                }
            }
            break;
        }
        return a;
    }

    public JShellCommandNode readScriptL4() {
        JShellCommandNode a = this.readScriptL3();
        if (a == null) {
            return null;
        }
        block13: while (true) {
            Token u;
            if ((u = this.getLexer().peekToken()) == null) {
                return a;
            }
            switch (u.type) {
                case ">": 
                case ">>": 
                case "<": 
                case "<<": 
                case "&>": 
                case "&2>": 
                case "&>>": 
                case "&2>>": {
                    Token op = this.getLexer().nextToken();
                    JShellCommandNode b = this.readScriptL3();
                    if (b == null) {
                        return new UnOpSuffix(a, op);
                    }
                    a = new BinOp(a, op, b);
                    continue block13;
                }
            }
            break;
        }
        return a;
    }

    public JShellCommandNode readScriptL5() {
        JShellCommandNode a = null;
        Token sep = null;
        Token u;
        block7: while ((u = this.getLexer().peekToken()) != null) {
            switch (u.type) {
                case ";": 
                case "NEWLINE": {
                    sep = this.getLexer().nextToken();
                    continue block7;
                }
            }
            JShellCommandNode b = this.readScriptL4();
            if (b == null) {
                return a;
            }
            if (a == null) {
                a = b;
            } else {
                if (sep == null) {
                    sep = new Token("NEWLINE", "\n", "\n");
                }
                a = new BinOpCommand(a, sep, b);
            }
            sep = null;
        }
        return a;
    }

    public JShellNode readNodeL1() {
        JShellNode a = this.readNodeL0();
        if (a == null) {
            return a;
        }
        Token u = this.getLexer().peekToken();
        if (u == null) {
            return a;
        }
        switch (u.type) {
            case "&&": 
            case "&": {
                Token op = this.getLexer().nextToken();
                JShellNode b = this.readNodeL0();
                if (b == null) {
                    return new UnOpSuffix(a, op);
                }
                return new BinOp(a, op, b);
            }
        }
        return a;
    }

    public JShellNode readNodeL2() {
        JShellNode a = this.readNodeL1();
        if (a == null) {
            return a;
        }
        Token u = this.getLexer().peekToken();
        if (u == null) {
            return a;
        }
        switch (u.type) {
            case "||": 
            case "|": {
                Token op = this.getLexer().nextToken();
                JShellNode b = this.readNodeL1();
                if (b == null) {
                    return new UnOpSuffix(a, op);
                }
                return new BinOp(a, op, b);
            }
        }
        return a;
    }

    public JShellNode readNodeL3() {
        JShellNode a = this.readNodeL1();
        if (a == null) {
            return a;
        }
        Token u = this.getLexer().peekToken();
        if (u == null) {
            return a;
        }
        switch (u.type) {
            case ";": {
                Token op = this.getLexer().nextToken();
                JShellNode b = this.readNodeL1();
                if (b == null) {
                    return new UnOpSuffix(a, op);
                }
                return new BinOp(a, op, b);
            }
        }
        return a;
    }

    public JShellNode readNodeL4() {
        JShellNode a = this.readNodeL3();
        if (a == null) {
            return a;
        }
        Token u = this.getLexer().peekToken();
        if (u == null) {
            return a;
        }
        switch (u.type) {
            case ">": 
            case "&>": 
            case "<": 
            case "&<": {
                Token op = this.getLexer().nextToken();
                JShellNode b = this.readNodeL3();
                if (b == null) {
                    return new UnOpSuffix(a, op);
                }
                return new BinOp(a, op, b);
            }
        }
        return a;
    }

    public JShellNode readNodeL5() {
        JShellNode a = this.readNodeL4();
        if (a == null) {
            return null;
        }
        Token u = this.getLexer().peekToken();
        if (u == null) {
            return a;
        }
        switch (u.type) {
            case ";": {
                Token op = this.getLexer().nextToken();
                JShellNode b = this.readNodeL4();
                if (b == null) {
                    return new UnOpSuffix(a, op);
                }
                return new BinOp(a, op, b);
            }
        }
        return a;
    }

    public JShellNode readNode() {
        return this.readNodeL0();
    }

    public JShellCommandNode readScriptPar() {
        Token u = this.getLexer().peekToken();
        if (u == null) {
            return null;
        }
        if (u.type.equals("(")) {
            this.getLexer().nextToken();
            JShellCommandNode n = this.readScript();
            u = this.getLexer().peekToken();
            if (u == null || u.type.equals(")")) {
                if (u != null) {
                    this.getLexer().nextToken();
                }
                return new Par(n);
            }
            return new Par(n);
        }
        return null;
    }

    public JShellCommandNode readCommandL1() {
        this.getLexer().skipWhites();
        Token t = this.getLexer().peekToken();
        if (t == null) {
            return null;
        }
        JShellCommandNode line = this.readScriptLine();
        if (line == null) {
            return null;
        }
        boolean loop = true;
        while (loop) {
            loop = false;
            t = this.getLexer().peekToken();
            if (t == null) continue;
            switch (t.type) {
                case "<": 
                case ">": 
                case "<<": 
                case ">>": 
                case "&<": 
                case "&>": 
                case "&<<": 
                case "&>>": {
                    this.getLexer().nextToken();
                    ArgumentsLine next = this.readScriptLine();
                    if (next == null) {
                        line = new SuffixOpCommand(line, t);
                        break;
                    }
                    line = new BinOpCommand(line, t, next);
                    loop = true;
                    break;
                }
            }
        }
        return line;
    }

    public JShellCommandNode readCommandL2() {
        JShellCommandNode line = this.readCommandL1();
        if (line == null) {
            return null;
        }
        boolean loop = true;
        while (loop) {
            loop = false;
            Token t = this.getLexer().peekToken();
            if (t == null) continue;
            switch (t.type) {
                case "|": {
                    this.getLexer().nextToken();
                    JShellCommandNode next = this.readCommandL1();
                    if (next == null) {
                        line = new SuffixOpCommand(line, t);
                        break;
                    }
                    line = new BinOpCommand(line, t, next);
                    loop = true;
                }
            }
        }
        return line;
    }

    public JShellCommandNode readCommandL3() {
        JShellCommandNode line = this.readCommandL2();
        if (line == null) {
            return null;
        }
        boolean loop = true;
        while (loop) {
            loop = false;
            Token t = this.getLexer().peekToken();
            if (t == null) continue;
            switch (t.type) {
                case "&&": 
                case "||": {
                    this.getLexer().nextToken();
                    JShellCommandNode next = this.readCommandL2();
                    if (next == null) {
                        line = new SuffixOpCommand(line, t);
                        break;
                    }
                    line = new BinOpCommand(line, t, next);
                    loop = true;
                }
            }
        }
        return line;
    }

    private String getArgumentsLineFirstArgToken(JShellCommandNode line) {
        if (line != null) {
            Argument arg1 = ((ArgumentsLine)line).args.get(0);
            if (arg1.nodes.size() == 1 && arg1.nodes.get(0) instanceof TokenNode) {
                Token token = ((TokenNode)arg1.nodes.get((int)0)).token;
                if (token.type.equals("WORD")) {
                    return token.value.toString();
                }
            }
        }
        return "";
    }

    public ArgumentsLine readScriptLine() {
        Token t;
        ArrayList<Argument> a = new ArrayList<Argument>();
        while ((t = this.getLexer().peekToken()) != null) {
            boolean exit = false;
            switch (t.type) {
                case "NEWLINE": 
                case ";": 
                case "&": 
                case "&&": 
                case "<<": 
                case ">>": 
                case "&<": 
                case "&>": 
                case "&<<": 
                case "&>>": 
                case "|": 
                case "||": {
                    exit = true;
                }
            }
            if (exit) break;
            if (t.type.equals("WHITE")) {
                this.getLexer().nextToken();
                continue;
            }
            Argument aa = this.readArgument();
            if (aa != null) {
                a.add(aa);
                continue;
            }
            throw new IllegalArgumentException("Unexpected " + aa);
        }
        if (a.isEmpty()) {
            return null;
        }
        return new ArgumentsLine(a);
    }

    public JShellCommandNode readScript() {
        return this.readScriptL5();
    }

    public Comments readComments() {
        Token t;
        ArrayList<Token> ok = new ArrayList<Token>();
        while ((t = this.getLexer().peekToken()) != null && t.type.equals("#")) {
            this.getLexer().nextToken();
            ok.add(t);
        }
        if (ok.isEmpty()) {
            return null;
        }
        return new Comments(ok);
    }

    public Argument readArgument() {
        JShellNode n;
        Token t;
        ArrayList<JShellNode> a = new ArrayList<JShellNode>();
        while (!((t = this.getLexer().peekToken()) == null || t.type.equals("NEWLINE") || t.type.equals(";") || t.type.equals("#") && !a.isEmpty() || (n = this.readNode()) == null || n instanceof WhiteNode)) {
            a.add(n);
        }
        if (a.isEmpty()) {
            return null;
        }
        return new Argument(a);
    }

    public static String evalTokenString(Token token, JShellContext context) {
        NutsGlob g = NutsGlob.of((NutsSession)context.getSession());
        switch (token.type) {
            case "WORD": {
                return token.value.toString();
            }
            case "$WORD": {
                String s;
                switch (s = (String)token.value) {
                    case "0": {
                        return g.escape(context.getServiceName());
                    }
                    case "1": 
                    case "2": 
                    case "3": 
                    case "4": 
                    case "5": 
                    case "6": 
                    case "7": 
                    case "8": 
                    case "9": {
                        return g.escape(context.getArg(Integer.parseInt(s) - 1));
                    }
                    case "?": {
                        return g.escape(String.valueOf(context.getArgsCount()));
                    }
                }
                String y = context.vars().get(s, "");
                return g.escape(y);
            }
            case "`": 
            case "$(": {
                ArrayList<Token> subTokens = new ArrayList<Token>((Collection)token.value);
                if (subTokens.isEmpty()) {
                    return "";
                }
                Yaccer yy2 = new Yaccer(new PreloadedLexer(subTokens));
                JShellCommandNode subCommand = yy2.readScript();
                if (subCommand == null) {
                    return "";
                }
                return g.escape(context.getShell().getEvaluator().evalCommandAndReturnString(subCommand, context));
            }
            case "\"": {
                List s = (List)token.value;
                StringBuilder sb = new StringBuilder();
                for (Token token2 : s) {
                    sb.append(Yaccer.evalTokenString(token2, context));
                }
                return sb.toString();
            }
            case "'": {
                if (token.value instanceof String) {
                    return g.escape((String)token.value);
                }
                StringBuilder sb = new StringBuilder();
                for (Token t : (List)token.value) {
                    sb.append(g.escape(Yaccer.evalTokenString(t, context)));
                }
                return sb.toString();
            }
            case "STR": {
                return (String)token.value;
            }
            case "${": {
                StringBuilder sb = new StringBuilder();
                List values = (List)token.value;
                if (values.isEmpty()) {
                    throw new IllegalArgumentException("bad substitution");
                }
                String varVal = "";
                Token t = (Token)values.get(0);
                if (t.isWord()) {
                    String y = context.vars().get(Yaccer.evalTokenString(t, context), null);
                    if (y != null) {
                        varVal = y;
                    }
                } else {
                    throw new IllegalArgumentException("bad substitution");
                }
                sb.append(g.escape(varVal));
                return sb.toString();
            }
        }
        return (String)token.value;
    }

    public static String evalNodeString(JShellNode node, JShellContext context) {
        if (node instanceof Comments) {
            return "";
        }
        if (node instanceof TokenNode) {
            return ((TokenNode)node).evalString(context);
        }
        throw new RuntimeException("Error");
    }

    public class Comments
    implements JShellNode {
        List<Token> tokens;

        public Comments(List<Token> tokens) {
            this.tokens = tokens;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Token token : this.tokens) {
                sb.append(token.getImage());
            }
            return sb.toString();
        }
    }

    public static class Argument
    implements JShellArgumentNode {
        List<JShellNode> nodes;

        public Argument(List<JShellNode> nodes) {
            this.nodes = nodes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (JShellNode node : this.nodes) {
                sb.append(node);
            }
            return sb.toString();
        }

        @Override
        public String[] evalString(JShellContext context) {
            StringBuilder sb = new StringBuilder();
            for (JShellNode node : this.nodes) {
                sb.append(Yaccer.evalNodeString(node, context));
            }
            String value = sb.toString();
            if (value.equals("~")) {
                value = context.getHome();
            } else if (value.startsWith("~/") || value.startsWith("~\\")) {
                String c = context.getHome();
                value = c + value.substring(1);
            }
            boolean wasAntiSlash = false;
            boolean applyWildCard = false;
            StringBuilder sb2 = new StringBuilder();
            block5: for (char c : value.toCharArray()) {
                if (wasAntiSlash) {
                    wasAntiSlash = false;
                    sb2.append(c);
                    continue;
                }
                switch (c) {
                    case '\\': {
                        wasAntiSlash = true;
                        continue block5;
                    }
                    case '*': 
                    case '?': {
                        sb2.append(c);
                        applyWildCard = true;
                        continue block5;
                    }
                    default: {
                        sb2.append(c);
                    }
                }
            }
            if (applyWildCard) {
                String[] r;
                NutsPath pp = NutsPath.of((String)value, (NutsSession)context.getSession());
                if (!pp.isAbsolute()) {
                    pp = pp.toAbsolute(context.getCwd());
                }
                if ((r = (String[])pp.walkGlob(new NutsPathOption[0]).map(NutsPath::toString, "toString").toArray(String[]::new)).length > 0) {
                    return r;
                }
            }
            return new String[]{sb2.toString()};
        }
    }

    public class BinOp
    implements JShellCommandNode {
        JShellNode a;
        Token op;
        JShellNode b;

        public BinOp(JShellNode a, Token op, JShellNode b) {
            this.a = a;
            this.op = op;
            this.b = b;
        }

        public String toString() {
            return this.a + " " + this.op + " " + this.b;
        }

        @Override
        public int eval(JShellContext context) {
            throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.cstyle((String)"not yet implemented BinOp %s", (Object[])new Object[]{this.op.image}));
        }
    }

    public class UnOpPrefix
    implements JShellCommandNode {
        JShellNode a;
        Token op;

        public UnOpPrefix(Token op, JShellNode a) {
            this.a = a;
            this.op = op;
        }

        public String toString() {
            return this.op + " " + this.a;
        }

        @Override
        public int eval(JShellContext context) {
            throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.cstyle((String)"not yet implemented UnOpPrefix %s", (Object[])new Object[]{this.op.image}));
        }
    }

    public class CommentedNode
    implements JShellCommandNode {
        JShellNode a;
        List<Comments> comments = new ArrayList<Comments>();

        public CommentedNode(JShellNode a, Comments comments) {
            if (a instanceof CommentedNode) {
                this.a = ((CommentedNode)a).a;
                this.comments.add(comments);
                this.comments.addAll(((CommentedNode)a).comments);
            } else {
                this.a = a;
                this.comments.add(comments);
            }
        }

        @Override
        public int eval(JShellContext context) {
            if (this.a != null) {
                return context.getShell().evalNode((JShellCommandNode)this.a, context);
            }
            return 0;
        }

        public String toString() {
            return this.a.toString();
        }
    }

    public class UnOpSuffix
    implements JShellCommandNode {
        JShellNode a;
        Token op;

        public UnOpSuffix(JShellNode a, Token op) {
            this.a = a;
            this.op = op;
        }

        public String toString() {
            return this.a + " " + this.op;
        }

        @Override
        public int eval(JShellContext context) {
            throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.cstyle((String)"not yet implemented UnOpSuffix %s", (Object[])new Object[]{this.op.image}));
        }
    }

    public class Par
    implements JShellCommandNode {
        JShellNode element;

        public Par(JShellNode element) {
            this.element = element;
        }

        @Override
        public int eval(JShellContext context) {
            return context.getShell().evalNode((JShellCommandNode)this.element, context);
        }

        public String toString() {
            return "(" + this.element + ')';
        }
    }

    public static class ArgumentsLine
    implements JShellCommandLineNode {
        List<Argument> args;

        public ArgumentsLine(List<Argument> args) {
            this.args = args;
        }

        public List<Argument> getArgs() {
            return this.args;
        }

        @Override
        public Iterator<JShellArgumentNode> iterator() {
            return this.args.iterator();
        }

        @Override
        public int eval(JShellContext context) {
            List<JShellNode> anodes;
            Argument arg;
            JShell shell = context.getShell();
            ArrayList<String> cmds = new ArrayList<String>();
            LinkedHashMap<String, String> usingItems = new LinkedHashMap<String, String>();
            ArrayList<Argument> args2 = new ArrayList<Argument>(this.args);
            boolean source = false;
            if (args2.size() > 0) {
                arg = (Argument)args2.get(0);
                anodes = arg.nodes;
                if (anodes.size() == 1 && anodes.get(0) instanceof TokenNode && ((TokenNode)anodes.get((int)0)).token.type.equals(".")) {
                    source = true;
                    args2.remove(0);
                }
            }
            if (!source) {
                while (args2.size() > 0) {
                    CharSequence[] charSequenceArray;
                    arg = (Argument)args2.get(0);
                    anodes = arg.nodes;
                    if (anodes.size() < 2 || !(anodes.get(0) instanceof TokenNode) || !((TokenNode)anodes.get((int)0)).token.type.equals("WORD") || !(anodes.get(1) instanceof TokenNode) || !((TokenNode)anodes.get((int)1)).token.type.equals("=")) break;
                    String varName = ((TokenNode)anodes.get(0)).evalString(context);
                    if (anodes.size() > 2) {
                        charSequenceArray = new Argument(anodes.subList(2, anodes.size())).evalString(context);
                    } else {
                        CharSequence[] charSequenceArray2 = new String[1];
                        charSequenceArray = charSequenceArray2;
                        charSequenceArray2[0] = "";
                    }
                    CharSequence[] varValues = charSequenceArray;
                    usingItems.put(varName, String.join((CharSequence)" ", varValues));
                    args2.remove(0);
                }
            }
            for (Argument arg2 : args2) {
                cmds.addAll(Arrays.asList(arg2.evalString(context)));
            }
            if (source) {
                cmds.add(0, "source");
                return shell.executePreparedCommand(cmds.toArray(new String[0]), true, true, true, context);
            }
            if (cmds.isEmpty() || cmds.size() == 1 && ((String)cmds.get(0)).isEmpty()) {
                if (!usingItems.isEmpty()) {
                    context.vars().set(usingItems);
                }
            } else {
                if (!usingItems.isEmpty()) {
                    context = shell.createNewContext(context);
                    context.vars().set(context.vars());
                    context.vars().set(usingItems);
                }
                return shell.executePreparedCommand(cmds.toArray(new String[0]), true, true, true, context);
            }
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.args.size(); ++i) {
                Argument arg = this.args.get(i);
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(arg);
            }
            return sb.toString();
        }
    }

    public class WhileCommand
    implements JShellCommandNode {
        CondBloc _while;
        JShellCommandNode _do;
        JShellCommandNode _done;

        @Override
        public int eval(JShellContext context) {
            while (this._while.eval(context)) {
            }
            return 0;
        }
    }

    public class IfCommand
    implements JShellCommandNode {
        CondBloc _if;
        JShellCommandNode _then;
        List<CondBloc> _elif = new ArrayList<CondBloc>();
        JShellCommandNode _else;

        @Override
        public int eval(JShellContext context) {
            if (this._if.eval(context)) {
                return 0;
            }
            for (CondBloc condBloc : this._elif) {
                if (!condBloc.eval(context)) continue;
                return 0;
            }
            if (this._else != null) {
                return context.getShell().evalNode(this._else, context);
            }
            return 1;
        }
    }

    public class CondBloc {
        JShellCommandNode cond;
        JShellCommandNode block;

        public CondBloc(JShellCommandNode cond, JShellCommandNode block) {
            this.cond = cond;
            this.block = block;
        }

        public boolean eval(JShellContext context) {
            boolean trueCond = false;
            if (this.cond != null) {
                try {
                    context.getShell().evalNode(this.cond, context);
                    trueCond = true;
                }
                catch (JShellUniformException ex) {
                    if (ex.isQuit()) {
                        ex.throwQuit();
                    }
                    trueCond = false;
                }
                if (trueCond) {
                    if (this.block != null) {
                        context.getShell().evalNode(this.block, context);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    public class SuffixOpCommand
    implements JShellCommandNode {
        JShellCommandNode a;
        Token op;

        public SuffixOpCommand(JShellCommandNode a, Token op) {
            this.a = a;
            this.op = op;
        }

        @Override
        public int eval(JShellContext context) {
            switch (this.op.type) {
                case "&": {
                    return context.getShell().getEvaluator().evalSuffixAndOperation(this.a, context);
                }
            }
            throw new IllegalArgumentException("Unsupported yet");
        }
    }

    public static class BinOpCommand
    implements JShellCommandNode {
        JShellCommandNode left;
        Token op;
        JShellCommandNode right;

        public BinOpCommand(JShellCommandNode left, Token op, JShellCommandNode right) {
            this.left = left;
            this.op = op;
            this.right = right;
        }

        @Override
        public int eval(JShellContext context) {
            String cmd = this.op.type.equals("NEWLINE") ? ";" : String.valueOf(this.op.value);
            return context.getShell().getEvaluator().evalBinaryOperation(cmd, this.left, this.right, context);
        }

        public String toString() {
            return "(" + this.left + " " + this.op.value + this.right + ')';
        }
    }

    public static class TokenNode
    implements JShellNode {
        Token token;

        public TokenNode(Token token) {
            this.token = token;
        }

        public String evalString(JShellContext context) {
            return Yaccer.evalTokenString(this.token, context);
        }

        public String toString() {
            return String.valueOf(this.token.getImage());
        }
    }

    public class NewlineNode
    implements JShellNode {
        Token token;

        public NewlineNode(Token token) {
            this.token = token;
        }

        public String toString() {
            return String.valueOf(this.token.getImage());
        }
    }

    public class WhiteNode
    implements JShellNode {
        Token token;

        public WhiteNode(Token token) {
            this.token = token;
        }

        public String toString() {
            return String.valueOf(this.token.getImage());
        }
    }
}

