/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell.parser;

public class Token {
    public String type;
    public Object value;
    public String image;

    public Token(String type, Object value, String image) {
        this.type = type;
        this.value = value;
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public boolean isWord(String n) {
        return "WORD".equals(this.type) && n.equals(this.value);
    }

    public boolean isWord() {
        return "WORD".equals(this.type);
    }

    public boolean isWhite() {
        return "WHITE".equals(this.type);
    }

    public boolean isNewline() {
        return "NEWLINE".equals(this.type);
    }

    public boolean isEndCommand() {
        return ";".equals(this.type);
    }

    public String toKeyStr(String s) {
        StringBuilder sb = new StringBuilder();
        block11: for (char c : s.toCharArray()) {
            switch (c) {
                case '(': {
                    sb.append("<OPAR>");
                    continue block11;
                }
                case ')': {
                    sb.append("<CPAR>");
                    continue block11;
                }
                case '[': {
                    sb.append("<OSBRACK>");
                    continue block11;
                }
                case ']': {
                    sb.append("<CSBRACK>");
                    continue block11;
                }
                case '{': {
                    sb.append("<OCBRACK>");
                    continue block11;
                }
                case '}': {
                    sb.append("<CCBRACK>");
                    continue block11;
                }
                case '\"': {
                    sb.append("<DQTE>");
                    continue block11;
                }
                case '\'': {
                    sb.append("<SQTE>");
                    continue block11;
                }
                case '`': {
                    sb.append("<AQTE>");
                    continue block11;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public String toStr(String s) {
        StringBuilder sb = new StringBuilder();
        block4: for (char c : s.toCharArray()) {
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block4;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        String v;
        String k = this.toKeyStr(this.type);
        if (k.equals(v = this.toStr(String.valueOf(this.value)))) {
            return k;
        }
        return this.toKeyStr(this.type) + "(" + this.toStr(String.valueOf(this.value)) + ')';
    }
}

