/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Iterator;

public class StrReader {
    Reader reader;
    private boolean uniformNewLine = true;
    private StringBuilder buffer = new StringBuilder();

    public void pushBackChar(char c) {
        this.buffer.insert(0, c);
    }

    public int getChar(int pos) {
        if (pos >= this.buffer.length()) {
            while (this.fillLine() > 0 && pos >= this.buffer.length()) {
            }
        }
        if (pos >= this.buffer.length()) {
            return -1;
        }
        return this.buffer.charAt(pos);
    }

    public boolean readString(String str) {
        if (this.isString(str, 0)) {
            this.readAll(str.length());
            return true;
        }
        return false;
    }

    public boolean isString(String str, int pos) {
        for (int i = 0; i < str.length(); ++i) {
            if (this.isChar(str.charAt(i), pos + i)) continue;
            return false;
        }
        return true;
    }

    public boolean isChar(char c, int pos) {
        return this.getChar(pos) == c;
    }

    public boolean isWordChar(int c) {
        if (c == -1) {
            return false;
        }
        switch (c) {
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 91: 
            case 92: 
            case 93: 
            case 96: 
            case 123: 
            case 124: 
            case 125: {
                return false;
            }
        }
        return c > 32;
    }

    public Reader toReader() {
        return new Reader(){

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return StrReader.this.read(cbuf, off, len);
            }

            @Override
            public void close() throws IOException {
                StrReader.this.close();
            }
        };
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        boolean x = false;
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                return i;
            }
            cbuf[off + i] = (char)c;
        }
        return len;
    }

    public Iterable<String> lines() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    String line;

                    @Override
                    public boolean hasNext() {
                        this.line = StrReader.this.readLine();
                        return this.line != null;
                    }

                    @Override
                    public String next() {
                        return this.line;
                    }
                };
            }
        };
    }

    public String readLine() {
        int r;
        StringBuilder sb = new StringBuilder();
        while ((r = this.read()) >= 0) {
            sb.append((char)r);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public int peekChar() {
        if (this.buffer.length() == 0) {
            this.fillLine();
        }
        if (this.buffer.length() > 0) {
            return this.buffer.charAt(0);
        }
        return -1;
    }

    public int read() {
        if (this.buffer.length() == 0) {
            this.fillLine();
        }
        if (this.buffer.length() > 0) {
            char c = this.buffer.charAt(0);
            this.buffer.deleteCharAt(0);
            return c;
        }
        return -1;
    }

    private int read0() {
        try {
            return this.reader.read();
        }
        catch (IOException e) {
            return -1;
        }
    }

    private int fillLine() {
        int e;
        int count = 0;
        while ((e = this.read0()) != -1) {
            int e2;
            ++count;
            if (e == 92) {
                e2 = this.read0();
                if (e2 == -1) {
                    this.buffer.append('\\');
                    break;
                }
                if (e2 == 10) {
                    ++count;
                    break;
                }
                if (e2 == 13) {
                    ++count;
                    e2 = this.read0();
                    if (e2 == 10) {
                        ++count;
                        break;
                    }
                    if (e2 == -1) break;
                    ++count;
                    this.buffer.append((char)e2);
                    break;
                }
                ++count;
                this.buffer.append('\\');
                this.buffer.append((char)e2);
                continue;
            }
            if (e == 13) {
                e2 = this.read0();
                if (e2 == -1) {
                    if (this.uniformNewLine) {
                        this.buffer.append('\n');
                        break;
                    }
                    this.buffer.append("\r");
                    break;
                }
                if (e2 == 10) {
                    ++count;
                    if (this.uniformNewLine) {
                        this.buffer.append('\n');
                        break;
                    }
                    this.buffer.append("\r\n");
                    break;
                }
                ++count;
                this.buffer.append((char)e2);
                continue;
            }
            ++count;
            this.buffer.append((char)e);
        }
        return count;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String readAll(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int r = this.read();
            if (r < 0) {
                throw new IllegalArgumentException("Invalid");
            }
            sb.append((char)r);
        }
        return sb.toString();
    }
}

